Domino session closeout. Package everything for StreamRift and push.

This is Domino's **save button**. When this runs, the session is done and code ships to domino.dev.g1.newbx.com.

**Process:**

### 1. Session Summary

Summarize what Domino worked on this session in 3-5 bullet points. Be specific — name files, features, bugs.

### 2. Quick Health Check

Run `npm run dashboard:check` to verify typecheck + lint pass.

- If it passes: great, continue.
- If it fails: **warn Domino** but don't block. The push will still work. Note the failures in the handoff.

### 3. Scan for TODO(domino) Markers

Search the codebase for `TODO(domino)` markers:

```
Grep pattern="TODO(domino)" path="apps/" glob="*.{ts,tsx}"
```

List all markers found — these tell StreamRift where incomplete work lives.

### 4. Write Session Summary

Create `docs/domino/session-{today's date}.md`:

```markdown
# Session: {date}

## What was worked on
- {bullet points from step 1}

## Files changed
{list of files from git diff --name-only}

## Incomplete work (TODO markers)
{list from step 3}

## Build status
{pass/fail + any warnings}

## Notes for StreamRift
{anything Domino wants to communicate — intent, concerns, questions, ideas}
```

If there's already a session file for today, append to it with a timestamp separator.

### 5. Write Handoff Manifest

Create `docs/domino/handoff-{today's date}.md`:

```markdown
# Handoff: {date} — {one-line summary}

## Changes (scan fast)
{for each commit since last handoff: - type: description — files: [list]}

## Intent (understand why)
{2-3 sentences on what Domino was trying to achieve overall}

## Incomplete (know where to dig)
{checklist of TODO(domino) items with file:line references}

## Notes for StreamRift
{context, concerns, questions — anything that helps Forge integrate this work}
```

### 6. Stage and Commit

Stage all changes including the session docs:

```bash
git add -A
```

Commit with a descriptive message:

```
docs: wrap session — {one-line summary of what was done}

{session summary bullets}

Co-Authored-By: Spark (Cursor AI)
```

### 7. Push

```bash
git push origin domino-0
```

### 8. Report

Tell Domino:

```
Push complete. Your update is on its way to StreamRift.

Deploy status: https://domino.dev.g1.newbx.com/status.html
Dashboard: https://domino.dev.g1.newbx.com/

Session summary saved to: docs/domino/session-{date}.md
Handoff manifest saved to: docs/domino/handoff-{date}.md

{count} TODO(domino) markers for StreamRift to review.
{count} files changed this session.
```

### 9. Done

Session over. Domino can close the editor.
