Welcome flow for a new developer joining the Galactus project.

This is the first-time setup experience. You're meeting a new teammate and configuring their environment.

**Process:**

### 1. Welcome

Say something like:

"Hey! Welcome to Galactus. I'm here to help you build. Let's get you set up — I'll ask a few questions to learn how you work, then we'll make sure everything runs."

### 2. Interview

Ask these questions using the AskUserQuestion tool. Adapt based on their answers — skip questions that don't apply, ask follow-ups if something is interesting.

**Identity:**
- What should I call you? (name/handle)
- What's your role? (quant, engineer, designer, etc.)

**Tooling:**
- What editor/IDE are you using? (Cursor, VS Code, vim, etc.)
- What OS are you on? (Mac, Linux, Windows)
- How comfortable are you with git? (beginner / comfortable / expert)
- How comfortable are you with the terminal? (beginner / comfortable / expert)

**Working Style:**
- How do you like to communicate with AI assistants? (verbose explanations / terse and fast / visual diagrams / just show me code)
- When you're stuck, what do you prefer? (figure it out yourself / ask for help immediately / try for 10 min then ask)
- Do you prefer to understand the whole system before changing anything, or dive in and learn by doing?

**Goals:**
- What are you most excited to work on? (new features / bug fixes / data/quant work / UI polish / backend)
- Any specific features from the backlog that caught your eye?
- Anything you definitely DON'T want to deal with?

### 3. Write Profile

Save the interview results to `docs/domino/profile.md`:

```markdown
# Developer Profile: {name}

**Role:** {role}
**Editor:** {editor}
**OS:** {os}
**Git comfort:** {level}
**Terminal comfort:** {level}

## Working Style
- Communication: {preference}
- When stuck: {preference}
- Learning style: {preference}

## Interests
- Excited about: {list}
- Want to avoid: {list}

## Notes
{any other observations from the interview}

---
*Profile created: {date}*
*Updated by: /get-started*
```

### 4. Rotate SSH Keys

The zip includes bootstrap SSH keys that work immediately. Now generate personal keys so the bootstrap ones can be retired.

**Run these commands:**

```bash
# Generate a new personal keypair
ssh-keygen -t ed25519 -C "domino@galactus" -f ~/.ssh/g1_domino_personal -N ""

# Read the new public key
NEW_PUBKEY=$(cat ~/.ssh/g1_domino_personal.pub)

# SSH in with the bootstrap key and swap the keys on the server
ssh g1 "sed -i '/domino@galactus-bootstrap/d' ~/.ssh/authorized_keys && echo '$NEW_PUBKEY' >> ~/.ssh/authorized_keys"

# Update local SSH config to use the new key
sed -i.bak 's|IdentityFile ~/.ssh/g1_domino|IdentityFile ~/.ssh/g1_domino_personal|' ~/.ssh/config

# Test the new key works
ssh g1 "echo 'Personal key works!'"

# Clean up bootstrap keys
rm -f ~/.ssh/g1_domino ~/.ssh/g1_domino.pub
rm -rf .ssh-bootstrap
```

If the rotation succeeds, confirm: "Your SSH keys have been rotated. The bootstrap key has been retired and your personal key is active."

If it fails at any step, stop and explain what happened. The bootstrap key still works — nothing is broken. They can retry or ask StreamRift for help.

### 5. Verify Setup

Walk through setup verification:

```bash
# Check we're on the right branch
git branch --show-current  # Should be domino-0

# Check dependencies are installed
npm install

# Check the build works
npm run dashboard:check

# Check the dev server starts (suggest but don't force)
# npm run dashboard:dev  → localhost:5173
```

If anything fails, help them fix it. Be patient — they may be new to this stack.

### 6. Quick Tour

Give a 30-second overview of the key files:

- `App.tsx` — where everything starts
- `lib/kalshiApi.ts` — how we talk to Kalshi
- `lib/polymarket/` — how we talk to Polymarket
- `components/atoms/` — reusable UI pieces (Dropdown, Toggle, Money, Modal)
- `sportsDiscovery/` → `sportsStream/` — how market data flows

Don't overwhelm — just enough to orient.

### 7. First Task

Ask: "What do you want to build first?"

If they have an idea, help them start. If they don't, suggest:
- Browse `docs/backlog.md` for feature ideas
- Pick something small to get a feel for the codebase
- Start with a bug fix to learn the code paths

### 8. Remind

Before signing off, remind them:

- **To deploy:** just `git push origin domino-0` — auto-deploys to domino.dev.g1.newbx.com
- **To save a session:** type `/domino-wrap-it` — packages everything and pushes
- **If stuck:** push what you have with `wip:` prefix, message StreamRift
- **Deploy status:** domino.dev.g1.newbx.com/status.html

"You're all set. Happy building!"
