# Galactus One

Unified monorepo: Galactus Dashboard (frontend) and Galactus Relay (transport).

## Architecture

- **Galactus Dashboard** – React + Vite SPA that holds keys, signs requests, and renders UI
- **Galactus Relay** – Express + WebSocket server that forwards bytes to/from external APIs (CORS solution)
- **@galactus/shared** – Shared types and utilities consumed by both apps

## Quick Start

```bash
# Install dependencies (from repo root)
npm install

# Terminal 1: Start relay server
npm run relay:dev
# → http://localhost:8787/health

# Terminal 2: Start dashboard
npm run dashboard:dev
# → http://localhost:5173
```

## Project Structure

| Path               | Description                                                        |
| ------------------ | ------------------------------------------------------------------ |
| `apps/dashboard/`  | [Galactus Dashboard](apps/dashboard/README.md) – React + Vite UI   |
| `apps/relay/`      | [Galactus Relay](apps/relay/README.md) – Express + WebSocket relay |
| `packages/shared/` | Shared types and utilities                                         |
| `docs/`            | Monorepo-wide documentation                                        |

## Scripts (from root)

| Script                    | Description                                   |
| ------------------------- | --------------------------------------------- |
| `npm run dashboard:dev`   | Build shared, then start dashboard dev server |
| `npm run relay:dev`       | Build shared, then start relay dev server     |
| `npm run dashboard:build` | Build dashboard for production                |
| `npm run relay:build`     | Build relay for production                    |
| `npm run dashboard:test`  | Run dashboard tests                           |
| `npm run relay:test`      | Run relay tests                               |
| `npm run build`           | Build all workspaces                          |
| `npm run test`            | Run tests in all workspaces                   |
| `npm run lint`            | Lint all workspaces                           |
| `npm run lint:fix`        | Lint and auto-fix all workspaces              |

## Configuration

See the `.env.example` files in each app for environment variables:

- [`apps/dashboard/.env.example`](apps/dashboard/.env.example)
- [`apps/relay/.env.example`](apps/relay/.env.example)
