import __buffer_polyfill from 'vite-plugin-node-polyfills/shims/buffer'
globalThis.Buffer = globalThis.Buffer || __buffer_polyfill
import __global_polyfill from 'vite-plugin-node-polyfills/shims/global'
globalThis.global = globalThis.global || __global_polyfill
import __process_polyfill from 'vite-plugin-node-polyfills/shims/process'
globalThis.process = globalThis.process || __process_polyfill

import {
  Chi,
  HashMD,
  Maj,
  secp256k1,
  sha256
} from "./chunk-O6QQ3ACN.js";
import {
  AbiDecodingZeroDataError,
  BaseError,
  BaseError2,
  BytesSizeMismatchError,
  ChainMismatchError,
  ChainNotFoundError,
  ContractFunctionExecutionError,
  ContractFunctionRevertedError,
  ContractFunctionZeroDataError,
  IntegerOutOfRangeError,
  InternalRpcError,
  InvalidAddressError,
  InvalidInputRpcError,
  InvalidSerializableTransactionError,
  LruMap,
  RawContractError,
  RpcRequestError,
  TransactionExecutionError,
  UnknownNodeError,
  assertRequest,
  bytesRegex,
  bytesToHex,
  checksumAddress,
  concat,
  concat2,
  concatHex,
  createCursor,
  defineFormatter,
  encodeAbiParameters,
  encodeFunctionData,
  extract,
  formatAbiParameters,
  formatEther,
  formatGwei,
  formatTransactionRequest,
  from,
  from2,
  fromBoolean,
  fromBytes,
  fromHex,
  fromNumber,
  fromString,
  fromString2,
  getNodeError,
  hexToBigInt,
  hexToBytes,
  hexToNumber,
  integerRegex,
  isAddress,
  isHex,
  keccak256,
  keccak_256,
  numberToHex,
  padLeft,
  padRight,
  parseAbiParameters,
  parseAccount,
  prettyPrint,
  serializeStateOverride,
  size,
  size2,
  size3,
  slice,
  slice2,
  stringify,
  stringify2,
  toBigInt,
  toBoolean,
  toBytes,
  toHex,
  toNumber,
  toNumber2,
  toString,
  trimLeft,
  trimLeft2,
  validate,
  validate2
} from "./chunk-PINHVN6U.js";
import {
  clean,
  createHasher,
  rotl
} from "./chunk-J5EJ7GZI.js";
import {
  parseUnits
} from "./chunk-NWSKNJAN.js";
import "./chunk-EPK6WHN2.js";
import "./chunk-SV5EBYZL.js";
import {
  __commonJS,
  __export,
  __publicField,
  __toESM,
  require_dist,
  require_dist2,
  require_dist3
} from "./chunk-IXGFG7BL.js";

// ../../node_modules/browser-or-node/lib/index.js
var require_lib = __commonJS({
  "../../node_modules/browser-or-node/lib/index.js"(exports) {
    "use strict";
    var import_dist1042 = __toESM(require_dist());
    var import_dist1043 = __toESM(require_dist2());
    var import_dist1044 = __toESM(require_dist3());
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function(obj) {
      return typeof obj;
    } : function(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
    var isBrowser2 = typeof window !== "undefined" && typeof window.document !== "undefined";
    var isNode = typeof process !== "undefined" && process.versions != null && process.versions.node != null;
    var isWebWorker = (typeof self === "undefined" ? "undefined" : _typeof(self)) === "object" && self.constructor && self.constructor.name === "DedicatedWorkerGlobalScope";
    var isJsDom = typeof window !== "undefined" && window.name === "nodejs" || typeof navigator !== "undefined" && (navigator.userAgent.includes("Node.js") || navigator.userAgent.includes("jsdom"));
    var isDeno = typeof Deno !== "undefined" && typeof Deno.version !== "undefined" && typeof Deno.version.deno !== "undefined";
    exports.isBrowser = isBrowser2;
    exports.isWebWorker = isWebWorker;
    exports.isNode = isNode;
    exports.isJsDom = isJsDom;
    exports.isDeno = isDeno;
  }
});

// ../../node_modules/@polymarket/clob-client/dist/index.js
var import_dist1039 = __toESM(require_dist());
var import_dist1040 = __toESM(require_dist2());
var import_dist1041 = __toESM(require_dist3());

// ../../node_modules/@polymarket/clob-client/dist/client.js
var import_dist1030 = __toESM(require_dist(), 1);
var import_dist1031 = __toESM(require_dist2(), 1);
var import_dist1032 = __toESM(require_dist3(), 1);

// ../../node_modules/@polymarket/order-utils/dist/index.js
var import_dist832 = __toESM(require_dist());
var import_dist833 = __toESM(require_dist2());
var import_dist834 = __toESM(require_dist3());

// ../../node_modules/@polymarket/order-utils/dist/exchange.order.builder.js
var import_dist817 = __toESM(require_dist(), 1);
var import_dist818 = __toESM(require_dist2(), 1);
var import_dist819 = __toESM(require_dist3(), 1);

// ../../node_modules/@polymarket/order-utils/dist/exchange.order.const.js
var import_dist = __toESM(require_dist(), 1);
var import_dist2 = __toESM(require_dist2(), 1);
var import_dist3 = __toESM(require_dist3(), 1);
var PROTOCOL_NAME = "Polymarket CTF Exchange";
var PROTOCOL_VERSION = "1";
var EIP712_DOMAIN = [
  { name: "name", type: "string" },
  { name: "version", type: "string" },
  { name: "chainId", type: "uint256" },
  { name: "verifyingContract", type: "address" }
];
var ORDER_STRUCTURE = [
  { name: "salt", type: "uint256" },
  { name: "maker", type: "address" },
  { name: "signer", type: "address" },
  { name: "taker", type: "address" },
  { name: "tokenId", type: "uint256" },
  { name: "makerAmount", type: "uint256" },
  { name: "takerAmount", type: "uint256" },
  { name: "expiration", type: "uint256" },
  { name: "nonce", type: "uint256" },
  { name: "feeRateBps", type: "uint256" },
  { name: "side", type: "uint8" },
  { name: "signatureType", type: "uint8" }
];

// ../../node_modules/viem/_esm/index.js
var import_dist808 = __toESM(require_dist());
var import_dist809 = __toESM(require_dist2());
var import_dist810 = __toESM(require_dist3());

// ../../node_modules/viem/_esm/actions/getContract.js
var import_dist187 = __toESM(require_dist(), 1);
var import_dist188 = __toESM(require_dist2(), 1);
var import_dist189 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/getAction.js
var import_dist4 = __toESM(require_dist(), 1);
var import_dist5 = __toESM(require_dist2(), 1);
var import_dist6 = __toESM(require_dist3(), 1);
function getAction(client, actionFn, name) {
  const action_implicit = client[actionFn.name];
  if (typeof action_implicit === "function")
    return action_implicit;
  const action_explicit = client[name];
  if (typeof action_explicit === "function")
    return action_explicit;
  return (params) => actionFn(client, params);
}

// ../../node_modules/viem/_esm/actions/public/createContractEventFilter.js
var import_dist16 = __toESM(require_dist(), 1);
var import_dist17 = __toESM(require_dist2(), 1);
var import_dist18 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/abi/encodeEventTopics.js
var import_dist10 = __toESM(require_dist(), 1);
var import_dist11 = __toESM(require_dist2(), 1);
var import_dist12 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/errors/log.js
var import_dist7 = __toESM(require_dist(), 1);
var import_dist8 = __toESM(require_dist2(), 1);
var import_dist9 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/filters/createFilterRequestScope.js
var import_dist13 = __toESM(require_dist(), 1);
var import_dist14 = __toESM(require_dist2(), 1);
var import_dist15 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/estimateContractGas.js
var import_dist124 = __toESM(require_dist(), 1);
var import_dist125 = __toESM(require_dist2(), 1);
var import_dist126 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/errors/getContractError.js
var import_dist19 = __toESM(require_dist(), 1);
var import_dist20 = __toESM(require_dist2(), 1);
var import_dist21 = __toESM(require_dist3(), 1);
var EXECUTION_REVERTED_ERROR_CODE = 3;
function getContractError(err, { abi, address, args, docsPath, functionName, sender }) {
  const error = err instanceof RawContractError ? err : err instanceof BaseError ? err.walk((err2) => "data" in err2) || err.walk() : {};
  const { code, data, details, message, shortMessage } = error;
  const cause = (() => {
    if (err instanceof AbiDecodingZeroDataError)
      return new ContractFunctionZeroDataError({ functionName });
    if ([EXECUTION_REVERTED_ERROR_CODE, InternalRpcError.code].includes(code) && (data || details || message || shortMessage) || code === InvalidInputRpcError.code && details === "execution reverted" && data) {
      return new ContractFunctionRevertedError({
        abi,
        data: typeof data === "object" ? data.data : data,
        functionName,
        message: error instanceof RpcRequestError ? details : shortMessage ?? message
      });
    }
    return err;
  })();
  return new ContractFunctionExecutionError(cause, {
    abi,
    args,
    contractAddress: address,
    docsPath,
    functionName,
    sender
  });
}

// ../../node_modules/viem/_esm/actions/public/estimateGas.js
var import_dist121 = __toESM(require_dist(), 1);
var import_dist122 = __toESM(require_dist2(), 1);
var import_dist123 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/authorization/recoverAuthorizationAddress.js
var import_dist37 = __toESM(require_dist(), 1);
var import_dist38 = __toESM(require_dist2(), 1);
var import_dist39 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/recoverAddress.js
var import_dist28 = __toESM(require_dist(), 1);
var import_dist29 = __toESM(require_dist2(), 1);
var import_dist30 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/accounts/utils/publicKeyToAddress.js
var import_dist22 = __toESM(require_dist(), 1);
var import_dist23 = __toESM(require_dist2(), 1);
var import_dist24 = __toESM(require_dist3(), 1);
function publicKeyToAddress(publicKey) {
  const address = keccak256(`0x${publicKey.substring(4)}`).substring(26);
  return checksumAddress(`0x${address}`);
}

// ../../node_modules/viem/_esm/utils/signature/recoverPublicKey.js
var import_dist25 = __toESM(require_dist(), 1);
var import_dist26 = __toESM(require_dist2(), 1);
var import_dist27 = __toESM(require_dist3(), 1);
async function recoverPublicKey({ hash: hash2, signature }) {
  const hashHex = isHex(hash2) ? hash2 : toHex(hash2);
  const { secp256k1: secp256k12 } = await import("./secp256k1-FEYKAKVQ.js");
  const signature_ = (() => {
    if (typeof signature === "object" && "r" in signature && "s" in signature) {
      const { r, s, v, yParity } = signature;
      const yParityOrV2 = Number(yParity ?? v);
      const recoveryBit2 = toRecoveryBit(yParityOrV2);
      return new secp256k12.Signature(hexToBigInt(r), hexToBigInt(s)).addRecoveryBit(recoveryBit2);
    }
    const signatureHex = isHex(signature) ? signature : toHex(signature);
    if (size(signatureHex) !== 65)
      throw new Error("invalid signature length");
    const yParityOrV = hexToNumber(`0x${signatureHex.slice(130)}`);
    const recoveryBit = toRecoveryBit(yParityOrV);
    return secp256k12.Signature.fromCompact(signatureHex.substring(2, 130)).addRecoveryBit(recoveryBit);
  })();
  const publicKey = signature_.recoverPublicKey(hashHex.substring(2)).toHex(false);
  return `0x${publicKey}`;
}
function toRecoveryBit(yParityOrV) {
  if (yParityOrV === 0 || yParityOrV === 1)
    return yParityOrV;
  if (yParityOrV === 27)
    return 0;
  if (yParityOrV === 28)
    return 1;
  throw new Error("Invalid yParityOrV value");
}

// ../../node_modules/viem/_esm/utils/signature/recoverAddress.js
async function recoverAddress({ hash: hash2, signature }) {
  return publicKeyToAddress(await recoverPublicKey({ hash: hash2, signature }));
}

// ../../node_modules/viem/_esm/utils/authorization/hashAuthorization.js
var import_dist34 = __toESM(require_dist(), 1);
var import_dist35 = __toESM(require_dist2(), 1);
var import_dist36 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/encoding/toRlp.js
var import_dist31 = __toESM(require_dist(), 1);
var import_dist32 = __toESM(require_dist2(), 1);
var import_dist33 = __toESM(require_dist3(), 1);
function toRlp(bytes, to = "hex") {
  const encodable = getEncodable(bytes);
  const cursor = createCursor(new Uint8Array(encodable.length));
  encodable.encode(cursor);
  if (to === "hex")
    return bytesToHex(cursor.bytes);
  return cursor.bytes;
}
function getEncodable(bytes) {
  if (Array.isArray(bytes))
    return getEncodableList(bytes.map((x) => getEncodable(x)));
  return getEncodableBytes(bytes);
}
function getEncodableList(list) {
  const bodyLength = list.reduce((acc, x) => acc + x.length, 0);
  const sizeOfBodyLength = getSizeOfLength(bodyLength);
  const length = (() => {
    if (bodyLength <= 55)
      return 1 + bodyLength;
    return 1 + sizeOfBodyLength + bodyLength;
  })();
  return {
    length,
    encode(cursor) {
      if (bodyLength <= 55) {
        cursor.pushByte(192 + bodyLength);
      } else {
        cursor.pushByte(192 + 55 + sizeOfBodyLength);
        if (sizeOfBodyLength === 1)
          cursor.pushUint8(bodyLength);
        else if (sizeOfBodyLength === 2)
          cursor.pushUint16(bodyLength);
        else if (sizeOfBodyLength === 3)
          cursor.pushUint24(bodyLength);
        else
          cursor.pushUint32(bodyLength);
      }
      for (const { encode: encode6 } of list) {
        encode6(cursor);
      }
    }
  };
}
function getEncodableBytes(bytesOrHex) {
  const bytes = typeof bytesOrHex === "string" ? hexToBytes(bytesOrHex) : bytesOrHex;
  const sizeOfBytesLength = getSizeOfLength(bytes.length);
  const length = (() => {
    if (bytes.length === 1 && bytes[0] < 128)
      return 1;
    if (bytes.length <= 55)
      return 1 + bytes.length;
    return 1 + sizeOfBytesLength + bytes.length;
  })();
  return {
    length,
    encode(cursor) {
      if (bytes.length === 1 && bytes[0] < 128) {
        cursor.pushBytes(bytes);
      } else if (bytes.length <= 55) {
        cursor.pushByte(128 + bytes.length);
        cursor.pushBytes(bytes);
      } else {
        cursor.pushByte(128 + 55 + sizeOfBytesLength);
        if (sizeOfBytesLength === 1)
          cursor.pushUint8(bytes.length);
        else if (sizeOfBytesLength === 2)
          cursor.pushUint16(bytes.length);
        else if (sizeOfBytesLength === 3)
          cursor.pushUint24(bytes.length);
        else
          cursor.pushUint32(bytes.length);
        cursor.pushBytes(bytes);
      }
    }
  };
}
function getSizeOfLength(length) {
  if (length < 2 ** 8)
    return 1;
  if (length < 2 ** 16)
    return 2;
  if (length < 2 ** 24)
    return 3;
  if (length < 2 ** 32)
    return 4;
  throw new BaseError("Length is too large.");
}

// ../../node_modules/viem/_esm/utils/authorization/hashAuthorization.js
function hashAuthorization(parameters) {
  const { chainId, nonce, to } = parameters;
  const address = parameters.contractAddress ?? parameters.address;
  const hash2 = keccak256(concatHex([
    "0x05",
    toRlp([
      chainId ? numberToHex(chainId) : "0x",
      address,
      nonce ? numberToHex(nonce) : "0x"
    ])
  ]));
  if (to === "bytes")
    return hexToBytes(hash2);
  return hash2;
}

// ../../node_modules/viem/_esm/utils/authorization/recoverAuthorizationAddress.js
async function recoverAuthorizationAddress(parameters) {
  const { authorization, signature } = parameters;
  return recoverAddress({
    hash: hashAuthorization(authorization),
    signature: signature ?? authorization
  });
}

// ../../node_modules/viem/_esm/utils/errors/getEstimateGasError.js
var import_dist43 = __toESM(require_dist(), 1);
var import_dist44 = __toESM(require_dist2(), 1);
var import_dist45 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/errors/estimateGas.js
var import_dist40 = __toESM(require_dist(), 1);
var import_dist41 = __toESM(require_dist2(), 1);
var import_dist42 = __toESM(require_dist3(), 1);
var EstimateGasExecutionError = class extends BaseError {
  constructor(cause, { account, docsPath, chain, data, gas, gasPrice, maxFeePerGas, maxPriorityFeePerGas, nonce, to, value }) {
    var _a;
    const prettyArgs = prettyPrint({
      from: account == null ? void 0 : account.address,
      to,
      value: typeof value !== "undefined" && `${formatEther(value)} ${((_a = chain == null ? void 0 : chain.nativeCurrency) == null ? void 0 : _a.symbol) || "ETH"}`,
      data,
      gas,
      gasPrice: typeof gasPrice !== "undefined" && `${formatGwei(gasPrice)} gwei`,
      maxFeePerGas: typeof maxFeePerGas !== "undefined" && `${formatGwei(maxFeePerGas)} gwei`,
      maxPriorityFeePerGas: typeof maxPriorityFeePerGas !== "undefined" && `${formatGwei(maxPriorityFeePerGas)} gwei`,
      nonce
    });
    super(cause.shortMessage, {
      cause,
      docsPath,
      metaMessages: [
        ...cause.metaMessages ? [...cause.metaMessages, " "] : [],
        "Estimate Gas Arguments:",
        prettyArgs
      ].filter(Boolean),
      name: "EstimateGasExecutionError"
    });
    Object.defineProperty(this, "cause", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: void 0
    });
    this.cause = cause;
  }
};

// ../../node_modules/viem/_esm/utils/errors/getEstimateGasError.js
function getEstimateGasError(err, { docsPath, ...args }) {
  const cause = (() => {
    const cause2 = getNodeError(err, args);
    if (cause2 instanceof UnknownNodeError)
      return err;
    return cause2;
  })();
  return new EstimateGasExecutionError(cause, {
    docsPath,
    ...args
  });
}

// ../../node_modules/viem/_esm/actions/wallet/prepareTransactionRequest.js
var import_dist118 = __toESM(require_dist(), 1);
var import_dist119 = __toESM(require_dist2(), 1);
var import_dist120 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/estimateFeesPerGas.js
var import_dist67 = __toESM(require_dist(), 1);
var import_dist68 = __toESM(require_dist2(), 1);
var import_dist69 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/errors/fee.js
var import_dist46 = __toESM(require_dist(), 1);
var import_dist47 = __toESM(require_dist2(), 1);
var import_dist48 = __toESM(require_dist3(), 1);
var BaseFeeScalarError = class extends BaseError {
  constructor() {
    super("`baseFeeMultiplier` must be greater than 1.", {
      name: "BaseFeeScalarError"
    });
  }
};
var Eip1559FeesNotSupportedError = class extends BaseError {
  constructor() {
    super("Chain does not support EIP-1559 fees.", {
      name: "Eip1559FeesNotSupportedError"
    });
  }
};
var MaxFeePerGasTooLowError = class extends BaseError {
  constructor({ maxPriorityFeePerGas }) {
    super(`\`maxFeePerGas\` cannot be less than the \`maxPriorityFeePerGas\` (${formatGwei(maxPriorityFeePerGas)} gwei).`, { name: "MaxFeePerGasTooLowError" });
  }
};

// ../../node_modules/viem/_esm/actions/public/estimateMaxPriorityFeePerGas.js
var import_dist64 = __toESM(require_dist(), 1);
var import_dist65 = __toESM(require_dist2(), 1);
var import_dist66 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getBlock.js
var import_dist58 = __toESM(require_dist(), 1);
var import_dist59 = __toESM(require_dist2(), 1);
var import_dist60 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/errors/block.js
var import_dist49 = __toESM(require_dist(), 1);
var import_dist50 = __toESM(require_dist2(), 1);
var import_dist51 = __toESM(require_dist3(), 1);
var BlockNotFoundError = class extends BaseError {
  constructor({ blockHash, blockNumber }) {
    let identifier = "Block";
    if (blockHash)
      identifier = `Block at hash "${blockHash}"`;
    if (blockNumber)
      identifier = `Block at number "${blockNumber}"`;
    super(`${identifier} could not be found.`, { name: "BlockNotFoundError" });
  }
};

// ../../node_modules/viem/_esm/utils/formatters/block.js
var import_dist55 = __toESM(require_dist(), 1);
var import_dist56 = __toESM(require_dist2(), 1);
var import_dist57 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/formatters/transaction.js
var import_dist52 = __toESM(require_dist(), 1);
var import_dist53 = __toESM(require_dist2(), 1);
var import_dist54 = __toESM(require_dist3(), 1);
var transactionType = {
  "0x0": "legacy",
  "0x1": "eip2930",
  "0x2": "eip1559",
  "0x3": "eip4844",
  "0x4": "eip7702"
};
function formatTransaction(transaction, _) {
  const transaction_ = {
    ...transaction,
    blockHash: transaction.blockHash ? transaction.blockHash : null,
    blockNumber: transaction.blockNumber ? BigInt(transaction.blockNumber) : null,
    chainId: transaction.chainId ? hexToNumber(transaction.chainId) : void 0,
    gas: transaction.gas ? BigInt(transaction.gas) : void 0,
    gasPrice: transaction.gasPrice ? BigInt(transaction.gasPrice) : void 0,
    maxFeePerBlobGas: transaction.maxFeePerBlobGas ? BigInt(transaction.maxFeePerBlobGas) : void 0,
    maxFeePerGas: transaction.maxFeePerGas ? BigInt(transaction.maxFeePerGas) : void 0,
    maxPriorityFeePerGas: transaction.maxPriorityFeePerGas ? BigInt(transaction.maxPriorityFeePerGas) : void 0,
    nonce: transaction.nonce ? hexToNumber(transaction.nonce) : void 0,
    to: transaction.to ? transaction.to : null,
    transactionIndex: transaction.transactionIndex ? Number(transaction.transactionIndex) : null,
    type: transaction.type ? transactionType[transaction.type] : void 0,
    typeHex: transaction.type ? transaction.type : void 0,
    value: transaction.value ? BigInt(transaction.value) : void 0,
    v: transaction.v ? BigInt(transaction.v) : void 0
  };
  if (transaction.authorizationList)
    transaction_.authorizationList = formatAuthorizationList(transaction.authorizationList);
  transaction_.yParity = (() => {
    if (transaction.yParity)
      return Number(transaction.yParity);
    if (typeof transaction_.v === "bigint") {
      if (transaction_.v === 0n || transaction_.v === 27n)
        return 0;
      if (transaction_.v === 1n || transaction_.v === 28n)
        return 1;
      if (transaction_.v >= 35n)
        return transaction_.v % 2n === 0n ? 1 : 0;
    }
    return void 0;
  })();
  if (transaction_.type === "legacy") {
    delete transaction_.accessList;
    delete transaction_.maxFeePerBlobGas;
    delete transaction_.maxFeePerGas;
    delete transaction_.maxPriorityFeePerGas;
    delete transaction_.yParity;
  }
  if (transaction_.type === "eip2930") {
    delete transaction_.maxFeePerBlobGas;
    delete transaction_.maxFeePerGas;
    delete transaction_.maxPriorityFeePerGas;
  }
  if (transaction_.type === "eip1559")
    delete transaction_.maxFeePerBlobGas;
  return transaction_;
}
var defineTransaction = defineFormatter("transaction", formatTransaction);
function formatAuthorizationList(authorizationList) {
  return authorizationList.map((authorization) => ({
    address: authorization.address,
    chainId: Number(authorization.chainId),
    nonce: Number(authorization.nonce),
    r: authorization.r,
    s: authorization.s,
    yParity: Number(authorization.yParity)
  }));
}

// ../../node_modules/viem/_esm/utils/formatters/block.js
function formatBlock(block, _) {
  const transactions = (block.transactions ?? []).map((transaction) => {
    if (typeof transaction === "string")
      return transaction;
    return formatTransaction(transaction);
  });
  return {
    ...block,
    baseFeePerGas: block.baseFeePerGas ? BigInt(block.baseFeePerGas) : null,
    blobGasUsed: block.blobGasUsed ? BigInt(block.blobGasUsed) : void 0,
    difficulty: block.difficulty ? BigInt(block.difficulty) : void 0,
    excessBlobGas: block.excessBlobGas ? BigInt(block.excessBlobGas) : void 0,
    gasLimit: block.gasLimit ? BigInt(block.gasLimit) : void 0,
    gasUsed: block.gasUsed ? BigInt(block.gasUsed) : void 0,
    hash: block.hash ? block.hash : null,
    logsBloom: block.logsBloom ? block.logsBloom : null,
    nonce: block.nonce ? block.nonce : null,
    number: block.number ? BigInt(block.number) : null,
    size: block.size ? BigInt(block.size) : void 0,
    timestamp: block.timestamp ? BigInt(block.timestamp) : void 0,
    transactions,
    totalDifficulty: block.totalDifficulty ? BigInt(block.totalDifficulty) : null
  };
}
var defineBlock = defineFormatter("block", formatBlock);

// ../../node_modules/viem/_esm/actions/public/getBlock.js
async function getBlock(client, { blockHash, blockNumber, blockTag = client.experimental_blockTag ?? "latest", includeTransactions: includeTransactions_ } = {}) {
  var _a, _b, _c;
  const includeTransactions = includeTransactions_ ?? false;
  const blockNumberHex = blockNumber !== void 0 ? numberToHex(blockNumber) : void 0;
  let block = null;
  if (blockHash) {
    block = await client.request({
      method: "eth_getBlockByHash",
      params: [blockHash, includeTransactions]
    }, { dedupe: true });
  } else {
    block = await client.request({
      method: "eth_getBlockByNumber",
      params: [blockNumberHex || blockTag, includeTransactions]
    }, { dedupe: Boolean(blockNumberHex) });
  }
  if (!block)
    throw new BlockNotFoundError({ blockHash, blockNumber });
  const format = ((_c = (_b = (_a = client.chain) == null ? void 0 : _a.formatters) == null ? void 0 : _b.block) == null ? void 0 : _c.format) || formatBlock;
  return format(block, "getBlock");
}

// ../../node_modules/viem/_esm/actions/public/getGasPrice.js
var import_dist61 = __toESM(require_dist(), 1);
var import_dist62 = __toESM(require_dist2(), 1);
var import_dist63 = __toESM(require_dist3(), 1);
async function getGasPrice(client) {
  const gasPrice = await client.request({
    method: "eth_gasPrice"
  });
  return BigInt(gasPrice);
}

// ../../node_modules/viem/_esm/actions/public/estimateMaxPriorityFeePerGas.js
async function internal_estimateMaxPriorityFeePerGas(client, args) {
  var _a, _b;
  const { block: block_, chain = client.chain, request: request2 } = args || {};
  try {
    const maxPriorityFeePerGas = ((_a = chain == null ? void 0 : chain.fees) == null ? void 0 : _a.maxPriorityFeePerGas) ?? ((_b = chain == null ? void 0 : chain.fees) == null ? void 0 : _b.defaultPriorityFee);
    if (typeof maxPriorityFeePerGas === "function") {
      const block = block_ || await getAction(client, getBlock, "getBlock")({});
      const maxPriorityFeePerGas_ = await maxPriorityFeePerGas({
        block,
        client,
        request: request2
      });
      if (maxPriorityFeePerGas_ === null)
        throw new Error();
      return maxPriorityFeePerGas_;
    }
    if (typeof maxPriorityFeePerGas !== "undefined")
      return maxPriorityFeePerGas;
    const maxPriorityFeePerGasHex = await client.request({
      method: "eth_maxPriorityFeePerGas"
    });
    return hexToBigInt(maxPriorityFeePerGasHex);
  } catch {
    const [block, gasPrice] = await Promise.all([
      block_ ? Promise.resolve(block_) : getAction(client, getBlock, "getBlock")({}),
      getAction(client, getGasPrice, "getGasPrice")({})
    ]);
    if (typeof block.baseFeePerGas !== "bigint")
      throw new Eip1559FeesNotSupportedError();
    const maxPriorityFeePerGas = gasPrice - block.baseFeePerGas;
    if (maxPriorityFeePerGas < 0n)
      return 0n;
    return maxPriorityFeePerGas;
  }
}

// ../../node_modules/viem/_esm/actions/public/estimateFeesPerGas.js
async function internal_estimateFeesPerGas(client, args) {
  var _a, _b;
  const { block: block_, chain = client.chain, request: request2, type = "eip1559" } = args || {};
  const baseFeeMultiplier = await (async () => {
    var _a2, _b2;
    if (typeof ((_a2 = chain == null ? void 0 : chain.fees) == null ? void 0 : _a2.baseFeeMultiplier) === "function")
      return chain.fees.baseFeeMultiplier({
        block: block_,
        client,
        request: request2
      });
    return ((_b2 = chain == null ? void 0 : chain.fees) == null ? void 0 : _b2.baseFeeMultiplier) ?? 1.2;
  })();
  if (baseFeeMultiplier < 1)
    throw new BaseFeeScalarError();
  const decimals = ((_a = baseFeeMultiplier.toString().split(".")[1]) == null ? void 0 : _a.length) ?? 0;
  const denominator = 10 ** decimals;
  const multiply = (base) => base * BigInt(Math.ceil(baseFeeMultiplier * denominator)) / BigInt(denominator);
  const block = block_ ? block_ : await getAction(client, getBlock, "getBlock")({});
  if (typeof ((_b = chain == null ? void 0 : chain.fees) == null ? void 0 : _b.estimateFeesPerGas) === "function") {
    const fees = await chain.fees.estimateFeesPerGas({
      block: block_,
      client,
      multiply,
      request: request2,
      type
    });
    if (fees !== null)
      return fees;
  }
  if (type === "eip1559") {
    if (typeof block.baseFeePerGas !== "bigint")
      throw new Eip1559FeesNotSupportedError();
    const maxPriorityFeePerGas = typeof (request2 == null ? void 0 : request2.maxPriorityFeePerGas) === "bigint" ? request2.maxPriorityFeePerGas : await internal_estimateMaxPriorityFeePerGas(client, {
      block,
      chain,
      request: request2
    });
    const baseFeePerGas = multiply(block.baseFeePerGas);
    const maxFeePerGas = (request2 == null ? void 0 : request2.maxFeePerGas) ?? baseFeePerGas + maxPriorityFeePerGas;
    return {
      maxFeePerGas,
      maxPriorityFeePerGas
    };
  }
  const gasPrice = (request2 == null ? void 0 : request2.gasPrice) ?? multiply(await getAction(client, getGasPrice, "getGasPrice")({}));
  return {
    gasPrice
  };
}

// ../../node_modules/viem/_esm/actions/public/getTransactionCount.js
var import_dist70 = __toESM(require_dist(), 1);
var import_dist71 = __toESM(require_dist2(), 1);
var import_dist72 = __toESM(require_dist3(), 1);
async function getTransactionCount(client, { address, blockTag = "latest", blockNumber }) {
  const count = await client.request({
    method: "eth_getTransactionCount",
    params: [
      address,
      typeof blockNumber === "bigint" ? numberToHex(blockNumber) : blockTag
    ]
  }, {
    dedupe: Boolean(blockNumber)
  });
  return hexToNumber(count);
}

// ../../node_modules/viem/_esm/utils/blob/blobsToCommitments.js
var import_dist73 = __toESM(require_dist(), 1);
var import_dist74 = __toESM(require_dist2(), 1);
var import_dist75 = __toESM(require_dist3(), 1);
function blobsToCommitments(parameters) {
  const { kzg } = parameters;
  const to = parameters.to ?? (typeof parameters.blobs[0] === "string" ? "hex" : "bytes");
  const blobs = typeof parameters.blobs[0] === "string" ? parameters.blobs.map((x) => hexToBytes(x)) : parameters.blobs;
  const commitments = [];
  for (const blob of blobs)
    commitments.push(Uint8Array.from(kzg.blobToKzgCommitment(blob)));
  return to === "bytes" ? commitments : commitments.map((x) => bytesToHex(x));
}

// ../../node_modules/viem/_esm/utils/blob/blobsToProofs.js
var import_dist76 = __toESM(require_dist(), 1);
var import_dist77 = __toESM(require_dist2(), 1);
var import_dist78 = __toESM(require_dist3(), 1);
function blobsToProofs(parameters) {
  const { kzg } = parameters;
  const to = parameters.to ?? (typeof parameters.blobs[0] === "string" ? "hex" : "bytes");
  const blobs = typeof parameters.blobs[0] === "string" ? parameters.blobs.map((x) => hexToBytes(x)) : parameters.blobs;
  const commitments = typeof parameters.commitments[0] === "string" ? parameters.commitments.map((x) => hexToBytes(x)) : parameters.commitments;
  const proofs = [];
  for (let i = 0; i < blobs.length; i++) {
    const blob = blobs[i];
    const commitment = commitments[i];
    proofs.push(Uint8Array.from(kzg.computeBlobKzgProof(blob, commitment)));
  }
  return to === "bytes" ? proofs : proofs.map((x) => bytesToHex(x));
}

// ../../node_modules/viem/_esm/utils/blob/commitmentsToVersionedHashes.js
var import_dist88 = __toESM(require_dist(), 1);
var import_dist89 = __toESM(require_dist2(), 1);
var import_dist90 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/blob/commitmentToVersionedHash.js
var import_dist85 = __toESM(require_dist(), 1);
var import_dist86 = __toESM(require_dist2(), 1);
var import_dist87 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/hash/sha256.js
var import_dist82 = __toESM(require_dist(), 1);
var import_dist83 = __toESM(require_dist2(), 1);
var import_dist84 = __toESM(require_dist3(), 1);

// ../../node_modules/@noble/hashes/esm/sha256.js
var import_dist79 = __toESM(require_dist());
var import_dist80 = __toESM(require_dist2());
var import_dist81 = __toESM(require_dist3());
var sha2562 = sha256;

// ../../node_modules/viem/_esm/utils/hash/sha256.js
function sha2563(value, to_) {
  const to = to_ || "hex";
  const bytes = sha2562(isHex(value, { strict: false }) ? toBytes(value) : value);
  if (to === "bytes")
    return bytes;
  return toHex(bytes);
}

// ../../node_modules/viem/_esm/utils/blob/commitmentToVersionedHash.js
function commitmentToVersionedHash(parameters) {
  const { commitment, version = 1 } = parameters;
  const to = parameters.to ?? (typeof commitment === "string" ? "hex" : "bytes");
  const versionedHash = sha2563(commitment, "bytes");
  versionedHash.set([version], 0);
  return to === "bytes" ? versionedHash : bytesToHex(versionedHash);
}

// ../../node_modules/viem/_esm/utils/blob/commitmentsToVersionedHashes.js
function commitmentsToVersionedHashes(parameters) {
  const { commitments, version } = parameters;
  const to = parameters.to ?? (typeof commitments[0] === "string" ? "hex" : "bytes");
  const hashes = [];
  for (const commitment of commitments) {
    hashes.push(commitmentToVersionedHash({
      commitment,
      to,
      version
    }));
  }
  return hashes;
}

// ../../node_modules/viem/_esm/utils/blob/toBlobSidecars.js
var import_dist103 = __toESM(require_dist(), 1);
var import_dist104 = __toESM(require_dist2(), 1);
var import_dist105 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/blob/toBlobs.js
var import_dist100 = __toESM(require_dist(), 1);
var import_dist101 = __toESM(require_dist2(), 1);
var import_dist102 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/constants/blob.js
var import_dist91 = __toESM(require_dist(), 1);
var import_dist92 = __toESM(require_dist2(), 1);
var import_dist93 = __toESM(require_dist3(), 1);
var blobsPerTransaction = 6;
var bytesPerFieldElement = 32;
var fieldElementsPerBlob = 4096;
var bytesPerBlob = bytesPerFieldElement * fieldElementsPerBlob;
var maxBytesPerTransaction = bytesPerBlob * blobsPerTransaction - // terminator byte (0x80).
1 - // zero byte (0x00) appended to each field element.
1 * fieldElementsPerBlob * blobsPerTransaction;

// ../../node_modules/viem/_esm/errors/blob.js
var import_dist97 = __toESM(require_dist(), 1);
var import_dist98 = __toESM(require_dist2(), 1);
var import_dist99 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/constants/kzg.js
var import_dist94 = __toESM(require_dist(), 1);
var import_dist95 = __toESM(require_dist2(), 1);
var import_dist96 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/errors/blob.js
var BlobSizeTooLargeError = class extends BaseError {
  constructor({ maxSize, size: size4 }) {
    super("Blob size is too large.", {
      metaMessages: [`Max: ${maxSize} bytes`, `Given: ${size4} bytes`],
      name: "BlobSizeTooLargeError"
    });
  }
};
var EmptyBlobError = class extends BaseError {
  constructor() {
    super("Blob data must not be empty.", { name: "EmptyBlobError" });
  }
};

// ../../node_modules/viem/_esm/utils/blob/toBlobs.js
function toBlobs(parameters) {
  const to = parameters.to ?? (typeof parameters.data === "string" ? "hex" : "bytes");
  const data = typeof parameters.data === "string" ? hexToBytes(parameters.data) : parameters.data;
  const size_ = size(data);
  if (!size_)
    throw new EmptyBlobError();
  if (size_ > maxBytesPerTransaction)
    throw new BlobSizeTooLargeError({
      maxSize: maxBytesPerTransaction,
      size: size_
    });
  const blobs = [];
  let active = true;
  let position = 0;
  while (active) {
    const blob = createCursor(new Uint8Array(bytesPerBlob));
    let size4 = 0;
    while (size4 < fieldElementsPerBlob) {
      const bytes = data.slice(position, position + (bytesPerFieldElement - 1));
      blob.pushByte(0);
      blob.pushBytes(bytes);
      if (bytes.length < 31) {
        blob.pushByte(128);
        active = false;
        break;
      }
      size4++;
      position += 31;
    }
    blobs.push(blob);
  }
  return to === "bytes" ? blobs.map((x) => x.bytes) : blobs.map((x) => bytesToHex(x.bytes));
}

// ../../node_modules/viem/_esm/utils/blob/toBlobSidecars.js
function toBlobSidecars(parameters) {
  const { data, kzg, to } = parameters;
  const blobs = parameters.blobs ?? toBlobs({ data, to });
  const commitments = parameters.commitments ?? blobsToCommitments({ blobs, kzg, to });
  const proofs = parameters.proofs ?? blobsToProofs({ blobs, commitments, kzg, to });
  const sidecars = [];
  for (let i = 0; i < blobs.length; i++)
    sidecars.push({
      blob: blobs[i],
      commitment: commitments[i],
      proof: proofs[i]
    });
  return sidecars;
}

// ../../node_modules/viem/_esm/utils/transaction/getTransactionType.js
var import_dist106 = __toESM(require_dist(), 1);
var import_dist107 = __toESM(require_dist2(), 1);
var import_dist108 = __toESM(require_dist3(), 1);
function getTransactionType(transaction) {
  if (transaction.type)
    return transaction.type;
  if (typeof transaction.authorizationList !== "undefined")
    return "eip7702";
  if (typeof transaction.blobs !== "undefined" || typeof transaction.blobVersionedHashes !== "undefined" || typeof transaction.maxFeePerBlobGas !== "undefined" || typeof transaction.sidecars !== "undefined")
    return "eip4844";
  if (typeof transaction.maxFeePerGas !== "undefined" || typeof transaction.maxPriorityFeePerGas !== "undefined") {
    return "eip1559";
  }
  if (typeof transaction.gasPrice !== "undefined") {
    if (typeof transaction.accessList !== "undefined")
      return "eip2930";
    return "legacy";
  }
  throw new InvalidSerializableTransactionError({ transaction });
}

// ../../node_modules/viem/_esm/actions/public/fillTransaction.js
var import_dist115 = __toESM(require_dist(), 1);
var import_dist116 = __toESM(require_dist2(), 1);
var import_dist117 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/errors/getTransactionError.js
var import_dist109 = __toESM(require_dist(), 1);
var import_dist110 = __toESM(require_dist2(), 1);
var import_dist111 = __toESM(require_dist3(), 1);
function getTransactionError(err, { docsPath, ...args }) {
  const cause = (() => {
    const cause2 = getNodeError(err, args);
    if (cause2 instanceof UnknownNodeError)
      return err;
    return cause2;
  })();
  return new TransactionExecutionError(cause, {
    docsPath,
    ...args
  });
}

// ../../node_modules/viem/_esm/actions/public/getChainId.js
var import_dist112 = __toESM(require_dist(), 1);
var import_dist113 = __toESM(require_dist2(), 1);
var import_dist114 = __toESM(require_dist3(), 1);
async function getChainId(client) {
  const chainIdHex = await client.request({
    method: "eth_chainId"
  }, { dedupe: true });
  return hexToNumber(chainIdHex);
}

// ../../node_modules/viem/_esm/actions/public/fillTransaction.js
async function fillTransaction(client, parameters) {
  var _a, _b, _c, _d, _e;
  const { account = client.account, accessList, authorizationList, chain = client.chain, blobVersionedHashes, blobs, data, gas, gasPrice, maxFeePerBlobGas, maxFeePerGas, maxPriorityFeePerGas, nonce: nonce_, nonceManager: nonceManager2, to, type, value, ...rest } = parameters;
  const nonce = await (async () => {
    if (!account)
      return nonce_;
    if (!nonceManager2)
      return nonce_;
    if (typeof nonce_ !== "undefined")
      return nonce_;
    const account_ = parseAccount(account);
    const chainId = chain ? chain.id : await getAction(client, getChainId, "getChainId")({});
    return await nonceManager2.consume({
      address: account_.address,
      chainId,
      client
    });
  })();
  assertRequest(parameters);
  const chainFormat = (_b = (_a = chain == null ? void 0 : chain.formatters) == null ? void 0 : _a.transactionRequest) == null ? void 0 : _b.format;
  const format = chainFormat || formatTransactionRequest;
  const request2 = format({
    // Pick out extra data that might exist on the chain's transaction request type.
    ...extract(rest, { format: chainFormat }),
    account: account ? parseAccount(account) : void 0,
    accessList,
    authorizationList,
    blobs,
    blobVersionedHashes,
    data,
    gas,
    gasPrice,
    maxFeePerBlobGas,
    maxFeePerGas,
    maxPriorityFeePerGas,
    nonce,
    to,
    type,
    value
  }, "fillTransaction");
  try {
    const response = await client.request({
      method: "eth_fillTransaction",
      params: [request2]
    });
    const format2 = ((_d = (_c = chain == null ? void 0 : chain.formatters) == null ? void 0 : _c.transaction) == null ? void 0 : _d.format) || formatTransaction;
    const transaction = format2(response.tx);
    delete transaction.blockHash;
    delete transaction.blockNumber;
    delete transaction.r;
    delete transaction.s;
    delete transaction.transactionIndex;
    delete transaction.v;
    delete transaction.yParity;
    transaction.data = transaction.input;
    if (transaction.gas)
      transaction.gas = parameters.gas ?? transaction.gas;
    if (transaction.gasPrice)
      transaction.gasPrice = parameters.gasPrice ?? transaction.gasPrice;
    if (transaction.maxFeePerBlobGas)
      transaction.maxFeePerBlobGas = parameters.maxFeePerBlobGas ?? transaction.maxFeePerBlobGas;
    if (transaction.maxFeePerGas)
      transaction.maxFeePerGas = parameters.maxFeePerGas ?? transaction.maxFeePerGas;
    if (transaction.maxPriorityFeePerGas)
      transaction.maxPriorityFeePerGas = parameters.maxPriorityFeePerGas ?? transaction.maxPriorityFeePerGas;
    if (transaction.nonce)
      transaction.nonce = parameters.nonce ?? transaction.nonce;
    const feeMultiplier = await (async () => {
      var _a2, _b2;
      if (typeof ((_a2 = chain == null ? void 0 : chain.fees) == null ? void 0 : _a2.baseFeeMultiplier) === "function") {
        const block = await getAction(client, getBlock, "getBlock")({});
        return chain.fees.baseFeeMultiplier({
          block,
          client,
          request: parameters
        });
      }
      return ((_b2 = chain == null ? void 0 : chain.fees) == null ? void 0 : _b2.baseFeeMultiplier) ?? 1.2;
    })();
    if (feeMultiplier < 1)
      throw new BaseFeeScalarError();
    const decimals = ((_e = feeMultiplier.toString().split(".")[1]) == null ? void 0 : _e.length) ?? 0;
    const denominator = 10 ** decimals;
    const multiplyFee = (base) => base * BigInt(Math.ceil(feeMultiplier * denominator)) / BigInt(denominator);
    if (transaction.maxFeePerGas && !parameters.maxFeePerGas)
      transaction.maxFeePerGas = multiplyFee(transaction.maxFeePerGas);
    if (transaction.gasPrice && !parameters.gasPrice)
      transaction.gasPrice = multiplyFee(transaction.gasPrice);
    return {
      raw: response.raw,
      transaction: {
        from: request2.from,
        ...transaction
      }
    };
  } catch (err) {
    throw getTransactionError(err, {
      ...parameters,
      chain: client.chain
    });
  }
}

// ../../node_modules/viem/_esm/actions/wallet/prepareTransactionRequest.js
var defaultParameters = [
  "blobVersionedHashes",
  "chainId",
  "fees",
  "gas",
  "nonce",
  "type"
];
var eip1559NetworkCache = /* @__PURE__ */ new Map();
var supportsFillTransaction = new LruMap(128);
async function prepareTransactionRequest(client, args) {
  var _a, _b, _c;
  let request2 = args;
  request2.account ?? (request2.account = client.account);
  request2.parameters ?? (request2.parameters = defaultParameters);
  const { account: account_, chain = client.chain, nonceManager: nonceManager2, parameters } = request2;
  const prepareTransactionRequest2 = (() => {
    if (typeof (chain == null ? void 0 : chain.prepareTransactionRequest) === "function")
      return {
        fn: chain.prepareTransactionRequest,
        runAt: ["beforeFillTransaction"]
      };
    if (Array.isArray(chain == null ? void 0 : chain.prepareTransactionRequest))
      return {
        fn: chain.prepareTransactionRequest[0],
        runAt: chain.prepareTransactionRequest[1].runAt
      };
    return void 0;
  })();
  let chainId;
  async function getChainId2() {
    if (chainId)
      return chainId;
    if (typeof request2.chainId !== "undefined")
      return request2.chainId;
    if (chain)
      return chain.id;
    const chainId_ = await getAction(client, getChainId, "getChainId")({});
    chainId = chainId_;
    return chainId;
  }
  const account = account_ ? parseAccount(account_) : account_;
  let nonce = request2.nonce;
  if (parameters.includes("nonce") && typeof nonce === "undefined" && account && nonceManager2) {
    const chainId2 = await getChainId2();
    nonce = await nonceManager2.consume({
      address: account.address,
      chainId: chainId2,
      client
    });
  }
  if ((prepareTransactionRequest2 == null ? void 0 : prepareTransactionRequest2.fn) && ((_a = prepareTransactionRequest2.runAt) == null ? void 0 : _a.includes("beforeFillTransaction"))) {
    request2 = await prepareTransactionRequest2.fn({ ...request2, chain }, {
      phase: "beforeFillTransaction"
    });
    nonce ?? (nonce = request2.nonce);
  }
  const attemptFill = (() => {
    if ((parameters.includes("blobVersionedHashes") || parameters.includes("sidecars")) && request2.kzg && request2.blobs)
      return false;
    if (supportsFillTransaction.get(client.uid) === false)
      return false;
    const shouldAttempt = ["fees", "gas"].some((parameter) => parameters.includes(parameter));
    if (!shouldAttempt)
      return false;
    if (parameters.includes("chainId") && typeof request2.chainId !== "number")
      return true;
    if (parameters.includes("nonce") && typeof nonce !== "number")
      return true;
    if (parameters.includes("fees") && typeof request2.gasPrice !== "bigint" && (typeof request2.maxFeePerGas !== "bigint" || typeof request2.maxPriorityFeePerGas !== "bigint"))
      return true;
    if (parameters.includes("gas") && typeof request2.gas !== "bigint")
      return true;
    return false;
  })();
  const fillResult = attemptFill ? await getAction(client, fillTransaction, "fillTransaction")({ ...request2, nonce }).then((result) => {
    const { chainId: chainId2, from: from14, gas: gas2, gasPrice, nonce: nonce2, maxFeePerBlobGas, maxFeePerGas, maxPriorityFeePerGas, type: type2, ...rest } = result.transaction;
    supportsFillTransaction.set(client.uid, true);
    return {
      ...request2,
      ...from14 ? { from: from14 } : {},
      ...type2 ? { type: type2 } : {},
      ...typeof chainId2 !== "undefined" ? { chainId: chainId2 } : {},
      ...typeof gas2 !== "undefined" ? { gas: gas2 } : {},
      ...typeof gasPrice !== "undefined" ? { gasPrice } : {},
      ...typeof nonce2 !== "undefined" ? { nonce: nonce2 } : {},
      ...typeof maxFeePerBlobGas !== "undefined" ? { maxFeePerBlobGas } : {},
      ...typeof maxFeePerGas !== "undefined" ? { maxFeePerGas } : {},
      ...typeof maxPriorityFeePerGas !== "undefined" ? { maxPriorityFeePerGas } : {},
      ..."nonceKey" in rest && typeof rest.nonceKey !== "undefined" ? { nonceKey: rest.nonceKey } : {}
    };
  }).catch((e) => {
    var _a2;
    const error = e;
    if (error.name !== "TransactionExecutionError")
      return request2;
    const unsupported = (_a2 = error.walk) == null ? void 0 : _a2.call(error, (e2) => {
      const error2 = e2;
      return error2.name === "MethodNotFoundRpcError" || error2.name === "MethodNotSupportedRpcError";
    });
    if (unsupported)
      supportsFillTransaction.set(client.uid, false);
    return request2;
  }) : request2;
  nonce ?? (nonce = fillResult.nonce);
  request2 = {
    ...fillResult,
    ...account ? { from: account == null ? void 0 : account.address } : {},
    ...nonce ? { nonce } : {}
  };
  const { blobs, gas, kzg, type } = request2;
  if ((prepareTransactionRequest2 == null ? void 0 : prepareTransactionRequest2.fn) && ((_b = prepareTransactionRequest2.runAt) == null ? void 0 : _b.includes("beforeFillParameters"))) {
    request2 = await prepareTransactionRequest2.fn({ ...request2, chain }, {
      phase: "beforeFillParameters"
    });
  }
  let block;
  async function getBlock2() {
    if (block)
      return block;
    block = await getAction(client, getBlock, "getBlock")({ blockTag: "latest" });
    return block;
  }
  if (parameters.includes("nonce") && typeof nonce === "undefined" && account && !nonceManager2)
    request2.nonce = await getAction(client, getTransactionCount, "getTransactionCount")({
      address: account.address,
      blockTag: "pending"
    });
  if ((parameters.includes("blobVersionedHashes") || parameters.includes("sidecars")) && blobs && kzg) {
    const commitments = blobsToCommitments({ blobs, kzg });
    if (parameters.includes("blobVersionedHashes")) {
      const versionedHashes = commitmentsToVersionedHashes({
        commitments,
        to: "hex"
      });
      request2.blobVersionedHashes = versionedHashes;
    }
    if (parameters.includes("sidecars")) {
      const proofs = blobsToProofs({ blobs, commitments, kzg });
      const sidecars = toBlobSidecars({
        blobs,
        commitments,
        proofs,
        to: "hex"
      });
      request2.sidecars = sidecars;
    }
  }
  if (parameters.includes("chainId"))
    request2.chainId = await getChainId2();
  if ((parameters.includes("fees") || parameters.includes("type")) && typeof type === "undefined") {
    try {
      request2.type = getTransactionType(request2);
    } catch {
      let isEip1559Network = eip1559NetworkCache.get(client.uid);
      if (typeof isEip1559Network === "undefined") {
        const block2 = await getBlock2();
        isEip1559Network = typeof (block2 == null ? void 0 : block2.baseFeePerGas) === "bigint";
        eip1559NetworkCache.set(client.uid, isEip1559Network);
      }
      request2.type = isEip1559Network ? "eip1559" : "legacy";
    }
  }
  if (parameters.includes("fees")) {
    if (request2.type !== "legacy" && request2.type !== "eip2930") {
      if (typeof request2.maxFeePerGas === "undefined" || typeof request2.maxPriorityFeePerGas === "undefined") {
        const block2 = await getBlock2();
        const { maxFeePerGas, maxPriorityFeePerGas } = await internal_estimateFeesPerGas(client, {
          block: block2,
          chain,
          request: request2
        });
        if (typeof request2.maxPriorityFeePerGas === "undefined" && request2.maxFeePerGas && request2.maxFeePerGas < maxPriorityFeePerGas)
          throw new MaxFeePerGasTooLowError({
            maxPriorityFeePerGas
          });
        request2.maxPriorityFeePerGas = maxPriorityFeePerGas;
        request2.maxFeePerGas = maxFeePerGas;
      }
    } else {
      if (typeof request2.maxFeePerGas !== "undefined" || typeof request2.maxPriorityFeePerGas !== "undefined")
        throw new Eip1559FeesNotSupportedError();
      if (typeof request2.gasPrice === "undefined") {
        const block2 = await getBlock2();
        const { gasPrice: gasPrice_ } = await internal_estimateFeesPerGas(client, {
          block: block2,
          chain,
          request: request2,
          type: "legacy"
        });
        request2.gasPrice = gasPrice_;
      }
    }
  }
  if (parameters.includes("gas") && typeof gas === "undefined")
    request2.gas = await getAction(client, estimateGas, "estimateGas")({
      ...request2,
      account,
      prepare: (account == null ? void 0 : account.type) === "local" ? [] : ["blobVersionedHashes"]
    });
  if ((prepareTransactionRequest2 == null ? void 0 : prepareTransactionRequest2.fn) && ((_c = prepareTransactionRequest2.runAt) == null ? void 0 : _c.includes("afterFillParameters")))
    request2 = await prepareTransactionRequest2.fn({ ...request2, chain }, {
      phase: "afterFillParameters"
    });
  assertRequest(request2);
  delete request2.parameters;
  return request2;
}

// ../../node_modules/viem/_esm/actions/public/estimateGas.js
async function estimateGas(client, args) {
  var _a, _b, _c;
  const { account: account_ = client.account, prepare = true } = args;
  const account = account_ ? parseAccount(account_) : void 0;
  const parameters = (() => {
    if (Array.isArray(prepare))
      return prepare;
    if ((account == null ? void 0 : account.type) !== "local")
      return ["blobVersionedHashes"];
    return void 0;
  })();
  try {
    const to = await (async () => {
      if (args.to)
        return args.to;
      if (args.authorizationList && args.authorizationList.length > 0)
        return await recoverAuthorizationAddress({
          authorization: args.authorizationList[0]
        }).catch(() => {
          throw new BaseError("`to` is required. Could not infer from `authorizationList`");
        });
      return void 0;
    })();
    const { accessList, authorizationList, blobs, blobVersionedHashes, blockNumber, blockTag, data, gas, gasPrice, maxFeePerBlobGas, maxFeePerGas, maxPriorityFeePerGas, nonce, value, stateOverride, ...rest } = prepare ? await prepareTransactionRequest(client, {
      ...args,
      parameters,
      to
    }) : args;
    if (gas && args.gas !== gas)
      return gas;
    const blockNumberHex = typeof blockNumber === "bigint" ? numberToHex(blockNumber) : void 0;
    const block = blockNumberHex || blockTag;
    const rpcStateOverride = serializeStateOverride(stateOverride);
    assertRequest(args);
    const chainFormat = (_c = (_b = (_a = client.chain) == null ? void 0 : _a.formatters) == null ? void 0 : _b.transactionRequest) == null ? void 0 : _c.format;
    const format = chainFormat || formatTransactionRequest;
    const request2 = format({
      // Pick out extra data that might exist on the chain's transaction request type.
      ...extract(rest, { format: chainFormat }),
      account,
      accessList,
      authorizationList,
      blobs,
      blobVersionedHashes,
      data,
      gasPrice,
      maxFeePerBlobGas,
      maxFeePerGas,
      maxPriorityFeePerGas,
      nonce,
      to,
      value
    }, "estimateGas");
    return BigInt(await client.request({
      method: "eth_estimateGas",
      params: rpcStateOverride ? [
        request2,
        block ?? client.experimental_blockTag ?? "latest",
        rpcStateOverride
      ] : block ? [request2, block] : [request2]
    }));
  } catch (err) {
    throw getEstimateGasError(err, {
      ...args,
      account,
      chain: client.chain
    });
  }
}

// ../../node_modules/viem/_esm/actions/public/getContractEvents.js
var import_dist139 = __toESM(require_dist(), 1);
var import_dist140 = __toESM(require_dist2(), 1);
var import_dist141 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getLogs.js
var import_dist136 = __toESM(require_dist(), 1);
var import_dist137 = __toESM(require_dist2(), 1);
var import_dist138 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/abi/parseEventLogs.js
var import_dist130 = __toESM(require_dist(), 1);
var import_dist131 = __toESM(require_dist2(), 1);
var import_dist132 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/abi/decodeEventLog.js
var import_dist127 = __toESM(require_dist(), 1);
var import_dist128 = __toESM(require_dist2(), 1);
var import_dist129 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/formatters/log.js
var import_dist133 = __toESM(require_dist(), 1);
var import_dist134 = __toESM(require_dist2(), 1);
var import_dist135 = __toESM(require_dist3(), 1);
function formatLog(log, { args, eventName } = {}) {
  return {
    ...log,
    blockHash: log.blockHash ? log.blockHash : null,
    blockNumber: log.blockNumber ? BigInt(log.blockNumber) : null,
    blockTimestamp: log.blockTimestamp ? BigInt(log.blockTimestamp) : log.blockTimestamp === null ? null : void 0,
    logIndex: log.logIndex ? Number(log.logIndex) : null,
    transactionHash: log.transactionHash ? log.transactionHash : null,
    transactionIndex: log.transactionIndex ? Number(log.transactionIndex) : null,
    ...eventName ? { args, eventName } : {}
  };
}

// ../../node_modules/viem/_esm/actions/public/readContract.js
var import_dist142 = __toESM(require_dist(), 1);
var import_dist143 = __toESM(require_dist2(), 1);
var import_dist144 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/simulateContract.js
var import_dist145 = __toESM(require_dist(), 1);
var import_dist146 = __toESM(require_dist2(), 1);
var import_dist147 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/watchContractEvent.js
var import_dist169 = __toESM(require_dist(), 1);
var import_dist170 = __toESM(require_dist2(), 1);
var import_dist171 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/observe.js
var import_dist148 = __toESM(require_dist(), 1);
var import_dist149 = __toESM(require_dist2(), 1);
var import_dist150 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/poll.js
var import_dist154 = __toESM(require_dist(), 1);
var import_dist155 = __toESM(require_dist2(), 1);
var import_dist156 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/wait.js
var import_dist151 = __toESM(require_dist(), 1);
var import_dist152 = __toESM(require_dist2(), 1);
var import_dist153 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getBlockNumber.js
var import_dist160 = __toESM(require_dist(), 1);
var import_dist161 = __toESM(require_dist2(), 1);
var import_dist162 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/promise/withCache.js
var import_dist157 = __toESM(require_dist(), 1);
var import_dist158 = __toESM(require_dist2(), 1);
var import_dist159 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getFilterChanges.js
var import_dist163 = __toESM(require_dist(), 1);
var import_dist164 = __toESM(require_dist2(), 1);
var import_dist165 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/uninstallFilter.js
var import_dist166 = __toESM(require_dist(), 1);
var import_dist167 = __toESM(require_dist2(), 1);
var import_dist168 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/writeContract.js
var import_dist184 = __toESM(require_dist(), 1);
var import_dist185 = __toESM(require_dist2(), 1);
var import_dist186 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/errors/account.js
var import_dist172 = __toESM(require_dist(), 1);
var import_dist173 = __toESM(require_dist2(), 1);
var import_dist174 = __toESM(require_dist3(), 1);
var AccountNotFoundError = class extends BaseError {
  constructor({ docsPath } = {}) {
    super([
      "Could not find an Account to execute with this Action.",
      "Please provide an Account with the `account` argument on the Action, or by supplying an `account` to the Client."
    ].join("\n"), {
      docsPath,
      docsSlug: "account",
      name: "AccountNotFoundError"
    });
  }
};
var AccountTypeNotSupportedError = class extends BaseError {
  constructor({ docsPath, metaMessages, type }) {
    super(`Account type "${type}" is not supported.`, {
      docsPath,
      metaMessages,
      name: "AccountTypeNotSupportedError"
    });
  }
};

// ../../node_modules/viem/_esm/actions/wallet/sendTransaction.js
var import_dist181 = __toESM(require_dist(), 1);
var import_dist182 = __toESM(require_dist2(), 1);
var import_dist183 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/chain/assertCurrentChain.js
var import_dist175 = __toESM(require_dist(), 1);
var import_dist176 = __toESM(require_dist2(), 1);
var import_dist177 = __toESM(require_dist3(), 1);
function assertCurrentChain({ chain, currentChainId }) {
  if (!chain)
    throw new ChainNotFoundError();
  if (currentChainId !== chain.id)
    throw new ChainMismatchError({ chain, currentChainId });
}

// ../../node_modules/viem/_esm/actions/wallet/sendRawTransaction.js
var import_dist178 = __toESM(require_dist(), 1);
var import_dist179 = __toESM(require_dist2(), 1);
var import_dist180 = __toESM(require_dist3(), 1);
async function sendRawTransaction(client, { serializedTransaction }) {
  return client.request({
    method: "eth_sendRawTransaction",
    params: [serializedTransaction]
  }, { retryCount: 0 });
}

// ../../node_modules/viem/_esm/actions/wallet/sendTransaction.js
var supportsWalletNamespace = new LruMap(128);
async function sendTransaction(client, parameters) {
  var _a, _b, _c, _d, _e;
  const { account: account_ = client.account, assertChainId = true, chain = client.chain, accessList, authorizationList, blobs, data, dataSuffix = typeof client.dataSuffix === "string" ? client.dataSuffix : (_a = client.dataSuffix) == null ? void 0 : _a.value, gas, gasPrice, maxFeePerBlobGas, maxFeePerGas, maxPriorityFeePerGas, nonce, type, value, ...rest } = parameters;
  if (typeof account_ === "undefined")
    throw new AccountNotFoundError({
      docsPath: "/docs/actions/wallet/sendTransaction"
    });
  const account = account_ ? parseAccount(account_) : null;
  try {
    assertRequest(parameters);
    const to = await (async () => {
      if (parameters.to)
        return parameters.to;
      if (parameters.to === null)
        return void 0;
      if (authorizationList && authorizationList.length > 0)
        return await recoverAuthorizationAddress({
          authorization: authorizationList[0]
        }).catch(() => {
          throw new BaseError("`to` is required. Could not infer from `authorizationList`.");
        });
      return void 0;
    })();
    if ((account == null ? void 0 : account.type) === "json-rpc" || account === null) {
      let chainId;
      if (chain !== null) {
        chainId = await getAction(client, getChainId, "getChainId")({});
        if (assertChainId)
          assertCurrentChain({
            currentChainId: chainId,
            chain
          });
      }
      const chainFormat = (_d = (_c = (_b = client.chain) == null ? void 0 : _b.formatters) == null ? void 0 : _c.transactionRequest) == null ? void 0 : _d.format;
      const format = chainFormat || formatTransactionRequest;
      const request2 = format({
        // Pick out extra data that might exist on the chain's transaction request type.
        ...extract(rest, { format: chainFormat }),
        accessList,
        account,
        authorizationList,
        blobs,
        chainId,
        data: data ? concat([data, dataSuffix ?? "0x"]) : data,
        gas,
        gasPrice,
        maxFeePerBlobGas,
        maxFeePerGas,
        maxPriorityFeePerGas,
        nonce,
        to,
        type,
        value
      }, "sendTransaction");
      const isWalletNamespaceSupported = supportsWalletNamespace.get(client.uid);
      const method = isWalletNamespaceSupported ? "wallet_sendTransaction" : "eth_sendTransaction";
      try {
        return await client.request({
          method,
          params: [request2]
        }, { retryCount: 0 });
      } catch (e) {
        if (isWalletNamespaceSupported === false)
          throw e;
        const error = e;
        if (error.name === "InvalidInputRpcError" || error.name === "InvalidParamsRpcError" || error.name === "MethodNotFoundRpcError" || error.name === "MethodNotSupportedRpcError") {
          return await client.request({
            method: "wallet_sendTransaction",
            params: [request2]
          }, { retryCount: 0 }).then((hash2) => {
            supportsWalletNamespace.set(client.uid, true);
            return hash2;
          }).catch((e2) => {
            const walletNamespaceError = e2;
            if (walletNamespaceError.name === "MethodNotFoundRpcError" || walletNamespaceError.name === "MethodNotSupportedRpcError") {
              supportsWalletNamespace.set(client.uid, false);
              throw error;
            }
            throw walletNamespaceError;
          });
        }
        throw error;
      }
    }
    if ((account == null ? void 0 : account.type) === "local") {
      const request2 = await getAction(client, prepareTransactionRequest, "prepareTransactionRequest")({
        account,
        accessList,
        authorizationList,
        blobs,
        chain,
        data: data ? concat([data, dataSuffix ?? "0x"]) : data,
        gas,
        gasPrice,
        maxFeePerBlobGas,
        maxFeePerGas,
        maxPriorityFeePerGas,
        nonce,
        nonceManager: account.nonceManager,
        parameters: [...defaultParameters, "sidecars"],
        type,
        value,
        ...rest,
        to
      });
      const serializer = (_e = chain == null ? void 0 : chain.serializers) == null ? void 0 : _e.transaction;
      const serializedTransaction = await account.signTransaction(request2, {
        serializer
      });
      return await getAction(client, sendRawTransaction, "sendRawTransaction")({
        serializedTransaction
      });
    }
    if ((account == null ? void 0 : account.type) === "smart")
      throw new AccountTypeNotSupportedError({
        metaMessages: [
          "Consider using the `sendUserOperation` Action instead."
        ],
        docsPath: "/docs/actions/bundler/sendUserOperation",
        type: "smart"
      });
    throw new AccountTypeNotSupportedError({
      docsPath: "/docs/actions/wallet/sendTransaction",
      type: account == null ? void 0 : account.type
    });
  } catch (err) {
    if (err instanceof AccountTypeNotSupportedError)
      throw err;
    throw getTransactionError(err, {
      ...parameters,
      account,
      chain: parameters.chain || void 0
    });
  }
}

// ../../node_modules/viem/_esm/actions/wallet/writeContract.js
async function writeContract(client, parameters) {
  return writeContract.internal(client, sendTransaction, "sendTransaction", parameters);
}
(function(writeContract2) {
  async function internal(client, actionFn, name, parameters) {
    const { abi, account: account_ = client.account, address, args, functionName, ...request2 } = parameters;
    if (typeof account_ === "undefined")
      throw new AccountNotFoundError({
        docsPath: "/docs/contract/writeContract"
      });
    const account = account_ ? parseAccount(account_) : null;
    const data = encodeFunctionData({
      abi,
      args,
      functionName
    });
    try {
      return await getAction(client, actionFn, name)({
        data,
        to: address,
        account,
        ...request2
      });
    } catch (error) {
      throw getContractError(error, {
        abi,
        address,
        args,
        docsPath: "/docs/contract/writeContract",
        functionName,
        sender: account == null ? void 0 : account.address
      });
    }
  }
  writeContract2.internal = internal;
})(writeContract || (writeContract = {}));

// ../../node_modules/viem/_esm/actions/wallet/waitForCallsStatus.js
var import_dist205 = __toESM(require_dist(), 1);
var import_dist206 = __toESM(require_dist2(), 1);
var import_dist207 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/errors/calls.js
var import_dist190 = __toESM(require_dist(), 1);
var import_dist191 = __toESM(require_dist2(), 1);
var import_dist192 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/promise/withRetry.js
var import_dist193 = __toESM(require_dist(), 1);
var import_dist194 = __toESM(require_dist2(), 1);
var import_dist195 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/getCallsStatus.js
var import_dist202 = __toESM(require_dist(), 1);
var import_dist203 = __toESM(require_dist2(), 1);
var import_dist204 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/formatters/transactionReceipt.js
var import_dist196 = __toESM(require_dist(), 1);
var import_dist197 = __toESM(require_dist2(), 1);
var import_dist198 = __toESM(require_dist3(), 1);
var receiptStatuses = {
  "0x0": "reverted",
  "0x1": "success"
};
function formatTransactionReceipt(transactionReceipt, _) {
  const receipt = {
    ...transactionReceipt,
    blockNumber: transactionReceipt.blockNumber ? BigInt(transactionReceipt.blockNumber) : null,
    contractAddress: transactionReceipt.contractAddress ? transactionReceipt.contractAddress : null,
    cumulativeGasUsed: transactionReceipt.cumulativeGasUsed ? BigInt(transactionReceipt.cumulativeGasUsed) : null,
    effectiveGasPrice: transactionReceipt.effectiveGasPrice ? BigInt(transactionReceipt.effectiveGasPrice) : null,
    gasUsed: transactionReceipt.gasUsed ? BigInt(transactionReceipt.gasUsed) : null,
    logs: transactionReceipt.logs ? transactionReceipt.logs.map((log) => formatLog(log)) : null,
    to: transactionReceipt.to ? transactionReceipt.to : null,
    transactionIndex: transactionReceipt.transactionIndex ? hexToNumber(transactionReceipt.transactionIndex) : null,
    status: transactionReceipt.status ? receiptStatuses[transactionReceipt.status] : null,
    type: transactionReceipt.type ? transactionType[transactionReceipt.type] || transactionReceipt.type : null
  };
  if (transactionReceipt.blobGasPrice)
    receipt.blobGasPrice = BigInt(transactionReceipt.blobGasPrice);
  if (transactionReceipt.blobGasUsed)
    receipt.blobGasUsed = BigInt(transactionReceipt.blobGasUsed);
  return receipt;
}
var defineTransactionReceipt = defineFormatter("transactionReceipt", formatTransactionReceipt);

// ../../node_modules/viem/_esm/actions/wallet/sendCalls.js
var import_dist199 = __toESM(require_dist(), 1);
var import_dist200 = __toESM(require_dist2(), 1);
var import_dist201 = __toESM(require_dist3(), 1);
var fallbackTransactionErrorMagicIdentifier = numberToHex(0, {
  size: 32
});

// ../../node_modules/viem/_esm/clients/createClient.js
var import_dist211 = __toESM(require_dist(), 1);
var import_dist212 = __toESM(require_dist2(), 1);
var import_dist213 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/uid.js
var import_dist208 = __toESM(require_dist(), 1);
var import_dist209 = __toESM(require_dist2(), 1);
var import_dist210 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/clients/createPublicClient.js
var import_dist592 = __toESM(require_dist(), 1);
var import_dist593 = __toESM(require_dist2(), 1);
var import_dist594 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/clients/decorators/public.js
var import_dist589 = __toESM(require_dist(), 1);
var import_dist590 = __toESM(require_dist2(), 1);
var import_dist591 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/ens/getEnsAddress.js
var import_dist232 = __toESM(require_dist(), 1);
var import_dist233 = __toESM(require_dist2(), 1);
var import_dist234 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/ens/errors.js
var import_dist214 = __toESM(require_dist(), 1);
var import_dist215 = __toESM(require_dist2(), 1);
var import_dist216 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/ens/namehash.js
var import_dist220 = __toESM(require_dist(), 1);
var import_dist221 = __toESM(require_dist2(), 1);
var import_dist222 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/ens/encodedLabelToLabelhash.js
var import_dist217 = __toESM(require_dist(), 1);
var import_dist218 = __toESM(require_dist2(), 1);
var import_dist219 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/ens/packetToBytes.js
var import_dist229 = __toESM(require_dist(), 1);
var import_dist230 = __toESM(require_dist2(), 1);
var import_dist231 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/ens/encodeLabelhash.js
var import_dist223 = __toESM(require_dist(), 1);
var import_dist224 = __toESM(require_dist2(), 1);
var import_dist225 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/ens/labelhash.js
var import_dist226 = __toESM(require_dist(), 1);
var import_dist227 = __toESM(require_dist2(), 1);
var import_dist228 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/ens/getEnsAvatar.js
var import_dist247 = __toESM(require_dist(), 1);
var import_dist248 = __toESM(require_dist2(), 1);
var import_dist249 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/ens/avatar/parseAvatarRecord.js
var import_dist241 = __toESM(require_dist(), 1);
var import_dist242 = __toESM(require_dist2(), 1);
var import_dist243 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/ens/avatar/utils.js
var import_dist238 = __toESM(require_dist(), 1);
var import_dist239 = __toESM(require_dist2(), 1);
var import_dist240 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/errors/ens.js
var import_dist235 = __toESM(require_dist(), 1);
var import_dist236 = __toESM(require_dist2(), 1);
var import_dist237 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/ens/getEnsText.js
var import_dist244 = __toESM(require_dist(), 1);
var import_dist245 = __toESM(require_dist2(), 1);
var import_dist246 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/ens/getEnsName.js
var import_dist250 = __toESM(require_dist(), 1);
var import_dist251 = __toESM(require_dist2(), 1);
var import_dist252 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/ens/getEnsResolver.js
var import_dist253 = __toESM(require_dist(), 1);
var import_dist254 = __toESM(require_dist2(), 1);
var import_dist255 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/createAccessList.js
var import_dist256 = __toESM(require_dist(), 1);
var import_dist257 = __toESM(require_dist2(), 1);
var import_dist258 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/createBlockFilter.js
var import_dist259 = __toESM(require_dist(), 1);
var import_dist260 = __toESM(require_dist2(), 1);
var import_dist261 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/createEventFilter.js
var import_dist262 = __toESM(require_dist(), 1);
var import_dist263 = __toESM(require_dist2(), 1);
var import_dist264 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/createPendingTransactionFilter.js
var import_dist265 = __toESM(require_dist(), 1);
var import_dist266 = __toESM(require_dist2(), 1);
var import_dist267 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getBalance.js
var import_dist268 = __toESM(require_dist(), 1);
var import_dist269 = __toESM(require_dist2(), 1);
var import_dist270 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getBlobBaseFee.js
var import_dist271 = __toESM(require_dist(), 1);
var import_dist272 = __toESM(require_dist2(), 1);
var import_dist273 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getBlockTransactionCount.js
var import_dist274 = __toESM(require_dist(), 1);
var import_dist275 = __toESM(require_dist2(), 1);
var import_dist276 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getCode.js
var import_dist277 = __toESM(require_dist(), 1);
var import_dist278 = __toESM(require_dist2(), 1);
var import_dist279 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getEip712Domain.js
var import_dist283 = __toESM(require_dist(), 1);
var import_dist284 = __toESM(require_dist2(), 1);
var import_dist285 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/errors/eip712.js
var import_dist280 = __toESM(require_dist(), 1);
var import_dist281 = __toESM(require_dist2(), 1);
var import_dist282 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getFeeHistory.js
var import_dist289 = __toESM(require_dist(), 1);
var import_dist290 = __toESM(require_dist2(), 1);
var import_dist291 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/formatters/feeHistory.js
var import_dist286 = __toESM(require_dist(), 1);
var import_dist287 = __toESM(require_dist2(), 1);
var import_dist288 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getFilterLogs.js
var import_dist292 = __toESM(require_dist(), 1);
var import_dist293 = __toESM(require_dist2(), 1);
var import_dist294 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getProof.js
var import_dist505 = __toESM(require_dist(), 1);
var import_dist506 = __toESM(require_dist2(), 1);
var import_dist507 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/formatters/proof.js
var import_dist502 = __toESM(require_dist(), 1);
var import_dist503 = __toESM(require_dist2(), 1);
var import_dist504 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/index.js
var import_dist499 = __toESM(require_dist(), 1);
var import_dist500 = __toESM(require_dist2(), 1);
var import_dist501 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/abi/encodePacked.js
var import_dist295 = __toESM(require_dist(), 1);
var import_dist296 = __toESM(require_dist2(), 1);
var import_dist297 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/address/getContractAddress.js
var import_dist301 = __toESM(require_dist(), 1);
var import_dist302 = __toESM(require_dist2(), 1);
var import_dist303 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/data/isBytes.js
var import_dist298 = __toESM(require_dist(), 1);
var import_dist299 = __toESM(require_dist2(), 1);
var import_dist300 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/authorization/serializeAuthorizationList.js
var import_dist313 = __toESM(require_dist(), 1);
var import_dist314 = __toESM(require_dist2(), 1);
var import_dist315 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/transaction/serializeTransaction.js
var import_dist310 = __toESM(require_dist(), 1);
var import_dist311 = __toESM(require_dist2(), 1);
var import_dist312 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/transaction/assertTransaction.js
var import_dist304 = __toESM(require_dist(), 1);
var import_dist305 = __toESM(require_dist2(), 1);
var import_dist306 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/transaction/serializeAccessList.js
var import_dist307 = __toESM(require_dist(), 1);
var import_dist308 = __toESM(require_dist2(), 1);
var import_dist309 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/authorization/verifyAuthorization.js
var import_dist316 = __toESM(require_dist(), 1);
var import_dist317 = __toESM(require_dist2(), 1);
var import_dist318 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/buildRequest.js
var import_dist322 = __toESM(require_dist(), 1);
var import_dist323 = __toESM(require_dist2(), 1);
var import_dist324 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/promise/withDedupe.js
var import_dist319 = __toESM(require_dist(), 1);
var import_dist320 = __toESM(require_dist2(), 1);
var import_dist321 = __toESM(require_dist3(), 1);
var promiseCache = new LruMap(8192);

// ../../node_modules/viem/_esm/utils/chain/defineChain.js
var import_dist325 = __toESM(require_dist(), 1);
var import_dist326 = __toESM(require_dist2(), 1);
var import_dist327 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/chain/extractChain.js
var import_dist328 = __toESM(require_dist(), 1);
var import_dist329 = __toESM(require_dist2(), 1);
var import_dist330 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/encoding/fromRlp.js
var import_dist331 = __toESM(require_dist(), 1);
var import_dist332 = __toESM(require_dist2(), 1);
var import_dist333 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/hash/isHash.js
var import_dist334 = __toESM(require_dist(), 1);
var import_dist335 = __toESM(require_dist2(), 1);
var import_dist336 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/hash/ripemd160.js
var import_dist343 = __toESM(require_dist(), 1);
var import_dist344 = __toESM(require_dist2(), 1);
var import_dist345 = __toESM(require_dist3(), 1);

// ../../node_modules/@noble/hashes/esm/ripemd160.js
var import_dist340 = __toESM(require_dist());
var import_dist341 = __toESM(require_dist2());
var import_dist342 = __toESM(require_dist3());

// ../../node_modules/@noble/hashes/esm/legacy.js
var import_dist337 = __toESM(require_dist(), 1);
var import_dist338 = __toESM(require_dist2(), 1);
var import_dist339 = __toESM(require_dist3(), 1);
var SHA1_IV = Uint32Array.from([
  1732584193,
  4023233417,
  2562383102,
  271733878,
  3285377520
]);
var SHA1_W = new Uint32Array(80);
var SHA1 = class extends HashMD {
  constructor() {
    super(64, 20, 8, false);
    this.A = SHA1_IV[0] | 0;
    this.B = SHA1_IV[1] | 0;
    this.C = SHA1_IV[2] | 0;
    this.D = SHA1_IV[3] | 0;
    this.E = SHA1_IV[4] | 0;
  }
  get() {
    const { A, B, C, D, E } = this;
    return [A, B, C, D, E];
  }
  set(A, B, C, D, E) {
    this.A = A | 0;
    this.B = B | 0;
    this.C = C | 0;
    this.D = D | 0;
    this.E = E | 0;
  }
  process(view, offset) {
    for (let i = 0; i < 16; i++, offset += 4)
      SHA1_W[i] = view.getUint32(offset, false);
    for (let i = 16; i < 80; i++)
      SHA1_W[i] = rotl(SHA1_W[i - 3] ^ SHA1_W[i - 8] ^ SHA1_W[i - 14] ^ SHA1_W[i - 16], 1);
    let { A, B, C, D, E } = this;
    for (let i = 0; i < 80; i++) {
      let F, K2;
      if (i < 20) {
        F = Chi(B, C, D);
        K2 = 1518500249;
      } else if (i < 40) {
        F = B ^ C ^ D;
        K2 = 1859775393;
      } else if (i < 60) {
        F = Maj(B, C, D);
        K2 = 2400959708;
      } else {
        F = B ^ C ^ D;
        K2 = 3395469782;
      }
      const T = rotl(A, 5) + F + E + K2 + SHA1_W[i] | 0;
      E = D;
      D = C;
      C = rotl(B, 30);
      B = A;
      A = T;
    }
    A = A + this.A | 0;
    B = B + this.B | 0;
    C = C + this.C | 0;
    D = D + this.D | 0;
    E = E + this.E | 0;
    this.set(A, B, C, D, E);
  }
  roundClean() {
    clean(SHA1_W);
  }
  destroy() {
    this.set(0, 0, 0, 0, 0);
    clean(this.buffer);
  }
};
var sha1 = createHasher(() => new SHA1());
var p32 = Math.pow(2, 32);
var K = Array.from({ length: 64 }, (_, i) => Math.floor(p32 * Math.abs(Math.sin(i + 1))));
var MD5_IV = SHA1_IV.slice(0, 4);
var MD5_W = new Uint32Array(16);
var MD5 = class extends HashMD {
  constructor() {
    super(64, 16, 8, true);
    this.A = MD5_IV[0] | 0;
    this.B = MD5_IV[1] | 0;
    this.C = MD5_IV[2] | 0;
    this.D = MD5_IV[3] | 0;
  }
  get() {
    const { A, B, C, D } = this;
    return [A, B, C, D];
  }
  set(A, B, C, D) {
    this.A = A | 0;
    this.B = B | 0;
    this.C = C | 0;
    this.D = D | 0;
  }
  process(view, offset) {
    for (let i = 0; i < 16; i++, offset += 4)
      MD5_W[i] = view.getUint32(offset, true);
    let { A, B, C, D } = this;
    for (let i = 0; i < 64; i++) {
      let F, g, s;
      if (i < 16) {
        F = Chi(B, C, D);
        g = i;
        s = [7, 12, 17, 22];
      } else if (i < 32) {
        F = Chi(D, B, C);
        g = (5 * i + 1) % 16;
        s = [5, 9, 14, 20];
      } else if (i < 48) {
        F = B ^ C ^ D;
        g = (3 * i + 5) % 16;
        s = [4, 11, 16, 23];
      } else {
        F = C ^ (B | ~D);
        g = 7 * i % 16;
        s = [6, 10, 15, 21];
      }
      F = F + A + K[i] + MD5_W[g];
      A = D;
      D = C;
      C = B;
      B = B + rotl(F, s[i % 4]);
    }
    A = A + this.A | 0;
    B = B + this.B | 0;
    C = C + this.C | 0;
    D = D + this.D | 0;
    this.set(A, B, C, D);
  }
  roundClean() {
    clean(MD5_W);
  }
  destroy() {
    this.set(0, 0, 0, 0);
    clean(this.buffer);
  }
};
var md5 = createHasher(() => new MD5());
var Rho160 = Uint8Array.from([
  7,
  4,
  13,
  1,
  10,
  6,
  15,
  3,
  12,
  0,
  9,
  5,
  2,
  14,
  11,
  8
]);
var Id160 = (() => Uint8Array.from(new Array(16).fill(0).map((_, i) => i)))();
var Pi160 = (() => Id160.map((i) => (9 * i + 5) % 16))();
var idxLR = (() => {
  const L = [Id160];
  const R = [Pi160];
  const res = [L, R];
  for (let i = 0; i < 4; i++)
    for (let j of res)
      j.push(j[i].map((k) => Rho160[k]));
  return res;
})();
var idxL = (() => idxLR[0])();
var idxR = (() => idxLR[1])();
var shifts160 = [
  [11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8],
  [12, 13, 11, 15, 6, 9, 9, 7, 12, 15, 11, 13, 7, 8, 7, 7],
  [13, 15, 14, 11, 7, 7, 6, 8, 13, 14, 13, 12, 5, 5, 6, 9],
  [14, 11, 12, 14, 8, 6, 5, 5, 15, 12, 15, 14, 9, 9, 8, 6],
  [15, 12, 13, 13, 9, 5, 8, 6, 14, 11, 12, 11, 8, 6, 5, 5]
].map((i) => Uint8Array.from(i));
var shiftsL160 = idxL.map((idx, i) => idx.map((j) => shifts160[i][j]));
var shiftsR160 = idxR.map((idx, i) => idx.map((j) => shifts160[i][j]));
var Kl160 = Uint32Array.from([
  0,
  1518500249,
  1859775393,
  2400959708,
  2840853838
]);
var Kr160 = Uint32Array.from([
  1352829926,
  1548603684,
  1836072691,
  2053994217,
  0
]);
function ripemd_f(group, x, y, z) {
  if (group === 0)
    return x ^ y ^ z;
  if (group === 1)
    return x & y | ~x & z;
  if (group === 2)
    return (x | ~y) ^ z;
  if (group === 3)
    return x & z | y & ~z;
  return x ^ (y | ~z);
}
var BUF_160 = new Uint32Array(16);
var RIPEMD160 = class extends HashMD {
  constructor() {
    super(64, 20, 8, true);
    this.h0 = 1732584193 | 0;
    this.h1 = 4023233417 | 0;
    this.h2 = 2562383102 | 0;
    this.h3 = 271733878 | 0;
    this.h4 = 3285377520 | 0;
  }
  get() {
    const { h0, h1, h2, h3, h4 } = this;
    return [h0, h1, h2, h3, h4];
  }
  set(h0, h1, h2, h3, h4) {
    this.h0 = h0 | 0;
    this.h1 = h1 | 0;
    this.h2 = h2 | 0;
    this.h3 = h3 | 0;
    this.h4 = h4 | 0;
  }
  process(view, offset) {
    for (let i = 0; i < 16; i++, offset += 4)
      BUF_160[i] = view.getUint32(offset, true);
    let al = this.h0 | 0, ar = al, bl = this.h1 | 0, br = bl, cl = this.h2 | 0, cr = cl, dl = this.h3 | 0, dr = dl, el = this.h4 | 0, er = el;
    for (let group = 0; group < 5; group++) {
      const rGroup = 4 - group;
      const hbl = Kl160[group], hbr = Kr160[group];
      const rl = idxL[group], rr = idxR[group];
      const sl = shiftsL160[group], sr = shiftsR160[group];
      for (let i = 0; i < 16; i++) {
        const tl = rotl(al + ripemd_f(group, bl, cl, dl) + BUF_160[rl[i]] + hbl, sl[i]) + el | 0;
        al = el, el = dl, dl = rotl(cl, 10) | 0, cl = bl, bl = tl;
      }
      for (let i = 0; i < 16; i++) {
        const tr = rotl(ar + ripemd_f(rGroup, br, cr, dr) + BUF_160[rr[i]] + hbr, sr[i]) + er | 0;
        ar = er, er = dr, dr = rotl(cr, 10) | 0, cr = br, br = tr;
      }
    }
    this.set(this.h1 + cl + dr | 0, this.h2 + dl + er | 0, this.h3 + el + ar | 0, this.h4 + al + br | 0, this.h0 + bl + cr | 0);
  }
  roundClean() {
    clean(BUF_160);
  }
  destroy() {
    this.destroyed = true;
    clean(this.buffer);
    this.set(0, 0, 0, 0, 0);
  }
};
var ripemd160 = createHasher(() => new RIPEMD160());

// ../../node_modules/viem/_esm/utils/hash/toEventHash.js
var import_dist346 = __toESM(require_dist(), 1);
var import_dist347 = __toESM(require_dist2(), 1);
var import_dist348 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/hash/toEventSignature.js
var import_dist349 = __toESM(require_dist(), 1);
var import_dist350 = __toESM(require_dist2(), 1);
var import_dist351 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/hash/toFunctionHash.js
var import_dist352 = __toESM(require_dist(), 1);
var import_dist353 = __toESM(require_dist2(), 1);
var import_dist354 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/hash/toFunctionSignature.js
var import_dist355 = __toESM(require_dist(), 1);
var import_dist356 = __toESM(require_dist2(), 1);
var import_dist357 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/nonceManager.js
var import_dist358 = __toESM(require_dist(), 1);
var import_dist359 = __toESM(require_dist2(), 1);
var import_dist360 = __toESM(require_dist3(), 1);
function createNonceManager(parameters) {
  const { source } = parameters;
  const deltaMap = /* @__PURE__ */ new Map();
  const nonceMap = new LruMap(8192);
  const promiseMap = /* @__PURE__ */ new Map();
  const getKey = ({ address, chainId }) => `${address}.${chainId}`;
  return {
    async consume({ address, chainId, client }) {
      const key = getKey({ address, chainId });
      const promise = this.get({ address, chainId, client });
      this.increment({ address, chainId });
      const nonce = await promise;
      await source.set({ address, chainId }, nonce);
      nonceMap.set(key, nonce);
      return nonce;
    },
    async increment({ address, chainId }) {
      const key = getKey({ address, chainId });
      const delta = deltaMap.get(key) ?? 0;
      deltaMap.set(key, delta + 1);
    },
    async get({ address, chainId, client }) {
      const key = getKey({ address, chainId });
      let promise = promiseMap.get(key);
      if (!promise) {
        promise = (async () => {
          try {
            const nonce = await source.get({ address, chainId, client });
            const previousNonce = nonceMap.get(key) ?? 0;
            if (previousNonce > 0 && nonce <= previousNonce)
              return previousNonce + 1;
            nonceMap.delete(key);
            return nonce;
          } finally {
            this.reset({ address, chainId });
          }
        })();
        promiseMap.set(key, promise);
      }
      const delta = deltaMap.get(key) ?? 0;
      return delta + await promise;
    },
    reset({ address, chainId }) {
      const key = getKey({ address, chainId });
      deltaMap.delete(key);
      promiseMap.delete(key);
    }
  };
}
function jsonRpc() {
  return {
    async get(parameters) {
      const { address, client } = parameters;
      return getTransactionCount(client, {
        address,
        blockTag: "pending"
      });
    },
    set() {
    }
  };
}
var nonceManager = createNonceManager({
  source: jsonRpc()
});

// ../../node_modules/viem/_esm/utils/rpc/compat.js
var import_dist376 = __toESM(require_dist(), 1);
var import_dist377 = __toESM(require_dist2(), 1);
var import_dist378 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/rpc/http.js
var import_dist367 = __toESM(require_dist(), 1);
var import_dist368 = __toESM(require_dist2(), 1);
var import_dist369 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/promise/withTimeout.js
var import_dist361 = __toESM(require_dist(), 1);
var import_dist362 = __toESM(require_dist2(), 1);
var import_dist363 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/rpc/id.js
var import_dist364 = __toESM(require_dist(), 1);
var import_dist365 = __toESM(require_dist2(), 1);
var import_dist366 = __toESM(require_dist3(), 1);
function createIdStore() {
  return {
    current: 0,
    take() {
      return this.current++;
    },
    reset() {
      this.current = 0;
    }
  };
}
var idCache = createIdStore();

// ../../node_modules/viem/_esm/utils/rpc/webSocket.js
var import_dist373 = __toESM(require_dist(), 1);
var import_dist374 = __toESM(require_dist2(), 1);
var import_dist375 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/rpc/socket.js
var import_dist370 = __toESM(require_dist(), 1);
var import_dist371 = __toESM(require_dist2(), 1);
var import_dist372 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/hashMessage.js
var import_dist385 = __toESM(require_dist(), 1);
var import_dist386 = __toESM(require_dist2(), 1);
var import_dist387 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/toPrefixedMessage.js
var import_dist382 = __toESM(require_dist(), 1);
var import_dist383 = __toESM(require_dist2(), 1);
var import_dist384 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/constants/strings.js
var import_dist379 = __toESM(require_dist(), 1);
var import_dist380 = __toESM(require_dist2(), 1);
var import_dist381 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/hashTypedData.js
var import_dist394 = __toESM(require_dist(), 1);
var import_dist395 = __toESM(require_dist2(), 1);
var import_dist396 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/typedData.js
var import_dist391 = __toESM(require_dist(), 1);
var import_dist392 = __toESM(require_dist2(), 1);
var import_dist393 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/errors/typedData.js
var import_dist388 = __toESM(require_dist(), 1);
var import_dist389 = __toESM(require_dist2(), 1);
var import_dist390 = __toESM(require_dist3(), 1);
var InvalidDomainError = class extends BaseError {
  constructor({ domain }) {
    super(`Invalid domain "${stringify(domain)}".`, {
      metaMessages: ["Must be a valid EIP-712 domain."]
    });
  }
};
var InvalidPrimaryTypeError = class extends BaseError {
  constructor({ primaryType, types }) {
    super(`Invalid primary type \`${primaryType}\` must be one of \`${JSON.stringify(Object.keys(types))}\`.`, {
      docsPath: "/api/glossary/Errors#typeddatainvalidprimarytypeerror",
      metaMessages: ["Check that the primary type is a key in `types`."]
    });
  }
};
var InvalidStructTypeError = class extends BaseError {
  constructor({ type }) {
    super(`Struct type "${type}" is invalid.`, {
      metaMessages: ["Struct type must not be a Solidity type."],
      name: "InvalidStructTypeError"
    });
  }
};

// ../../node_modules/viem/_esm/utils/typedData.js
function validateTypedData(parameters) {
  const { domain, message, primaryType, types } = parameters;
  const validateData = (struct, data) => {
    for (const param of struct) {
      const { name, type } = param;
      const value = data[name];
      const integerMatch = type.match(integerRegex);
      if (integerMatch && (typeof value === "number" || typeof value === "bigint")) {
        const [_type, base, size_] = integerMatch;
        numberToHex(value, {
          signed: base === "int",
          size: Number.parseInt(size_, 10) / 8
        });
      }
      if (type === "address" && typeof value === "string" && !isAddress(value))
        throw new InvalidAddressError({ address: value });
      const bytesMatch = type.match(bytesRegex);
      if (bytesMatch) {
        const [_type, size_] = bytesMatch;
        if (size_ && size(value) !== Number.parseInt(size_, 10))
          throw new BytesSizeMismatchError({
            expectedSize: Number.parseInt(size_, 10),
            givenSize: size(value)
          });
      }
      const struct2 = types[type];
      if (struct2) {
        validateReference(type);
        validateData(struct2, value);
      }
    }
  };
  if (types.EIP712Domain && domain) {
    if (typeof domain !== "object")
      throw new InvalidDomainError({ domain });
    validateData(types.EIP712Domain, domain);
  }
  if (primaryType !== "EIP712Domain") {
    if (types[primaryType])
      validateData(types[primaryType], message);
    else
      throw new InvalidPrimaryTypeError({ primaryType, types });
  }
}
function getTypesForEIP712Domain({ domain }) {
  return [
    typeof (domain == null ? void 0 : domain.name) === "string" && { name: "name", type: "string" },
    (domain == null ? void 0 : domain.version) && { name: "version", type: "string" },
    (typeof (domain == null ? void 0 : domain.chainId) === "number" || typeof (domain == null ? void 0 : domain.chainId) === "bigint") && {
      name: "chainId",
      type: "uint256"
    },
    (domain == null ? void 0 : domain.verifyingContract) && {
      name: "verifyingContract",
      type: "address"
    },
    (domain == null ? void 0 : domain.salt) && { name: "salt", type: "bytes32" }
  ].filter(Boolean);
}
function validateReference(type) {
  if (type === "address" || type === "bool" || type === "string" || type.startsWith("bytes") || type.startsWith("uint") || type.startsWith("int"))
    throw new InvalidStructTypeError({ type });
}

// ../../node_modules/viem/_esm/utils/signature/hashTypedData.js
function hashTypedData(parameters) {
  const { domain = {}, message, primaryType } = parameters;
  const types = {
    EIP712Domain: getTypesForEIP712Domain({ domain }),
    ...parameters.types
  };
  validateTypedData({
    domain,
    message,
    primaryType,
    types
  });
  const parts = ["0x1901"];
  if (domain)
    parts.push(hashDomain({
      domain,
      types
    }));
  if (primaryType !== "EIP712Domain")
    parts.push(hashStruct({
      data: message,
      primaryType,
      types
    }));
  return keccak256(concat(parts));
}
function hashDomain({ domain, types }) {
  return hashStruct({
    data: domain,
    primaryType: "EIP712Domain",
    types
  });
}
function hashStruct({ data, primaryType, types }) {
  const encoded = encodeData({
    data,
    primaryType,
    types
  });
  return keccak256(encoded);
}
function encodeData({ data, primaryType, types }) {
  const encodedTypes = [{ type: "bytes32" }];
  const encodedValues = [hashType({ primaryType, types })];
  for (const field of types[primaryType]) {
    const [type, value] = encodeField({
      types,
      name: field.name,
      type: field.type,
      value: data[field.name]
    });
    encodedTypes.push(type);
    encodedValues.push(value);
  }
  return encodeAbiParameters(encodedTypes, encodedValues);
}
function hashType({ primaryType, types }) {
  const encodedHashType = toHex(encodeType({ primaryType, types }));
  return keccak256(encodedHashType);
}
function encodeType({ primaryType, types }) {
  let result = "";
  const unsortedDeps = findTypeDependencies({ primaryType, types });
  unsortedDeps.delete(primaryType);
  const deps = [primaryType, ...Array.from(unsortedDeps).sort()];
  for (const type of deps) {
    result += `${type}(${types[type].map(({ name, type: t }) => `${t} ${name}`).join(",")})`;
  }
  return result;
}
function findTypeDependencies({ primaryType: primaryType_, types }, results = /* @__PURE__ */ new Set()) {
  const match = primaryType_.match(/^\w*/u);
  const primaryType = match == null ? void 0 : match[0];
  if (results.has(primaryType) || types[primaryType] === void 0) {
    return results;
  }
  results.add(primaryType);
  for (const field of types[primaryType]) {
    findTypeDependencies({ primaryType: field.type, types }, results);
  }
  return results;
}
function encodeField({ types, name, type, value }) {
  if (types[type] !== void 0) {
    return [
      { type: "bytes32" },
      keccak256(encodeData({ data: value, primaryType: type, types }))
    ];
  }
  if (type === "bytes")
    return [{ type: "bytes32" }, keccak256(value)];
  if (type === "string")
    return [{ type: "bytes32" }, keccak256(toHex(value))];
  if (type.lastIndexOf("]") === type.length - 1) {
    const parsedType = type.slice(0, type.lastIndexOf("["));
    const typeValuePairs = value.map((item) => encodeField({
      name,
      type: parsedType,
      types,
      value: item
    }));
    return [
      { type: "bytes32" },
      keccak256(encodeAbiParameters(typeValuePairs.map(([t]) => t), typeValuePairs.map(([, v]) => v)))
    ];
  }
  return [{ type }, value];
}

// ../../node_modules/viem/_esm/utils/signature/isErc6492Signature.js
var import_dist400 = __toESM(require_dist(), 1);
var import_dist401 = __toESM(require_dist2(), 1);
var import_dist402 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/constants/bytes.js
var import_dist397 = __toESM(require_dist(), 1);
var import_dist398 = __toESM(require_dist2(), 1);
var import_dist399 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/isErc8010Signature.js
var import_dist451 = __toESM(require_dist(), 1);
var import_dist452 = __toESM(require_dist2(), 1);
var import_dist453 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/erc8010/index.js
var import_dist448 = __toESM(require_dist());
var import_dist449 = __toESM(require_dist2());
var import_dist450 = __toESM(require_dist3());

// ../../node_modules/ox/_esm/erc8010/SignatureErc8010.js
var SignatureErc8010_exports = {};
__export(SignatureErc8010_exports, {
  InvalidWrappedSignatureError: () => InvalidWrappedSignatureError,
  assert: () => assert4,
  from: () => from9,
  magicBytes: () => magicBytes,
  suffixParameters: () => suffixParameters,
  unwrap: () => unwrap,
  validate: () => validate3,
  wrap: () => wrap
});
var import_dist445 = __toESM(require_dist(), 1);
var import_dist446 = __toESM(require_dist2(), 1);
var import_dist447 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/core/AbiParameters.js
var import_dist427 = __toESM(require_dist(), 1);
var import_dist428 = __toESM(require_dist2(), 1);
var import_dist429 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/core/Address.js
var import_dist415 = __toESM(require_dist(), 1);
var import_dist416 = __toESM(require_dist2(), 1);
var import_dist417 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/core/Caches.js
var import_dist406 = __toESM(require_dist(), 1);
var import_dist407 = __toESM(require_dist2(), 1);
var import_dist408 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/core/internal/lru.js
var import_dist403 = __toESM(require_dist(), 1);
var import_dist404 = __toESM(require_dist2(), 1);
var import_dist405 = __toESM(require_dist3(), 1);
var LruMap2 = class extends Map {
  constructor(size4) {
    super();
    Object.defineProperty(this, "maxSize", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: void 0
    });
    this.maxSize = size4;
  }
  get(key) {
    const value = super.get(key);
    if (super.has(key) && value !== void 0) {
      this.delete(key);
      super.set(key, value);
    }
    return value;
  }
  set(key, value) {
    super.set(key, value);
    if (this.maxSize && this.size > this.maxSize) {
      const firstKey = this.keys().next().value;
      if (firstKey)
        this.delete(firstKey);
    }
    return this;
  }
};

// ../../node_modules/ox/_esm/core/Caches.js
var caches = {
  checksum: new LruMap2(8192)
};
var checksum = caches.checksum;

// ../../node_modules/ox/_esm/core/Hash.js
var import_dist409 = __toESM(require_dist(), 1);
var import_dist410 = __toESM(require_dist2(), 1);
var import_dist411 = __toESM(require_dist3(), 1);
function keccak2562(value, options = {}) {
  const { as = typeof value === "string" ? "Hex" : "Bytes" } = options;
  const bytes = keccak_256(from(value));
  if (as === "Bytes")
    return bytes;
  return fromBytes(bytes);
}

// ../../node_modules/ox/_esm/core/PublicKey.js
var import_dist412 = __toESM(require_dist(), 1);
var import_dist413 = __toESM(require_dist2(), 1);
var import_dist414 = __toESM(require_dist3(), 1);
function assert(publicKey, options = {}) {
  const { compressed } = options;
  const { prefix, x, y } = publicKey;
  if (compressed === false || typeof x === "bigint" && typeof y === "bigint") {
    if (prefix !== 4)
      throw new InvalidPrefixError({
        prefix,
        cause: new InvalidUncompressedPrefixError()
      });
    return;
  }
  if (compressed === true || typeof x === "bigint" && typeof y === "undefined") {
    if (prefix !== 3 && prefix !== 2)
      throw new InvalidPrefixError({
        prefix,
        cause: new InvalidCompressedPrefixError()
      });
    return;
  }
  throw new InvalidError({ publicKey });
}
function from3(value) {
  const publicKey = (() => {
    if (validate2(value))
      return fromHex2(value);
    if (validate(value))
      return fromBytes2(value);
    const { prefix, x, y } = value;
    if (typeof x === "bigint" && typeof y === "bigint")
      return { prefix: prefix ?? 4, x, y };
    return { prefix, x };
  })();
  assert(publicKey);
  return publicKey;
}
function fromBytes2(publicKey) {
  return fromHex2(fromBytes(publicKey));
}
function fromHex2(publicKey) {
  if (publicKey.length !== 132 && publicKey.length !== 130 && publicKey.length !== 68)
    throw new InvalidSerializedSizeError({ publicKey });
  if (publicKey.length === 130) {
    const x2 = BigInt(slice2(publicKey, 0, 32));
    const y = BigInt(slice2(publicKey, 32, 64));
    return {
      prefix: 4,
      x: x2,
      y
    };
  }
  if (publicKey.length === 132) {
    const prefix2 = Number(slice2(publicKey, 0, 1));
    const x2 = BigInt(slice2(publicKey, 1, 33));
    const y = BigInt(slice2(publicKey, 33, 65));
    return {
      prefix: prefix2,
      x: x2,
      y
    };
  }
  const prefix = Number(slice2(publicKey, 0, 1));
  const x = BigInt(slice2(publicKey, 1, 33));
  return {
    prefix,
    x
  };
}
function toHex2(publicKey, options = {}) {
  assert(publicKey);
  const { prefix, x, y } = publicKey;
  const { includePrefix = true } = options;
  const publicKey_ = concat2(
    includePrefix ? fromNumber(prefix, { size: 1 }) : "0x",
    fromNumber(x, { size: 32 }),
    // If the public key is not compressed, add the y coordinate.
    typeof y === "bigint" ? fromNumber(y, { size: 32 }) : "0x"
  );
  return publicKey_;
}
var InvalidError = class extends BaseError2 {
  constructor({ publicKey }) {
    super(`Value \`${stringify2(publicKey)}\` is not a valid public key.`, {
      metaMessages: [
        "Public key must contain:",
        "- an `x` and `prefix` value (compressed)",
        "- an `x`, `y`, and `prefix` value (uncompressed)"
      ]
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "PublicKey.InvalidError"
    });
  }
};
var InvalidPrefixError = class extends BaseError2 {
  constructor({ prefix, cause }) {
    super(`Prefix "${prefix}" is invalid.`, {
      cause
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "PublicKey.InvalidPrefixError"
    });
  }
};
var InvalidCompressedPrefixError = class extends BaseError2 {
  constructor() {
    super("Prefix must be 2 or 3 for compressed public keys.");
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "PublicKey.InvalidCompressedPrefixError"
    });
  }
};
var InvalidUncompressedPrefixError = class extends BaseError2 {
  constructor() {
    super("Prefix must be 4 for uncompressed public keys.");
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "PublicKey.InvalidUncompressedPrefixError"
    });
  }
};
var InvalidSerializedSizeError = class extends BaseError2 {
  constructor({ publicKey }) {
    super(`Value \`${publicKey}\` is an invalid public key size.`, {
      metaMessages: [
        "Expected: 33 bytes (compressed + prefix), 64 bytes (uncompressed) or 65 bytes (uncompressed + prefix).",
        `Received ${size3(from2(publicKey))} bytes.`
      ]
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "PublicKey.InvalidSerializedSizeError"
    });
  }
};

// ../../node_modules/ox/_esm/core/Address.js
var addressRegex = /^0x[a-fA-F0-9]{40}$/;
function assert2(value, options = {}) {
  const { strict = true } = options;
  if (!addressRegex.test(value))
    throw new InvalidAddressError2({
      address: value,
      cause: new InvalidInputError()
    });
  if (strict) {
    if (value.toLowerCase() === value)
      return;
    if (checksum2(value) !== value)
      throw new InvalidAddressError2({
        address: value,
        cause: new InvalidChecksumError()
      });
  }
}
function checksum2(address) {
  if (checksum.has(address))
    return checksum.get(address);
  assert2(address, { strict: false });
  const hexAddress = address.substring(2).toLowerCase();
  const hash2 = keccak2562(fromString(hexAddress), { as: "Bytes" });
  const characters = hexAddress.split("");
  for (let i = 0; i < 40; i += 2) {
    if (hash2[i >> 1] >> 4 >= 8 && characters[i]) {
      characters[i] = characters[i].toUpperCase();
    }
    if ((hash2[i >> 1] & 15) >= 8 && characters[i + 1]) {
      characters[i + 1] = characters[i + 1].toUpperCase();
    }
  }
  const result = `0x${characters.join("")}`;
  checksum.set(address, result);
  return result;
}
function from4(address, options = {}) {
  const { checksum: checksumVal = false } = options;
  assert2(address);
  if (checksumVal)
    return checksum2(address);
  return address;
}
function fromPublicKey(publicKey, options = {}) {
  const address = keccak2562(`0x${toHex2(publicKey).slice(4)}`).substring(26);
  return from4(`0x${address}`, options);
}
var InvalidAddressError2 = class extends BaseError2 {
  constructor({ address, cause }) {
    super(`Address "${address}" is invalid.`, {
      cause
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Address.InvalidAddressError"
    });
  }
};
var InvalidInputError = class extends BaseError2 {
  constructor() {
    super("Address is not a 20 byte (40 hexadecimal character) value.");
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Address.InvalidInputError"
    });
  }
};
var InvalidChecksumError = class extends BaseError2 {
  constructor() {
    super("Address does not match its checksum counterpart.");
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Address.InvalidChecksumError"
    });
  }
};

// ../../node_modules/ox/_esm/core/internal/abiParameters.js
var import_dist421 = __toESM(require_dist(), 1);
var import_dist422 = __toESM(require_dist2(), 1);
var import_dist423 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/core/Solidity.js
var import_dist418 = __toESM(require_dist(), 1);
var import_dist419 = __toESM(require_dist2(), 1);
var import_dist420 = __toESM(require_dist3(), 1);
var arrayRegex2 = /^(.*)\[([0-9]*)\]$/;
var bytesRegex2 = /^bytes([1-9]|1[0-9]|2[0-9]|3[0-2])?$/;
var integerRegex2 = /^(u?int)(8|16|24|32|40|48|56|64|72|80|88|96|104|112|120|128|136|144|152|160|168|176|184|192|200|208|216|224|232|240|248|256)?$/;
var maxInt8 = 2n ** (8n - 1n) - 1n;
var maxInt16 = 2n ** (16n - 1n) - 1n;
var maxInt24 = 2n ** (24n - 1n) - 1n;
var maxInt32 = 2n ** (32n - 1n) - 1n;
var maxInt40 = 2n ** (40n - 1n) - 1n;
var maxInt48 = 2n ** (48n - 1n) - 1n;
var maxInt56 = 2n ** (56n - 1n) - 1n;
var maxInt64 = 2n ** (64n - 1n) - 1n;
var maxInt72 = 2n ** (72n - 1n) - 1n;
var maxInt80 = 2n ** (80n - 1n) - 1n;
var maxInt88 = 2n ** (88n - 1n) - 1n;
var maxInt96 = 2n ** (96n - 1n) - 1n;
var maxInt104 = 2n ** (104n - 1n) - 1n;
var maxInt112 = 2n ** (112n - 1n) - 1n;
var maxInt120 = 2n ** (120n - 1n) - 1n;
var maxInt128 = 2n ** (128n - 1n) - 1n;
var maxInt136 = 2n ** (136n - 1n) - 1n;
var maxInt144 = 2n ** (144n - 1n) - 1n;
var maxInt152 = 2n ** (152n - 1n) - 1n;
var maxInt160 = 2n ** (160n - 1n) - 1n;
var maxInt168 = 2n ** (168n - 1n) - 1n;
var maxInt176 = 2n ** (176n - 1n) - 1n;
var maxInt184 = 2n ** (184n - 1n) - 1n;
var maxInt192 = 2n ** (192n - 1n) - 1n;
var maxInt200 = 2n ** (200n - 1n) - 1n;
var maxInt208 = 2n ** (208n - 1n) - 1n;
var maxInt216 = 2n ** (216n - 1n) - 1n;
var maxInt224 = 2n ** (224n - 1n) - 1n;
var maxInt232 = 2n ** (232n - 1n) - 1n;
var maxInt240 = 2n ** (240n - 1n) - 1n;
var maxInt248 = 2n ** (248n - 1n) - 1n;
var maxInt256 = 2n ** (256n - 1n) - 1n;
var minInt8 = -(2n ** (8n - 1n));
var minInt16 = -(2n ** (16n - 1n));
var minInt24 = -(2n ** (24n - 1n));
var minInt32 = -(2n ** (32n - 1n));
var minInt40 = -(2n ** (40n - 1n));
var minInt48 = -(2n ** (48n - 1n));
var minInt56 = -(2n ** (56n - 1n));
var minInt64 = -(2n ** (64n - 1n));
var minInt72 = -(2n ** (72n - 1n));
var minInt80 = -(2n ** (80n - 1n));
var minInt88 = -(2n ** (88n - 1n));
var minInt96 = -(2n ** (96n - 1n));
var minInt104 = -(2n ** (104n - 1n));
var minInt112 = -(2n ** (112n - 1n));
var minInt120 = -(2n ** (120n - 1n));
var minInt128 = -(2n ** (128n - 1n));
var minInt136 = -(2n ** (136n - 1n));
var minInt144 = -(2n ** (144n - 1n));
var minInt152 = -(2n ** (152n - 1n));
var minInt160 = -(2n ** (160n - 1n));
var minInt168 = -(2n ** (168n - 1n));
var minInt176 = -(2n ** (176n - 1n));
var minInt184 = -(2n ** (184n - 1n));
var minInt192 = -(2n ** (192n - 1n));
var minInt200 = -(2n ** (200n - 1n));
var minInt208 = -(2n ** (208n - 1n));
var minInt216 = -(2n ** (216n - 1n));
var minInt224 = -(2n ** (224n - 1n));
var minInt232 = -(2n ** (232n - 1n));
var minInt240 = -(2n ** (240n - 1n));
var minInt248 = -(2n ** (248n - 1n));
var minInt256 = -(2n ** (256n - 1n));
var maxUint8 = 2n ** 8n - 1n;
var maxUint16 = 2n ** 16n - 1n;
var maxUint24 = 2n ** 24n - 1n;
var maxUint32 = 2n ** 32n - 1n;
var maxUint40 = 2n ** 40n - 1n;
var maxUint48 = 2n ** 48n - 1n;
var maxUint56 = 2n ** 56n - 1n;
var maxUint64 = 2n ** 64n - 1n;
var maxUint72 = 2n ** 72n - 1n;
var maxUint80 = 2n ** 80n - 1n;
var maxUint88 = 2n ** 88n - 1n;
var maxUint96 = 2n ** 96n - 1n;
var maxUint104 = 2n ** 104n - 1n;
var maxUint112 = 2n ** 112n - 1n;
var maxUint120 = 2n ** 120n - 1n;
var maxUint128 = 2n ** 128n - 1n;
var maxUint136 = 2n ** 136n - 1n;
var maxUint144 = 2n ** 144n - 1n;
var maxUint152 = 2n ** 152n - 1n;
var maxUint160 = 2n ** 160n - 1n;
var maxUint168 = 2n ** 168n - 1n;
var maxUint176 = 2n ** 176n - 1n;
var maxUint184 = 2n ** 184n - 1n;
var maxUint192 = 2n ** 192n - 1n;
var maxUint200 = 2n ** 200n - 1n;
var maxUint208 = 2n ** 208n - 1n;
var maxUint216 = 2n ** 216n - 1n;
var maxUint224 = 2n ** 224n - 1n;
var maxUint232 = 2n ** 232n - 1n;
var maxUint240 = 2n ** 240n - 1n;
var maxUint248 = 2n ** 248n - 1n;
var maxUint2562 = 2n ** 256n - 1n;

// ../../node_modules/ox/_esm/core/internal/abiParameters.js
function decodeParameter(cursor, param, options) {
  const { checksumAddress: checksumAddress2, staticPosition } = options;
  const arrayComponents = getArrayComponents(param.type);
  if (arrayComponents) {
    const [length, type] = arrayComponents;
    return decodeArray(cursor, { ...param, type }, { checksumAddress: checksumAddress2, length, staticPosition });
  }
  if (param.type === "tuple")
    return decodeTuple(cursor, param, {
      checksumAddress: checksumAddress2,
      staticPosition
    });
  if (param.type === "address")
    return decodeAddress(cursor, { checksum: checksumAddress2 });
  if (param.type === "bool")
    return decodeBool(cursor);
  if (param.type.startsWith("bytes"))
    return decodeBytes(cursor, param, { staticPosition });
  if (param.type.startsWith("uint") || param.type.startsWith("int"))
    return decodeNumber(cursor, param);
  if (param.type === "string")
    return decodeString(cursor, { staticPosition });
  throw new InvalidTypeError(param.type);
}
var sizeOfLength = 32;
var sizeOfOffset = 32;
function decodeAddress(cursor, options = {}) {
  const { checksum: checksum3 = false } = options;
  const value = cursor.readBytes(32);
  const wrap3 = (address) => checksum3 ? checksum2(address) : address;
  return [wrap3(fromBytes(slice(value, -20))), 32];
}
function decodeArray(cursor, param, options) {
  const { checksumAddress: checksumAddress2, length, staticPosition } = options;
  if (!length) {
    const offset = toNumber(cursor.readBytes(sizeOfOffset));
    const start = staticPosition + offset;
    const startOfData = start + sizeOfLength;
    cursor.setPosition(start);
    const length2 = toNumber(cursor.readBytes(sizeOfLength));
    const dynamicChild = hasDynamicChild(param);
    let consumed2 = 0;
    const value2 = [];
    for (let i = 0; i < length2; ++i) {
      cursor.setPosition(startOfData + (dynamicChild ? i * 32 : consumed2));
      const [data, consumed_] = decodeParameter(cursor, param, {
        checksumAddress: checksumAddress2,
        staticPosition: startOfData
      });
      consumed2 += consumed_;
      value2.push(data);
    }
    cursor.setPosition(staticPosition + 32);
    return [value2, 32];
  }
  if (hasDynamicChild(param)) {
    const offset = toNumber(cursor.readBytes(sizeOfOffset));
    const start = staticPosition + offset;
    const value2 = [];
    for (let i = 0; i < length; ++i) {
      cursor.setPosition(start + i * 32);
      const [data] = decodeParameter(cursor, param, {
        checksumAddress: checksumAddress2,
        staticPosition: start
      });
      value2.push(data);
    }
    cursor.setPosition(staticPosition + 32);
    return [value2, 32];
  }
  let consumed = 0;
  const value = [];
  for (let i = 0; i < length; ++i) {
    const [data, consumed_] = decodeParameter(cursor, param, {
      checksumAddress: checksumAddress2,
      staticPosition: staticPosition + consumed
    });
    consumed += consumed_;
    value.push(data);
  }
  return [value, consumed];
}
function decodeBool(cursor) {
  return [toBoolean(cursor.readBytes(32), { size: 32 }), 32];
}
function decodeBytes(cursor, param, { staticPosition }) {
  const [_, size4] = param.type.split("bytes");
  if (!size4) {
    const offset = toNumber(cursor.readBytes(32));
    cursor.setPosition(staticPosition + offset);
    const length = toNumber(cursor.readBytes(32));
    if (length === 0) {
      cursor.setPosition(staticPosition + 32);
      return ["0x", 32];
    }
    const data = cursor.readBytes(length);
    cursor.setPosition(staticPosition + 32);
    return [fromBytes(data), 32];
  }
  const value = fromBytes(cursor.readBytes(Number.parseInt(size4, 10), 32));
  return [value, 32];
}
function decodeNumber(cursor, param) {
  const signed = param.type.startsWith("int");
  const size4 = Number.parseInt(param.type.split("int")[1] || "256", 10);
  const value = cursor.readBytes(32);
  return [
    size4 > 48 ? toBigInt(value, { signed }) : toNumber(value, { signed }),
    32
  ];
}
function decodeTuple(cursor, param, options) {
  const { checksumAddress: checksumAddress2, staticPosition } = options;
  const hasUnnamedChild = param.components.length === 0 || param.components.some(({ name }) => !name);
  const value = hasUnnamedChild ? [] : {};
  let consumed = 0;
  if (hasDynamicChild(param)) {
    const offset = toNumber(cursor.readBytes(sizeOfOffset));
    const start = staticPosition + offset;
    for (let i = 0; i < param.components.length; ++i) {
      const component = param.components[i];
      cursor.setPosition(start + consumed);
      const [data, consumed_] = decodeParameter(cursor, component, {
        checksumAddress: checksumAddress2,
        staticPosition: start
      });
      consumed += consumed_;
      value[hasUnnamedChild ? i : component == null ? void 0 : component.name] = data;
    }
    cursor.setPosition(staticPosition + 32);
    return [value, 32];
  }
  for (let i = 0; i < param.components.length; ++i) {
    const component = param.components[i];
    const [data, consumed_] = decodeParameter(cursor, component, {
      checksumAddress: checksumAddress2,
      staticPosition
    });
    value[hasUnnamedChild ? i : component == null ? void 0 : component.name] = data;
    consumed += consumed_;
  }
  return [value, consumed];
}
function decodeString(cursor, { staticPosition }) {
  const offset = toNumber(cursor.readBytes(32));
  const start = staticPosition + offset;
  cursor.setPosition(start);
  const length = toNumber(cursor.readBytes(32));
  if (length === 0) {
    cursor.setPosition(staticPosition + 32);
    return ["", 32];
  }
  const data = cursor.readBytes(length, 32);
  const value = toString(trimLeft(data));
  cursor.setPosition(staticPosition + 32);
  return [value, 32];
}
function prepareParameters({ checksumAddress: checksumAddress2, parameters, values }) {
  const preparedParameters = [];
  for (let i = 0; i < parameters.length; i++) {
    preparedParameters.push(prepareParameter({
      checksumAddress: checksumAddress2,
      parameter: parameters[i],
      value: values[i]
    }));
  }
  return preparedParameters;
}
function prepareParameter({ checksumAddress: checksumAddress2 = false, parameter: parameter_, value }) {
  const parameter = parameter_;
  const arrayComponents = getArrayComponents(parameter.type);
  if (arrayComponents) {
    const [length, type] = arrayComponents;
    return encodeArray(value, {
      checksumAddress: checksumAddress2,
      length,
      parameter: {
        ...parameter,
        type
      }
    });
  }
  if (parameter.type === "tuple") {
    return encodeTuple(value, {
      checksumAddress: checksumAddress2,
      parameter
    });
  }
  if (parameter.type === "address") {
    return encodeAddress(value, {
      checksum: checksumAddress2
    });
  }
  if (parameter.type === "bool") {
    return encodeBoolean(value);
  }
  if (parameter.type.startsWith("uint") || parameter.type.startsWith("int")) {
    const signed = parameter.type.startsWith("int");
    const [, , size4 = "256"] = integerRegex2.exec(parameter.type) ?? [];
    return encodeNumber(value, {
      signed,
      size: Number(size4)
    });
  }
  if (parameter.type.startsWith("bytes")) {
    return encodeBytes(value, { type: parameter.type });
  }
  if (parameter.type === "string") {
    return encodeString(value);
  }
  throw new InvalidTypeError(parameter.type);
}
function encode(preparedParameters) {
  let staticSize = 0;
  for (let i = 0; i < preparedParameters.length; i++) {
    const { dynamic, encoded } = preparedParameters[i];
    if (dynamic)
      staticSize += 32;
    else
      staticSize += size3(encoded);
  }
  const staticParameters = [];
  const dynamicParameters = [];
  let dynamicSize = 0;
  for (let i = 0; i < preparedParameters.length; i++) {
    const { dynamic, encoded } = preparedParameters[i];
    if (dynamic) {
      staticParameters.push(fromNumber(staticSize + dynamicSize, { size: 32 }));
      dynamicParameters.push(encoded);
      dynamicSize += size3(encoded);
    } else {
      staticParameters.push(encoded);
    }
  }
  return concat2(...staticParameters, ...dynamicParameters);
}
function encodeAddress(value, options) {
  const { checksum: checksum3 = false } = options;
  assert2(value, { strict: checksum3 });
  return {
    dynamic: false,
    encoded: padLeft(value.toLowerCase())
  };
}
function encodeArray(value, options) {
  const { checksumAddress: checksumAddress2, length, parameter } = options;
  const dynamic = length === null;
  if (!Array.isArray(value))
    throw new InvalidArrayError(value);
  if (!dynamic && value.length !== length)
    throw new ArrayLengthMismatchError({
      expectedLength: length,
      givenLength: value.length,
      type: `${parameter.type}[${length}]`
    });
  let dynamicChild = false;
  const preparedParameters = [];
  for (let i = 0; i < value.length; i++) {
    const preparedParam = prepareParameter({
      checksumAddress: checksumAddress2,
      parameter,
      value: value[i]
    });
    if (preparedParam.dynamic)
      dynamicChild = true;
    preparedParameters.push(preparedParam);
  }
  if (dynamic || dynamicChild) {
    const data = encode(preparedParameters);
    if (dynamic) {
      const length2 = fromNumber(preparedParameters.length, { size: 32 });
      return {
        dynamic: true,
        encoded: preparedParameters.length > 0 ? concat2(length2, data) : length2
      };
    }
    if (dynamicChild)
      return { dynamic: true, encoded: data };
  }
  return {
    dynamic: false,
    encoded: concat2(...preparedParameters.map(({ encoded }) => encoded))
  };
}
function encodeBytes(value, { type }) {
  const [, parametersize] = type.split("bytes");
  const bytesSize = size3(value);
  if (!parametersize) {
    let value_ = value;
    if (bytesSize % 32 !== 0)
      value_ = padRight(value_, Math.ceil((value.length - 2) / 2 / 32) * 32);
    return {
      dynamic: true,
      encoded: concat2(padLeft(fromNumber(bytesSize, { size: 32 })), value_)
    };
  }
  if (bytesSize !== Number.parseInt(parametersize, 10))
    throw new BytesSizeMismatchError2({
      expectedSize: Number.parseInt(parametersize, 10),
      value
    });
  return { dynamic: false, encoded: padRight(value) };
}
function encodeBoolean(value) {
  if (typeof value !== "boolean")
    throw new BaseError2(`Invalid boolean value: "${value}" (type: ${typeof value}). Expected: \`true\` or \`false\`.`);
  return { dynamic: false, encoded: padLeft(fromBoolean(value)) };
}
function encodeNumber(value, { signed, size: size4 }) {
  if (typeof size4 === "number") {
    const max = 2n ** (BigInt(size4) - (signed ? 1n : 0n)) - 1n;
    const min = signed ? -max - 1n : 0n;
    if (value > max || value < min)
      throw new IntegerOutOfRangeError({
        max: max.toString(),
        min: min.toString(),
        signed,
        size: size4 / 8,
        value: value.toString()
      });
  }
  return {
    dynamic: false,
    encoded: fromNumber(value, {
      size: 32,
      signed
    })
  };
}
function encodeString(value) {
  const hexValue = fromString2(value);
  const partsLength = Math.ceil(size3(hexValue) / 32);
  const parts = [];
  for (let i = 0; i < partsLength; i++) {
    parts.push(padRight(slice2(hexValue, i * 32, (i + 1) * 32)));
  }
  return {
    dynamic: true,
    encoded: concat2(padRight(fromNumber(size3(hexValue), { size: 32 })), ...parts)
  };
}
function encodeTuple(value, options) {
  const { checksumAddress: checksumAddress2, parameter } = options;
  let dynamic = false;
  const preparedParameters = [];
  for (let i = 0; i < parameter.components.length; i++) {
    const param_ = parameter.components[i];
    const index = Array.isArray(value) ? i : param_.name;
    const preparedParam = prepareParameter({
      checksumAddress: checksumAddress2,
      parameter: param_,
      value: value[index]
    });
    preparedParameters.push(preparedParam);
    if (preparedParam.dynamic)
      dynamic = true;
  }
  return {
    dynamic,
    encoded: dynamic ? encode(preparedParameters) : concat2(...preparedParameters.map(({ encoded }) => encoded))
  };
}
function getArrayComponents(type) {
  const matches = type.match(/^(.*)\[(\d+)?\]$/);
  return matches ? (
    // Return `null` if the array is dynamic.
    [matches[2] ? Number(matches[2]) : null, matches[1]]
  ) : void 0;
}
function hasDynamicChild(param) {
  var _a;
  const { type } = param;
  if (type === "string")
    return true;
  if (type === "bytes")
    return true;
  if (type.endsWith("[]"))
    return true;
  if (type === "tuple")
    return (_a = param.components) == null ? void 0 : _a.some(hasDynamicChild);
  const arrayComponents = getArrayComponents(param.type);
  if (arrayComponents && hasDynamicChild({
    ...param,
    type: arrayComponents[1]
  }))
    return true;
  return false;
}

// ../../node_modules/ox/_esm/core/internal/cursor.js
var import_dist424 = __toESM(require_dist(), 1);
var import_dist425 = __toESM(require_dist2(), 1);
var import_dist426 = __toESM(require_dist3(), 1);
var staticCursor = {
  bytes: new Uint8Array(),
  dataView: new DataView(new ArrayBuffer(0)),
  position: 0,
  positionReadCount: /* @__PURE__ */ new Map(),
  recursiveReadCount: 0,
  recursiveReadLimit: Number.POSITIVE_INFINITY,
  assertReadLimit() {
    if (this.recursiveReadCount >= this.recursiveReadLimit)
      throw new RecursiveReadLimitExceededError({
        count: this.recursiveReadCount + 1,
        limit: this.recursiveReadLimit
      });
  },
  assertPosition(position) {
    if (position < 0 || position > this.bytes.length - 1)
      throw new PositionOutOfBoundsError2({
        length: this.bytes.length,
        position
      });
  },
  decrementPosition(offset) {
    if (offset < 0)
      throw new NegativeOffsetError({ offset });
    const position = this.position - offset;
    this.assertPosition(position);
    this.position = position;
  },
  getReadCount(position) {
    return this.positionReadCount.get(position || this.position) || 0;
  },
  incrementPosition(offset) {
    if (offset < 0)
      throw new NegativeOffsetError({ offset });
    const position = this.position + offset;
    this.assertPosition(position);
    this.position = position;
  },
  inspectByte(position_) {
    const position = position_ ?? this.position;
    this.assertPosition(position);
    return this.bytes[position];
  },
  inspectBytes(length, position_) {
    const position = position_ ?? this.position;
    this.assertPosition(position + length - 1);
    return this.bytes.subarray(position, position + length);
  },
  inspectUint8(position_) {
    const position = position_ ?? this.position;
    this.assertPosition(position);
    return this.bytes[position];
  },
  inspectUint16(position_) {
    const position = position_ ?? this.position;
    this.assertPosition(position + 1);
    return this.dataView.getUint16(position);
  },
  inspectUint24(position_) {
    const position = position_ ?? this.position;
    this.assertPosition(position + 2);
    return (this.dataView.getUint16(position) << 8) + this.dataView.getUint8(position + 2);
  },
  inspectUint32(position_) {
    const position = position_ ?? this.position;
    this.assertPosition(position + 3);
    return this.dataView.getUint32(position);
  },
  pushByte(byte) {
    this.assertPosition(this.position);
    this.bytes[this.position] = byte;
    this.position++;
  },
  pushBytes(bytes) {
    this.assertPosition(this.position + bytes.length - 1);
    this.bytes.set(bytes, this.position);
    this.position += bytes.length;
  },
  pushUint8(value) {
    this.assertPosition(this.position);
    this.bytes[this.position] = value;
    this.position++;
  },
  pushUint16(value) {
    this.assertPosition(this.position + 1);
    this.dataView.setUint16(this.position, value);
    this.position += 2;
  },
  pushUint24(value) {
    this.assertPosition(this.position + 2);
    this.dataView.setUint16(this.position, value >> 8);
    this.dataView.setUint8(this.position + 2, value & ~4294967040);
    this.position += 3;
  },
  pushUint32(value) {
    this.assertPosition(this.position + 3);
    this.dataView.setUint32(this.position, value);
    this.position += 4;
  },
  readByte() {
    this.assertReadLimit();
    this._touch();
    const value = this.inspectByte();
    this.position++;
    return value;
  },
  readBytes(length, size4) {
    this.assertReadLimit();
    this._touch();
    const value = this.inspectBytes(length);
    this.position += size4 ?? length;
    return value;
  },
  readUint8() {
    this.assertReadLimit();
    this._touch();
    const value = this.inspectUint8();
    this.position += 1;
    return value;
  },
  readUint16() {
    this.assertReadLimit();
    this._touch();
    const value = this.inspectUint16();
    this.position += 2;
    return value;
  },
  readUint24() {
    this.assertReadLimit();
    this._touch();
    const value = this.inspectUint24();
    this.position += 3;
    return value;
  },
  readUint32() {
    this.assertReadLimit();
    this._touch();
    const value = this.inspectUint32();
    this.position += 4;
    return value;
  },
  get remaining() {
    return this.bytes.length - this.position;
  },
  setPosition(position) {
    const oldPosition = this.position;
    this.assertPosition(position);
    this.position = position;
    return () => this.position = oldPosition;
  },
  _touch() {
    if (this.recursiveReadLimit === Number.POSITIVE_INFINITY)
      return;
    const count = this.getReadCount();
    this.positionReadCount.set(this.position, count + 1);
    if (count > 0)
      this.recursiveReadCount++;
  }
};
function create(bytes, { recursiveReadLimit = 8192 } = {}) {
  const cursor = Object.create(staticCursor);
  cursor.bytes = bytes;
  cursor.dataView = new DataView(bytes.buffer, bytes.byteOffset, bytes.byteLength);
  cursor.positionReadCount = /* @__PURE__ */ new Map();
  cursor.recursiveReadLimit = recursiveReadLimit;
  return cursor;
}
var NegativeOffsetError = class extends BaseError2 {
  constructor({ offset }) {
    super(`Offset \`${offset}\` cannot be negative.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Cursor.NegativeOffsetError"
    });
  }
};
var PositionOutOfBoundsError2 = class extends BaseError2 {
  constructor({ length, position }) {
    super(`Position \`${position}\` is out of bounds (\`0 < position < ${length}\`).`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Cursor.PositionOutOfBoundsError"
    });
  }
};
var RecursiveReadLimitExceededError = class extends BaseError2 {
  constructor({ count, limit }) {
    super(`Recursive read limit of \`${limit}\` exceeded (recursive read count: \`${count}\`).`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Cursor.RecursiveReadLimitExceededError"
    });
  }
};

// ../../node_modules/ox/_esm/core/AbiParameters.js
function decode(parameters, data, options = {}) {
  const { as = "Array", checksumAddress: checksumAddress2 = false } = options;
  const bytes = typeof data === "string" ? fromHex(data) : data;
  const cursor = create(bytes);
  if (size2(bytes) === 0 && parameters.length > 0)
    throw new ZeroDataError();
  if (size2(bytes) && size2(bytes) < 32)
    throw new DataSizeTooSmallError({
      data: typeof data === "string" ? data : fromBytes(data),
      parameters,
      size: size2(bytes)
    });
  let consumed = 0;
  const values = as === "Array" ? [] : {};
  for (let i = 0; i < parameters.length; ++i) {
    const param = parameters[i];
    cursor.setPosition(consumed);
    const [data2, consumed_] = decodeParameter(cursor, param, {
      checksumAddress: checksumAddress2,
      staticPosition: 0
    });
    consumed += consumed_;
    if (as === "Array")
      values.push(data2);
    else
      values[param.name ?? i] = data2;
  }
  return values;
}
function encode2(parameters, values, options) {
  const { checksumAddress: checksumAddress2 = false } = options ?? {};
  if (parameters.length !== values.length)
    throw new LengthMismatchError({
      expectedLength: parameters.length,
      givenLength: values.length
    });
  const preparedParameters = prepareParameters({
    checksumAddress: checksumAddress2,
    parameters,
    values
  });
  const data = encode(preparedParameters);
  if (data.length === 0)
    return "0x";
  return data;
}
function encodePacked(types, values) {
  if (types.length !== values.length)
    throw new LengthMismatchError({
      expectedLength: types.length,
      givenLength: values.length
    });
  const data = [];
  for (let i = 0; i < types.length; i++) {
    const type = types[i];
    const value = values[i];
    data.push(encodePacked.encode(type, value));
  }
  return concat2(...data);
}
(function(encodePacked3) {
  function encode6(type, value, isArray2 = false) {
    if (type === "address") {
      const address = value;
      assert2(address);
      return padLeft(address.toLowerCase(), isArray2 ? 32 : 0);
    }
    if (type === "string")
      return fromString2(value);
    if (type === "bytes")
      return value;
    if (type === "bool")
      return padLeft(fromBoolean(value), isArray2 ? 32 : 1);
    const intMatch = type.match(integerRegex2);
    if (intMatch) {
      const [_type, baseType, bits = "256"] = intMatch;
      const size4 = Number.parseInt(bits, 10) / 8;
      return fromNumber(value, {
        size: isArray2 ? 32 : size4,
        signed: baseType === "int"
      });
    }
    const bytesMatch = type.match(bytesRegex2);
    if (bytesMatch) {
      const [_type, size4] = bytesMatch;
      if (Number.parseInt(size4, 10) !== (value.length - 2) / 2)
        throw new BytesSizeMismatchError2({
          expectedSize: Number.parseInt(size4, 10),
          value
        });
      return padRight(value, isArray2 ? 32 : 0);
    }
    const arrayMatch = type.match(arrayRegex2);
    if (arrayMatch && Array.isArray(value)) {
      const [_type, childType] = arrayMatch;
      const data = [];
      for (let i = 0; i < value.length; i++) {
        data.push(encode6(childType, value[i], true));
      }
      if (data.length === 0)
        return "0x";
      return concat2(...data);
    }
    throw new InvalidTypeError(type);
  }
  encodePacked3.encode = encode6;
})(encodePacked || (encodePacked = {}));
function from5(parameters) {
  if (Array.isArray(parameters) && typeof parameters[0] === "string")
    return parseAbiParameters(parameters);
  if (typeof parameters === "string")
    return parseAbiParameters(parameters);
  return parameters;
}
var DataSizeTooSmallError = class extends BaseError2 {
  constructor({ data, parameters, size: size4 }) {
    super(`Data size of ${size4} bytes is too small for given parameters.`, {
      metaMessages: [
        `Params: (${formatAbiParameters(parameters)})`,
        `Data:   ${data} (${size4} bytes)`
      ]
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "AbiParameters.DataSizeTooSmallError"
    });
  }
};
var ZeroDataError = class extends BaseError2 {
  constructor() {
    super('Cannot decode zero data ("0x") with ABI parameters.');
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "AbiParameters.ZeroDataError"
    });
  }
};
var ArrayLengthMismatchError = class extends BaseError2 {
  constructor({ expectedLength, givenLength, type }) {
    super(`Array length mismatch for type \`${type}\`. Expected: \`${expectedLength}\`. Given: \`${givenLength}\`.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "AbiParameters.ArrayLengthMismatchError"
    });
  }
};
var BytesSizeMismatchError2 = class extends BaseError2 {
  constructor({ expectedSize, value }) {
    super(`Size of bytes "${value}" (bytes${size3(value)}) does not match expected size (bytes${expectedSize}).`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "AbiParameters.BytesSizeMismatchError"
    });
  }
};
var LengthMismatchError = class extends BaseError2 {
  constructor({ expectedLength, givenLength }) {
    super([
      "ABI encoding parameters/values length mismatch.",
      `Expected length (parameters): ${expectedLength}`,
      `Given length (values): ${givenLength}`
    ].join("\n"));
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "AbiParameters.LengthMismatchError"
    });
  }
};
var InvalidArrayError = class extends BaseError2 {
  constructor(value) {
    super(`Value \`${value}\` is not a valid array.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "AbiParameters.InvalidArrayError"
    });
  }
};
var InvalidTypeError = class extends BaseError2 {
  constructor(type) {
    super(`Type \`${type}\` is not a valid ABI Type.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "AbiParameters.InvalidTypeError"
    });
  }
};

// ../../node_modules/ox/_esm/core/Authorization.js
var import_dist436 = __toESM(require_dist(), 1);
var import_dist437 = __toESM(require_dist2(), 1);
var import_dist438 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/core/Rlp.js
var import_dist430 = __toESM(require_dist(), 1);
var import_dist431 = __toESM(require_dist2(), 1);
var import_dist432 = __toESM(require_dist3(), 1);
function from6(value, options) {
  const { as } = options;
  const encodable = getEncodable2(value);
  const cursor = create(new Uint8Array(encodable.length));
  encodable.encode(cursor);
  if (as === "Hex")
    return fromBytes(cursor.bytes);
  return cursor.bytes;
}
function fromHex3(hex, options = {}) {
  const { as = "Hex" } = options;
  return from6(hex, { as });
}
function getEncodable2(bytes) {
  if (Array.isArray(bytes))
    return getEncodableList2(bytes.map((x) => getEncodable2(x)));
  return getEncodableBytes2(bytes);
}
function getEncodableList2(list) {
  const bodyLength = list.reduce((acc, x) => acc + x.length, 0);
  const sizeOfBodyLength = getSizeOfLength2(bodyLength);
  const length = (() => {
    if (bodyLength <= 55)
      return 1 + bodyLength;
    return 1 + sizeOfBodyLength + bodyLength;
  })();
  return {
    length,
    encode(cursor) {
      if (bodyLength <= 55) {
        cursor.pushByte(192 + bodyLength);
      } else {
        cursor.pushByte(192 + 55 + sizeOfBodyLength);
        if (sizeOfBodyLength === 1)
          cursor.pushUint8(bodyLength);
        else if (sizeOfBodyLength === 2)
          cursor.pushUint16(bodyLength);
        else if (sizeOfBodyLength === 3)
          cursor.pushUint24(bodyLength);
        else
          cursor.pushUint32(bodyLength);
      }
      for (const { encode: encode6 } of list) {
        encode6(cursor);
      }
    }
  };
}
function getEncodableBytes2(bytesOrHex) {
  const bytes = typeof bytesOrHex === "string" ? fromHex(bytesOrHex) : bytesOrHex;
  const sizeOfBytesLength = getSizeOfLength2(bytes.length);
  const length = (() => {
    if (bytes.length === 1 && bytes[0] < 128)
      return 1;
    if (bytes.length <= 55)
      return 1 + bytes.length;
    return 1 + sizeOfBytesLength + bytes.length;
  })();
  return {
    length,
    encode(cursor) {
      if (bytes.length === 1 && bytes[0] < 128) {
        cursor.pushBytes(bytes);
      } else if (bytes.length <= 55) {
        cursor.pushByte(128 + bytes.length);
        cursor.pushBytes(bytes);
      } else {
        cursor.pushByte(128 + 55 + sizeOfBytesLength);
        if (sizeOfBytesLength === 1)
          cursor.pushUint8(bytes.length);
        else if (sizeOfBytesLength === 2)
          cursor.pushUint16(bytes.length);
        else if (sizeOfBytesLength === 3)
          cursor.pushUint24(bytes.length);
        else
          cursor.pushUint32(bytes.length);
        cursor.pushBytes(bytes);
      }
    }
  };
}
function getSizeOfLength2(length) {
  if (length <= 255)
    return 1;
  if (length <= 65535)
    return 2;
  if (length <= 16777215)
    return 3;
  if (length <= 4294967295)
    return 4;
  throw new BaseError2("Length is too large.");
}

// ../../node_modules/ox/_esm/core/Signature.js
var import_dist433 = __toESM(require_dist(), 1);
var import_dist434 = __toESM(require_dist2(), 1);
var import_dist435 = __toESM(require_dist3(), 1);
function assert3(signature, options = {}) {
  const { recovered } = options;
  if (typeof signature.r === "undefined")
    throw new MissingPropertiesError({ signature });
  if (typeof signature.s === "undefined")
    throw new MissingPropertiesError({ signature });
  if (recovered && typeof signature.yParity === "undefined")
    throw new MissingPropertiesError({ signature });
  if (signature.r < 0n || signature.r > maxUint2562)
    throw new InvalidRError({ value: signature.r });
  if (signature.s < 0n || signature.s > maxUint2562)
    throw new InvalidSError({ value: signature.s });
  if (typeof signature.yParity === "number" && signature.yParity !== 0 && signature.yParity !== 1)
    throw new InvalidYParityError({ value: signature.yParity });
}
function fromBytes3(signature) {
  return fromHex4(fromBytes(signature));
}
function fromHex4(signature) {
  if (signature.length !== 130 && signature.length !== 132)
    throw new InvalidSerializedSizeError2({ signature });
  const r = BigInt(slice2(signature, 0, 32));
  const s = BigInt(slice2(signature, 32, 64));
  const yParity = (() => {
    const yParity2 = Number(`0x${signature.slice(130)}`);
    if (Number.isNaN(yParity2))
      return void 0;
    try {
      return vToYParity(yParity2);
    } catch {
      throw new InvalidYParityError({ value: yParity2 });
    }
  })();
  if (typeof yParity === "undefined")
    return {
      r,
      s
    };
  return {
    r,
    s,
    yParity
  };
}
function extract2(value) {
  if (typeof value.r === "undefined")
    return void 0;
  if (typeof value.s === "undefined")
    return void 0;
  return from7(value);
}
function from7(signature) {
  const signature_ = (() => {
    if (typeof signature === "string")
      return fromHex4(signature);
    if (signature instanceof Uint8Array)
      return fromBytes3(signature);
    if (typeof signature.r === "string")
      return fromRpc(signature);
    if (signature.v)
      return fromLegacy(signature);
    return {
      r: signature.r,
      s: signature.s,
      ...typeof signature.yParity !== "undefined" ? { yParity: signature.yParity } : {}
    };
  })();
  assert3(signature_);
  return signature_;
}
function fromLegacy(signature) {
  return {
    r: signature.r,
    s: signature.s,
    yParity: vToYParity(signature.v)
  };
}
function fromRpc(signature) {
  const yParity = (() => {
    const v = signature.v ? Number(signature.v) : void 0;
    let yParity2 = signature.yParity ? Number(signature.yParity) : void 0;
    if (typeof v === "number" && typeof yParity2 !== "number")
      yParity2 = vToYParity(v);
    if (typeof yParity2 !== "number")
      throw new InvalidYParityError({ value: signature.yParity });
    return yParity2;
  })();
  return {
    r: BigInt(signature.r),
    s: BigInt(signature.s),
    yParity
  };
}
function toTuple(signature) {
  const { r, s, yParity } = signature;
  return [
    yParity ? "0x01" : "0x",
    r === 0n ? "0x" : trimLeft2(fromNumber(r)),
    s === 0n ? "0x" : trimLeft2(fromNumber(s))
  ];
}
function vToYParity(v) {
  if (v === 0 || v === 27)
    return 0;
  if (v === 1 || v === 28)
    return 1;
  if (v >= 35)
    return v % 2 === 0 ? 1 : 0;
  throw new InvalidVError({ value: v });
}
var InvalidSerializedSizeError2 = class extends BaseError2 {
  constructor({ signature }) {
    super(`Value \`${signature}\` is an invalid signature size.`, {
      metaMessages: [
        "Expected: 64 bytes or 65 bytes.",
        `Received ${size3(from2(signature))} bytes.`
      ]
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Signature.InvalidSerializedSizeError"
    });
  }
};
var MissingPropertiesError = class extends BaseError2 {
  constructor({ signature }) {
    super(`Signature \`${stringify2(signature)}\` is missing either an \`r\`, \`s\`, or \`yParity\` property.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Signature.MissingPropertiesError"
    });
  }
};
var InvalidRError = class extends BaseError2 {
  constructor({ value }) {
    super(`Value \`${value}\` is an invalid r value. r must be a positive integer less than 2^256.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Signature.InvalidRError"
    });
  }
};
var InvalidSError = class extends BaseError2 {
  constructor({ value }) {
    super(`Value \`${value}\` is an invalid s value. s must be a positive integer less than 2^256.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Signature.InvalidSError"
    });
  }
};
var InvalidYParityError = class extends BaseError2 {
  constructor({ value }) {
    super(`Value \`${value}\` is an invalid y-parity value. Y-parity must be 0 or 1.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Signature.InvalidYParityError"
    });
  }
};
var InvalidVError = class extends BaseError2 {
  constructor({ value }) {
    super(`Value \`${value}\` is an invalid v value. v must be 27, 28 or >=35.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Signature.InvalidVError"
    });
  }
};

// ../../node_modules/ox/_esm/core/Authorization.js
function from8(authorization, options = {}) {
  if (typeof authorization.chainId === "string")
    return fromRpc2(authorization);
  return { ...authorization, ...options.signature };
}
function fromRpc2(authorization) {
  const { address, chainId, nonce } = authorization;
  const signature = extract2(authorization);
  return {
    address,
    chainId: Number(chainId),
    nonce: BigInt(nonce),
    ...signature
  };
}
function getSignPayload(authorization) {
  return hash(authorization, { presign: true });
}
function hash(authorization, options = {}) {
  const { presign } = options;
  return keccak2562(concat2("0x05", fromHex3(toTuple2(presign ? {
    address: authorization.address,
    chainId: authorization.chainId,
    nonce: authorization.nonce
  } : authorization))));
}
function toTuple2(authorization) {
  const { address, chainId, nonce } = authorization;
  const signature = extract2(authorization);
  return [
    chainId ? fromNumber(chainId) : "0x",
    address,
    nonce ? fromNumber(nonce) : "0x",
    ...signature ? toTuple(signature) : []
  ];
}

// ../../node_modules/ox/_esm/core/Secp256k1.js
var import_dist442 = __toESM(require_dist(), 1);
var import_dist443 = __toESM(require_dist2(), 1);
var import_dist444 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/core/internal/entropy.js
var import_dist439 = __toESM(require_dist(), 1);
var import_dist440 = __toESM(require_dist2(), 1);
var import_dist441 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/core/Secp256k1.js
function recoverAddress2(options) {
  return fromPublicKey(recoverPublicKey2(options));
}
function recoverPublicKey2(options) {
  const { payload, signature } = options;
  const { r, s, yParity } = signature;
  const signature_ = new secp256k1.Signature(BigInt(r), BigInt(s)).addRecoveryBit(yParity);
  const point = signature_.recoverPublicKey(from2(payload).substring(2));
  return from3(point);
}

// ../../node_modules/ox/_esm/erc8010/SignatureErc8010.js
var magicBytes = "0x8010801080108010801080108010801080108010801080108010801080108010";
var suffixParameters = from5("(uint256 chainId, address delegation, uint256 nonce, uint8 yParity, uint256 r, uint256 s), address to, bytes data");
function assert4(value) {
  if (typeof value === "string") {
    if (slice2(value, -32) !== magicBytes)
      throw new InvalidWrappedSignatureError(value);
  } else
    assert3(value.authorization);
}
function from9(value) {
  if (typeof value === "string")
    return unwrap(value);
  return value;
}
function unwrap(wrapped) {
  assert4(wrapped);
  const suffixLength = toNumber2(slice2(wrapped, -64, -32));
  const suffix = slice2(wrapped, -suffixLength - 64, -64);
  const signature = slice2(wrapped, 0, -suffixLength - 64);
  const [auth, to, data] = decode(suffixParameters, suffix);
  const authorization = from8({
    address: auth.delegation,
    chainId: Number(auth.chainId),
    nonce: auth.nonce,
    yParity: auth.yParity,
    r: auth.r,
    s: auth.s
  });
  return {
    authorization,
    signature,
    ...data && data !== "0x" ? { data, to } : {}
  };
}
function wrap(value) {
  const { data, signature } = value;
  assert4(value);
  const self2 = recoverAddress2({
    payload: getSignPayload(value.authorization),
    signature: from7(value.authorization)
  });
  const suffix = encode2(suffixParameters, [
    {
      ...value.authorization,
      delegation: value.authorization.address,
      chainId: BigInt(value.authorization.chainId)
    },
    value.to ?? self2,
    data ?? "0x"
  ]);
  const suffixLength = fromNumber(size3(suffix), { size: 32 });
  return concat2(signature, suffix, suffixLength, magicBytes);
}
function validate3(value) {
  try {
    assert4(value);
    return true;
  } catch {
    return false;
  }
}
var InvalidWrappedSignatureError = class extends BaseError2 {
  constructor(wrapped) {
    super(`Value \`${wrapped}\` is an invalid ERC-8010 wrapped signature.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "SignatureErc8010.InvalidWrappedSignatureError"
    });
  }
};

// ../../node_modules/viem/_esm/utils/signature/parseErc6492Signature.js
var import_dist454 = __toESM(require_dist(), 1);
var import_dist455 = __toESM(require_dist2(), 1);
var import_dist456 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/parseErc8010Signature.js
var import_dist457 = __toESM(require_dist(), 1);
var import_dist458 = __toESM(require_dist2(), 1);
var import_dist459 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/recoverMessageAddress.js
var import_dist460 = __toESM(require_dist(), 1);
var import_dist461 = __toESM(require_dist2(), 1);
var import_dist462 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/recoverTypedDataAddress.js
var import_dist463 = __toESM(require_dist(), 1);
var import_dist464 = __toESM(require_dist2(), 1);
var import_dist465 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/serializeErc6492Signature.js
var import_dist466 = __toESM(require_dist(), 1);
var import_dist467 = __toESM(require_dist2(), 1);
var import_dist468 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/serializeErc8010Signature.js
var import_dist469 = __toESM(require_dist(), 1);
var import_dist470 = __toESM(require_dist2(), 1);
var import_dist471 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/verifyHash.js
var import_dist472 = __toESM(require_dist(), 1);
var import_dist473 = __toESM(require_dist2(), 1);
var import_dist474 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/verifyMessage.js
var import_dist475 = __toESM(require_dist(), 1);
var import_dist476 = __toESM(require_dist2(), 1);
var import_dist477 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/verifyTypedData.js
var import_dist478 = __toESM(require_dist(), 1);
var import_dist479 = __toESM(require_dist2(), 1);
var import_dist480 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/transaction/getSerializedTransactionType.js
var import_dist481 = __toESM(require_dist(), 1);
var import_dist482 = __toESM(require_dist2(), 1);
var import_dist483 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/transaction/parseTransaction.js
var import_dist484 = __toESM(require_dist(), 1);
var import_dist485 = __toESM(require_dist2(), 1);
var import_dist486 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/unit/parseEther.js
var import_dist493 = __toESM(require_dist(), 1);
var import_dist494 = __toESM(require_dist2(), 1);
var import_dist495 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/unit/parseUnits.js
var import_dist490 = __toESM(require_dist(), 1);
var import_dist491 = __toESM(require_dist2(), 1);
var import_dist492 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/errors/unit.js
var import_dist487 = __toESM(require_dist(), 1);
var import_dist488 = __toESM(require_dist2(), 1);
var import_dist489 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/unit/parseGwei.js
var import_dist496 = __toESM(require_dist(), 1);
var import_dist497 = __toESM(require_dist2(), 1);
var import_dist498 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getStorageAt.js
var import_dist508 = __toESM(require_dist(), 1);
var import_dist509 = __toESM(require_dist2(), 1);
var import_dist510 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getTransaction.js
var import_dist511 = __toESM(require_dist(), 1);
var import_dist512 = __toESM(require_dist2(), 1);
var import_dist513 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getTransactionConfirmations.js
var import_dist514 = __toESM(require_dist(), 1);
var import_dist515 = __toESM(require_dist2(), 1);
var import_dist516 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/getTransactionReceipt.js
var import_dist517 = __toESM(require_dist(), 1);
var import_dist518 = __toESM(require_dist2(), 1);
var import_dist519 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/multicall.js
var import_dist520 = __toESM(require_dist(), 1);
var import_dist521 = __toESM(require_dist2(), 1);
var import_dist522 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/simulateBlocks.js
var import_dist523 = __toESM(require_dist(), 1);
var import_dist524 = __toESM(require_dist2(), 1);
var import_dist525 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/simulateCalls.js
var import_dist541 = __toESM(require_dist(), 1);
var import_dist542 = __toESM(require_dist2(), 1);
var import_dist543 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/core/AbiConstructor.js
var import_dist532 = __toESM(require_dist());
var import_dist533 = __toESM(require_dist2());
var import_dist534 = __toESM(require_dist3());

// ../../node_modules/ox/_esm/core/AbiItem.js
var import_dist529 = __toESM(require_dist(), 1);
var import_dist530 = __toESM(require_dist2(), 1);
var import_dist531 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/core/internal/abiItem.js
var import_dist526 = __toESM(require_dist(), 1);
var import_dist527 = __toESM(require_dist2(), 1);
var import_dist528 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/core/AbiFunction.js
var import_dist535 = __toESM(require_dist());
var import_dist536 = __toESM(require_dist2());
var import_dist537 = __toESM(require_dist3());

// ../../node_modules/viem/_esm/constants/address.js
var import_dist538 = __toESM(require_dist(), 1);
var import_dist539 = __toESM(require_dist2(), 1);
var import_dist540 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/verifyHash.js
var import_dist553 = __toESM(require_dist(), 1);
var import_dist554 = __toESM(require_dist2(), 1);
var import_dist555 = __toESM(require_dist3(), 1);

// ../../node_modules/ox/_esm/erc6492/index.js
var import_dist547 = __toESM(require_dist());
var import_dist548 = __toESM(require_dist2());
var import_dist549 = __toESM(require_dist3());

// ../../node_modules/ox/_esm/erc6492/SignatureErc6492.js
var SignatureErc6492_exports = {};
__export(SignatureErc6492_exports, {
  InvalidWrappedSignatureError: () => InvalidWrappedSignatureError2,
  assert: () => assert5,
  from: () => from13,
  magicBytes: () => magicBytes2,
  universalSignatureValidatorAbi: () => universalSignatureValidatorAbi,
  universalSignatureValidatorBytecode: () => universalSignatureValidatorBytecode,
  unwrap: () => unwrap2,
  validate: () => validate5,
  wrap: () => wrap2
});
var import_dist544 = __toESM(require_dist(), 1);
var import_dist545 = __toESM(require_dist2(), 1);
var import_dist546 = __toESM(require_dist3(), 1);
var magicBytes2 = "0x6492649264926492649264926492649264926492649264926492649264926492";
var universalSignatureValidatorBytecode = "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";
var universalSignatureValidatorAbi = [
  {
    inputs: [
      {
        name: "_signer",
        type: "address"
      },
      {
        name: "_hash",
        type: "bytes32"
      },
      {
        name: "_signature",
        type: "bytes"
      }
    ],
    stateMutability: "nonpayable",
    type: "constructor"
  },
  {
    inputs: [
      {
        name: "_signer",
        type: "address"
      },
      {
        name: "_hash",
        type: "bytes32"
      },
      {
        name: "_signature",
        type: "bytes"
      }
    ],
    outputs: [
      {
        type: "bool"
      }
    ],
    stateMutability: "nonpayable",
    type: "function",
    name: "isValidSig"
  }
];
function assert5(wrapped) {
  if (slice2(wrapped, -32) !== magicBytes2)
    throw new InvalidWrappedSignatureError2(wrapped);
}
function from13(wrapped) {
  if (typeof wrapped === "string")
    return unwrap2(wrapped);
  return wrapped;
}
function unwrap2(wrapped) {
  assert5(wrapped);
  const [to, data, signature] = decode(from5("address, bytes, bytes"), wrapped);
  return { data, signature, to };
}
function wrap2(value) {
  const { data, signature, to } = value;
  return concat2(encode2(from5("address, bytes, bytes"), [
    to,
    data,
    signature
  ]), magicBytes2);
}
function validate5(wrapped) {
  try {
    assert5(wrapped);
    return true;
  } catch {
    return false;
  }
}
var InvalidWrappedSignatureError2 = class extends BaseError2 {
  constructor(wrapped) {
    super(`Value \`${wrapped}\` is an invalid ERC-6492 wrapped signature.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "SignatureErc6492.InvalidWrappedSignatureError"
    });
  }
};

// ../../node_modules/viem/_esm/utils/signature/serializeSignature.js
var import_dist550 = __toESM(require_dist(), 1);
var import_dist551 = __toESM(require_dist2(), 1);
var import_dist552 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/verifyMessage.js
var import_dist556 = __toESM(require_dist(), 1);
var import_dist557 = __toESM(require_dist2(), 1);
var import_dist558 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/verifyTypedData.js
var import_dist559 = __toESM(require_dist(), 1);
var import_dist560 = __toESM(require_dist2(), 1);
var import_dist561 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/waitForTransactionReceipt.js
var import_dist565 = __toESM(require_dist(), 1);
var import_dist566 = __toESM(require_dist2(), 1);
var import_dist567 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/watchBlockNumber.js
var import_dist562 = __toESM(require_dist(), 1);
var import_dist563 = __toESM(require_dist2(), 1);
var import_dist564 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/watchBlocks.js
var import_dist568 = __toESM(require_dist(), 1);
var import_dist569 = __toESM(require_dist2(), 1);
var import_dist570 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/watchEvent.js
var import_dist571 = __toESM(require_dist(), 1);
var import_dist572 = __toESM(require_dist2(), 1);
var import_dist573 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/public/watchPendingTransactions.js
var import_dist574 = __toESM(require_dist(), 1);
var import_dist575 = __toESM(require_dist2(), 1);
var import_dist576 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/siwe/verifySiweMessage.js
var import_dist583 = __toESM(require_dist(), 1);
var import_dist584 = __toESM(require_dist2(), 1);
var import_dist585 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/siwe/parseSiweMessage.js
var import_dist577 = __toESM(require_dist(), 1);
var import_dist578 = __toESM(require_dist2(), 1);
var import_dist579 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/siwe/validateSiweMessage.js
var import_dist580 = __toESM(require_dist(), 1);
var import_dist581 = __toESM(require_dist2(), 1);
var import_dist582 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/sendRawTransactionSync.js
var import_dist586 = __toESM(require_dist(), 1);
var import_dist587 = __toESM(require_dist2(), 1);
var import_dist588 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/clients/createTestClient.js
var import_dist688 = __toESM(require_dist(), 1);
var import_dist689 = __toESM(require_dist2(), 1);
var import_dist690 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/clients/decorators/test.js
var import_dist685 = __toESM(require_dist(), 1);
var import_dist686 = __toESM(require_dist2(), 1);
var import_dist687 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/dropTransaction.js
var import_dist595 = __toESM(require_dist(), 1);
var import_dist596 = __toESM(require_dist2(), 1);
var import_dist597 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/dumpState.js
var import_dist598 = __toESM(require_dist(), 1);
var import_dist599 = __toESM(require_dist2(), 1);
var import_dist600 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/getAutomine.js
var import_dist601 = __toESM(require_dist(), 1);
var import_dist602 = __toESM(require_dist2(), 1);
var import_dist603 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/getTxpoolContent.js
var import_dist604 = __toESM(require_dist(), 1);
var import_dist605 = __toESM(require_dist2(), 1);
var import_dist606 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/getTxpoolStatus.js
var import_dist607 = __toESM(require_dist(), 1);
var import_dist608 = __toESM(require_dist2(), 1);
var import_dist609 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/impersonateAccount.js
var import_dist610 = __toESM(require_dist(), 1);
var import_dist611 = __toESM(require_dist2(), 1);
var import_dist612 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/increaseTime.js
var import_dist613 = __toESM(require_dist(), 1);
var import_dist614 = __toESM(require_dist2(), 1);
var import_dist615 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/inspectTxpool.js
var import_dist616 = __toESM(require_dist(), 1);
var import_dist617 = __toESM(require_dist2(), 1);
var import_dist618 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/loadState.js
var import_dist619 = __toESM(require_dist(), 1);
var import_dist620 = __toESM(require_dist2(), 1);
var import_dist621 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/mine.js
var import_dist622 = __toESM(require_dist(), 1);
var import_dist623 = __toESM(require_dist2(), 1);
var import_dist624 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/removeBlockTimestampInterval.js
var import_dist625 = __toESM(require_dist(), 1);
var import_dist626 = __toESM(require_dist2(), 1);
var import_dist627 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/reset.js
var import_dist628 = __toESM(require_dist(), 1);
var import_dist629 = __toESM(require_dist2(), 1);
var import_dist630 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/revert.js
var import_dist631 = __toESM(require_dist(), 1);
var import_dist632 = __toESM(require_dist2(), 1);
var import_dist633 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/sendUnsignedTransaction.js
var import_dist634 = __toESM(require_dist(), 1);
var import_dist635 = __toESM(require_dist2(), 1);
var import_dist636 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setAutomine.js
var import_dist637 = __toESM(require_dist(), 1);
var import_dist638 = __toESM(require_dist2(), 1);
var import_dist639 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setBalance.js
var import_dist640 = __toESM(require_dist(), 1);
var import_dist641 = __toESM(require_dist2(), 1);
var import_dist642 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setBlockGasLimit.js
var import_dist643 = __toESM(require_dist(), 1);
var import_dist644 = __toESM(require_dist2(), 1);
var import_dist645 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setBlockTimestampInterval.js
var import_dist646 = __toESM(require_dist(), 1);
var import_dist647 = __toESM(require_dist2(), 1);
var import_dist648 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setCode.js
var import_dist649 = __toESM(require_dist(), 1);
var import_dist650 = __toESM(require_dist2(), 1);
var import_dist651 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setCoinbase.js
var import_dist652 = __toESM(require_dist(), 1);
var import_dist653 = __toESM(require_dist2(), 1);
var import_dist654 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setIntervalMining.js
var import_dist655 = __toESM(require_dist(), 1);
var import_dist656 = __toESM(require_dist2(), 1);
var import_dist657 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setLoggingEnabled.js
var import_dist658 = __toESM(require_dist(), 1);
var import_dist659 = __toESM(require_dist2(), 1);
var import_dist660 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setMinGasPrice.js
var import_dist661 = __toESM(require_dist(), 1);
var import_dist662 = __toESM(require_dist2(), 1);
var import_dist663 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setNextBlockBaseFeePerGas.js
var import_dist664 = __toESM(require_dist(), 1);
var import_dist665 = __toESM(require_dist2(), 1);
var import_dist666 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setNextBlockTimestamp.js
var import_dist667 = __toESM(require_dist(), 1);
var import_dist668 = __toESM(require_dist2(), 1);
var import_dist669 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setNonce.js
var import_dist670 = __toESM(require_dist(), 1);
var import_dist671 = __toESM(require_dist2(), 1);
var import_dist672 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setRpcUrl.js
var import_dist673 = __toESM(require_dist(), 1);
var import_dist674 = __toESM(require_dist2(), 1);
var import_dist675 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/setStorageAt.js
var import_dist676 = __toESM(require_dist(), 1);
var import_dist677 = __toESM(require_dist2(), 1);
var import_dist678 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/snapshot.js
var import_dist679 = __toESM(require_dist(), 1);
var import_dist680 = __toESM(require_dist2(), 1);
var import_dist681 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/test/stopImpersonatingAccount.js
var import_dist682 = __toESM(require_dist(), 1);
var import_dist683 = __toESM(require_dist2(), 1);
var import_dist684 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/clients/createWalletClient.js
var import_dist748 = __toESM(require_dist(), 1);
var import_dist749 = __toESM(require_dist2(), 1);
var import_dist750 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/clients/decorators/wallet.js
var import_dist745 = __toESM(require_dist(), 1);
var import_dist746 = __toESM(require_dist2(), 1);
var import_dist747 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/addChain.js
var import_dist691 = __toESM(require_dist(), 1);
var import_dist692 = __toESM(require_dist2(), 1);
var import_dist693 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/deployContract.js
var import_dist694 = __toESM(require_dist(), 1);
var import_dist695 = __toESM(require_dist2(), 1);
var import_dist696 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/getAddresses.js
var import_dist697 = __toESM(require_dist(), 1);
var import_dist698 = __toESM(require_dist2(), 1);
var import_dist699 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/getCapabilities.js
var import_dist700 = __toESM(require_dist(), 1);
var import_dist701 = __toESM(require_dist2(), 1);
var import_dist702 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/getPermissions.js
var import_dist703 = __toESM(require_dist(), 1);
var import_dist704 = __toESM(require_dist2(), 1);
var import_dist705 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/prepareAuthorization.js
var import_dist706 = __toESM(require_dist(), 1);
var import_dist707 = __toESM(require_dist2(), 1);
var import_dist708 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/requestAddresses.js
var import_dist709 = __toESM(require_dist(), 1);
var import_dist710 = __toESM(require_dist2(), 1);
var import_dist711 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/requestPermissions.js
var import_dist712 = __toESM(require_dist(), 1);
var import_dist713 = __toESM(require_dist2(), 1);
var import_dist714 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/sendCallsSync.js
var import_dist715 = __toESM(require_dist(), 1);
var import_dist716 = __toESM(require_dist2(), 1);
var import_dist717 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/sendTransactionSync.js
var import_dist718 = __toESM(require_dist(), 1);
var import_dist719 = __toESM(require_dist2(), 1);
var import_dist720 = __toESM(require_dist3(), 1);
var supportsWalletNamespace2 = new LruMap(128);

// ../../node_modules/viem/_esm/actions/wallet/showCallsStatus.js
var import_dist721 = __toESM(require_dist(), 1);
var import_dist722 = __toESM(require_dist2(), 1);
var import_dist723 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/signAuthorization.js
var import_dist724 = __toESM(require_dist(), 1);
var import_dist725 = __toESM(require_dist2(), 1);
var import_dist726 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/signMessage.js
var import_dist727 = __toESM(require_dist(), 1);
var import_dist728 = __toESM(require_dist2(), 1);
var import_dist729 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/signTransaction.js
var import_dist730 = __toESM(require_dist(), 1);
var import_dist731 = __toESM(require_dist2(), 1);
var import_dist732 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/signTypedData.js
var import_dist733 = __toESM(require_dist(), 1);
var import_dist734 = __toESM(require_dist2(), 1);
var import_dist735 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/switchChain.js
var import_dist736 = __toESM(require_dist(), 1);
var import_dist737 = __toESM(require_dist2(), 1);
var import_dist738 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/watchAsset.js
var import_dist739 = __toESM(require_dist(), 1);
var import_dist740 = __toESM(require_dist2(), 1);
var import_dist741 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/actions/wallet/writeContractSync.js
var import_dist742 = __toESM(require_dist(), 1);
var import_dist743 = __toESM(require_dist2(), 1);
var import_dist744 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/clients/transports/createTransport.js
var import_dist751 = __toESM(require_dist(), 1);
var import_dist752 = __toESM(require_dist2(), 1);
var import_dist753 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/clients/transports/custom.js
var import_dist754 = __toESM(require_dist(), 1);
var import_dist755 = __toESM(require_dist2(), 1);
var import_dist756 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/clients/transports/fallback.js
var import_dist757 = __toESM(require_dist(), 1);
var import_dist758 = __toESM(require_dist2(), 1);
var import_dist759 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/clients/transports/http.js
var import_dist763 = __toESM(require_dist(), 1);
var import_dist764 = __toESM(require_dist2(), 1);
var import_dist765 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/errors/transport.js
var import_dist760 = __toESM(require_dist(), 1);
var import_dist761 = __toESM(require_dist2(), 1);
var import_dist762 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/clients/transports/webSocket.js
var import_dist766 = __toESM(require_dist(), 1);
var import_dist767 = __toESM(require_dist2(), 1);
var import_dist768 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/types/eip1193.js
var import_dist769 = __toESM(require_dist(), 1);
var import_dist770 = __toESM(require_dist2(), 1);
var import_dist771 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/abi/decodeDeployData.js
var import_dist772 = __toESM(require_dist(), 1);
var import_dist773 = __toESM(require_dist2(), 1);
var import_dist774 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/blob/fromBlobs.js
var import_dist775 = __toESM(require_dist(), 1);
var import_dist776 = __toESM(require_dist2(), 1);
var import_dist777 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/blob/sidecarsToVersionedHashes.js
var import_dist778 = __toESM(require_dist(), 1);
var import_dist779 = __toESM(require_dist2(), 1);
var import_dist780 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/ens/toCoinType.js
var import_dist781 = __toESM(require_dist(), 1);
var import_dist782 = __toESM(require_dist2(), 1);
var import_dist783 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/kzg/defineKzg.js
var import_dist784 = __toESM(require_dist(), 1);
var import_dist785 = __toESM(require_dist2(), 1);
var import_dist786 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/kzg/setupKzg.js
var import_dist787 = __toESM(require_dist(), 1);
var import_dist788 = __toESM(require_dist2(), 1);
var import_dist789 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/compactSignatureToSignature.js
var import_dist790 = __toESM(require_dist(), 1);
var import_dist791 = __toESM(require_dist2(), 1);
var import_dist792 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/parseCompactSignature.js
var import_dist793 = __toESM(require_dist(), 1);
var import_dist794 = __toESM(require_dist2(), 1);
var import_dist795 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/parseSignature.js
var import_dist796 = __toESM(require_dist(), 1);
var import_dist797 = __toESM(require_dist2(), 1);
var import_dist798 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/recoverTransactionAddress.js
var import_dist799 = __toESM(require_dist(), 1);
var import_dist800 = __toESM(require_dist2(), 1);
var import_dist801 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/serializeCompactSignature.js
var import_dist802 = __toESM(require_dist(), 1);
var import_dist803 = __toESM(require_dist2(), 1);
var import_dist804 = __toESM(require_dist3(), 1);

// ../../node_modules/viem/_esm/utils/signature/signatureToCompactSignature.js
var import_dist805 = __toESM(require_dist(), 1);
var import_dist806 = __toESM(require_dist2(), 1);
var import_dist807 = __toESM(require_dist3(), 1);

// ../../node_modules/@polymarket/order-utils/dist/model/signature-types.model.js
var import_dist811 = __toESM(require_dist(), 1);
var import_dist812 = __toESM(require_dist2(), 1);
var import_dist813 = __toESM(require_dist3(), 1);
var SignatureType;
(function(SignatureType2) {
  SignatureType2[SignatureType2["EOA"] = 0] = "EOA";
  SignatureType2[SignatureType2["POLY_PROXY"] = 1] = "POLY_PROXY";
  SignatureType2[SignatureType2["POLY_GNOSIS_SAFE"] = 2] = "POLY_GNOSIS_SAFE";
})(SignatureType || (SignatureType = {}));

// ../../node_modules/@polymarket/order-utils/dist/utils.js
var import_dist814 = __toESM(require_dist(), 1);
var import_dist815 = __toESM(require_dist2(), 1);
var import_dist816 = __toESM(require_dist3(), 1);
function generateOrderSalt() {
  return Math.round(Math.random() * Date.now()) + "";
}

// ../../node_modules/@polymarket/order-utils/dist/exchange.order.builder.js
var ExchangeOrderBuilder = class {
  constructor(contractAddress, chainId, signer, generateSalt = generateOrderSalt) {
    __publicField(this, "contractAddress");
    __publicField(this, "chainId");
    __publicField(this, "signer");
    __publicField(this, "generateSalt");
    this.contractAddress = contractAddress;
    this.chainId = chainId;
    this.signer = signer;
    this.generateSalt = generateSalt;
  }
  /**
   * build an order object including the signature.
   * @param orderData
   * @returns a SignedOrder object (order + signature)
   */
  async buildSignedOrder(orderData) {
    const order = await this.buildOrder(orderData);
    const orderTypedData = this.buildOrderTypedData(order);
    const orderSignature = await this.buildOrderSignature(orderTypedData);
    return {
      ...order,
      signature: orderSignature
    };
  }
  /**
   * Creates an Order object from order data.
   * @param OrderData
   * @returns a Order object (not signed)
   */
  async buildOrder({ maker, taker, tokenId, makerAmount, takerAmount, side, feeRateBps, nonce, signer, expiration, signatureType }) {
    if (typeof signer == "undefined" || !signer) {
      signer = maker;
    }
    const signerAddress = await this.signer.getAddress();
    if (signer !== signerAddress) {
      throw new Error("signer does not match");
    }
    if (typeof expiration == "undefined" || !expiration) {
      expiration = "0";
    }
    if (typeof signatureType == "undefined" || !signatureType) {
      signatureType = SignatureType.EOA;
    }
    return {
      salt: this.generateSalt(),
      maker,
      signer,
      taker,
      tokenId,
      makerAmount,
      takerAmount,
      expiration,
      nonce,
      feeRateBps,
      side,
      signatureType
    };
  }
  /**
   * Parses an Order object to EIP712 typed data
   * @param order
   * @returns a EIP712TypedData object
   */
  buildOrderTypedData(order) {
    return {
      primaryType: "Order",
      types: {
        EIP712Domain: EIP712_DOMAIN,
        Order: ORDER_STRUCTURE
      },
      domain: {
        name: PROTOCOL_NAME,
        version: PROTOCOL_VERSION,
        chainId: this.chainId,
        verifyingContract: this.contractAddress
      },
      message: {
        salt: order.salt,
        maker: order.maker,
        signer: order.signer,
        taker: order.taker,
        tokenId: order.tokenId,
        makerAmount: order.makerAmount,
        takerAmount: order.takerAmount,
        expiration: order.expiration,
        nonce: order.nonce,
        feeRateBps: order.feeRateBps,
        side: order.side,
        signatureType: order.signatureType
      }
    };
  }
  /**
   * Generates order's signature from a EIP712TypedData object + the signer address
   * @param typedData
   * @returns a OrderSignature that is an string
   */
  buildOrderSignature(typedData) {
    delete typedData.types.EIP712Domain;
    return this.signer._signTypedData(typedData.domain, typedData.types, typedData.message);
  }
  /**
   * Generates the hash of the order from a EIP712TypedData object.
   * @param orderTypedData
   * @returns a OrderHash that is an string
   */
  buildOrderHash(orderTypedData) {
    const digest = hashTypedData(orderTypedData);
    return digest;
  }
};

// ../../node_modules/@polymarket/order-utils/dist/model/abi.model.js
var import_dist820 = __toESM(require_dist(), 1);
var import_dist821 = __toESM(require_dist2(), 1);
var import_dist822 = __toESM(require_dist3(), 1);

// ../../node_modules/@polymarket/order-utils/dist/model/eip712.model.js
var import_dist823 = __toESM(require_dist(), 1);
var import_dist824 = __toESM(require_dist2(), 1);
var import_dist825 = __toESM(require_dist3(), 1);

// ../../node_modules/@polymarket/order-utils/dist/model/order.model.js
var import_dist826 = __toESM(require_dist(), 1);
var import_dist827 = __toESM(require_dist2(), 1);
var import_dist828 = __toESM(require_dist3(), 1);

// ../../node_modules/@polymarket/order-utils/dist/model/order-side.model.js
var import_dist829 = __toESM(require_dist(), 1);
var import_dist830 = __toESM(require_dist2(), 1);
var import_dist831 = __toESM(require_dist3(), 1);
var Side;
(function(Side3) {
  Side3[Side3["BUY"] = 0] = "BUY";
  Side3[Side3["SELL"] = 1] = "SELL";
})(Side || (Side = {}));

// ../../node_modules/@polymarket/clob-client/dist/types.js
var import_dist835 = __toESM(require_dist(), 1);
var import_dist836 = __toESM(require_dist2(), 1);
var import_dist837 = __toESM(require_dist3(), 1);
var Side2;
(function(Side3) {
  Side3["BUY"] = "BUY";
  Side3["SELL"] = "SELL";
})(Side2 || (Side2 = {}));
var OrderType;
(function(OrderType2) {
  OrderType2["GTC"] = "GTC";
  OrderType2["FOK"] = "FOK";
  OrderType2["GTD"] = "GTD";
  OrderType2["FAK"] = "FAK";
})(OrderType || (OrderType = {}));
var Chain;
(function(Chain2) {
  Chain2[Chain2["POLYGON"] = 137] = "POLYGON";
  Chain2[Chain2["AMOY"] = 80002] = "AMOY";
})(Chain || (Chain = {}));
var PriceHistoryInterval;
(function(PriceHistoryInterval2) {
  PriceHistoryInterval2["MAX"] = "max";
  PriceHistoryInterval2["ONE_WEEK"] = "1w";
  PriceHistoryInterval2["ONE_DAY"] = "1d";
  PriceHistoryInterval2["SIX_HOURS"] = "6h";
  PriceHistoryInterval2["ONE_HOUR"] = "1h";
})(PriceHistoryInterval || (PriceHistoryInterval = {}));
var AssetType;
(function(AssetType2) {
  AssetType2["COLLATERAL"] = "COLLATERAL";
  AssetType2["CONDITIONAL"] = "CONDITIONAL";
})(AssetType || (AssetType = {}));
var RfqMatchType;
(function(RfqMatchType2) {
  RfqMatchType2["COMPLEMENTARY"] = "COMPLEMENTARY";
  RfqMatchType2["MERGE"] = "MERGE";
  RfqMatchType2["MINT"] = "MINT";
})(RfqMatchType || (RfqMatchType = {}));

// ../../node_modules/@polymarket/clob-client/dist/headers/index.js
var import_dist850 = __toESM(require_dist(), 1);
var import_dist851 = __toESM(require_dist2(), 1);
var import_dist852 = __toESM(require_dist3(), 1);

// ../../node_modules/@polymarket/clob-client/dist/signing/index.js
var import_dist847 = __toESM(require_dist(), 1);
var import_dist848 = __toESM(require_dist2(), 1);
var import_dist849 = __toESM(require_dist3(), 1);

// ../../node_modules/@polymarket/clob-client/dist/signing/eip712.js
var import_dist841 = __toESM(require_dist(), 1);
var import_dist842 = __toESM(require_dist2(), 1);
var import_dist843 = __toESM(require_dist3(), 1);

// ../../node_modules/@polymarket/clob-client/dist/signing/constants.js
var import_dist838 = __toESM(require_dist(), 1);
var import_dist839 = __toESM(require_dist2(), 1);
var import_dist840 = __toESM(require_dist3(), 1);
var MSG_TO_SIGN = "This message attests that I control the given wallet";

// ../../node_modules/@polymarket/clob-client/dist/signing/eip712.js
var buildClobEip712Signature = async (signer, chainId, timestamp, nonce) => {
  const address = await signer.getAddress();
  const ts = `${timestamp}`;
  const domain = {
    name: "ClobAuthDomain",
    version: "1",
    chainId
  };
  const types = {
    ClobAuth: [
      { name: "address", type: "address" },
      { name: "timestamp", type: "string" },
      { name: "nonce", type: "uint256" },
      { name: "message", type: "string" }
    ]
  };
  const value = {
    address,
    timestamp: ts,
    nonce,
    message: MSG_TO_SIGN
  };
  const sig = await signer._signTypedData(domain, types, value);
  return sig;
};

// ../../node_modules/@polymarket/clob-client/dist/signing/hmac.js
var import_dist844 = __toESM(require_dist(), 1);
var import_dist845 = __toESM(require_dist2(), 1);
var import_dist846 = __toESM(require_dist3(), 1);
function replaceAll(s, search, replace) {
  return s.split(search).join(replace);
}
function base64ToArrayBuffer(base64) {
  const sanitizedBase64 = base64.replace(/-/g, "+").replace(/_/g, "/").replace(/[^A-Za-z0-9+/=]/g, "");
  const binaryString = atob(sanitizedBase64);
  const bytes = new Uint8Array(binaryString.length);
  for (let i = 0; i < binaryString.length; i++) {
    bytes[i] = binaryString.charCodeAt(i);
  }
  return bytes.buffer;
}
function arrayBufferToBase64(buffer) {
  const bytes = new Uint8Array(buffer);
  let binary = "";
  for (let i = 0; i < bytes.byteLength; i++) {
    binary += String.fromCharCode(bytes[i]);
  }
  return btoa(binary);
}
var buildPolyHmacSignature = async (secret, timestamp, method, requestPath, body) => {
  let message = timestamp + method + requestPath;
  if (body !== void 0) {
    message += body;
  }
  const keyData = base64ToArrayBuffer(secret);
  const cryptoKey = await globalThis.crypto.subtle.importKey("raw", keyData, { name: "HMAC", hash: "SHA-256" }, false, ["sign"]);
  const messageBuffer = new TextEncoder().encode(message);
  const signatureBuffer = await globalThis.crypto.subtle.sign("HMAC", cryptoKey, messageBuffer);
  const sig = arrayBufferToBase64(signatureBuffer);
  const sigUrlSafe = replaceAll(replaceAll(sig, "+", "-"), "/", "_");
  return sigUrlSafe;
};

// ../../node_modules/@polymarket/clob-client/dist/headers/index.js
var createL1Headers = async (signer, chainId, nonce, timestamp) => {
  let ts = Math.floor(Date.now() / 1e3);
  if (timestamp !== void 0) {
    ts = timestamp;
  }
  let n = 0;
  if (nonce !== void 0) {
    n = nonce;
  }
  const sig = await buildClobEip712Signature(signer, chainId, ts, n);
  const address = await signer.getAddress();
  const headers = {
    POLY_ADDRESS: address,
    POLY_SIGNATURE: sig,
    POLY_TIMESTAMP: `${ts}`,
    POLY_NONCE: `${n}`
  };
  return headers;
};
var createL2Headers = async (signer, creds, l2HeaderArgs, timestamp) => {
  let ts = Math.floor(Date.now() / 1e3);
  if (timestamp !== void 0) {
    ts = timestamp;
  }
  const address = await signer.getAddress();
  const sig = await buildPolyHmacSignature(creds.secret, ts, l2HeaderArgs.method, l2HeaderArgs.requestPath, l2HeaderArgs.body);
  const headers = {
    POLY_ADDRESS: address,
    POLY_SIGNATURE: sig,
    POLY_TIMESTAMP: `${ts}`,
    POLY_API_KEY: creds.key,
    POLY_PASSPHRASE: creds.passphrase
  };
  return headers;
};
var injectBuilderHeaders = (l2Header, builderHeaders) => ({
  ...l2Header,
  ...builderHeaders
});

// ../../node_modules/@polymarket/clob-client/dist/http-helpers/index.js
var import_dist1003 = __toESM(require_dist(), 1);
var import_dist1004 = __toESM(require_dist2(), 1);
var import_dist1005 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/index.js
var import_dist1000 = __toESM(require_dist());
var import_dist1001 = __toESM(require_dist2());
var import_dist1002 = __toESM(require_dist3());

// ../../node_modules/axios/lib/axios.js
var import_dist997 = __toESM(require_dist(), 1);
var import_dist998 = __toESM(require_dist2(), 1);
var import_dist999 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/utils.js
var import_dist856 = __toESM(require_dist(), 1);
var import_dist857 = __toESM(require_dist2(), 1);
var import_dist858 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/helpers/bind.js
var import_dist853 = __toESM(require_dist(), 1);
var import_dist854 = __toESM(require_dist2(), 1);
var import_dist855 = __toESM(require_dist3(), 1);
function bind(fn, thisArg) {
  return function wrap3() {
    return fn.apply(thisArg, arguments);
  };
}

// ../../node_modules/axios/lib/utils.js
var { toString: toString2 } = Object.prototype;
var { getPrototypeOf } = Object;
var { iterator, toStringTag } = Symbol;
var kindOf = /* @__PURE__ */ ((cache) => (thing) => {
  const str = toString2.call(thing);
  return cache[str] || (cache[str] = str.slice(8, -1).toLowerCase());
})(/* @__PURE__ */ Object.create(null));
var kindOfTest = (type) => {
  type = type.toLowerCase();
  return (thing) => kindOf(thing) === type;
};
var typeOfTest = (type) => (thing) => typeof thing === type;
var { isArray } = Array;
var isUndefined = typeOfTest("undefined");
function isBuffer(val) {
  return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor) && isFunction(val.constructor.isBuffer) && val.constructor.isBuffer(val);
}
var isArrayBuffer = kindOfTest("ArrayBuffer");
function isArrayBufferView(val) {
  let result;
  if (typeof ArrayBuffer !== "undefined" && ArrayBuffer.isView) {
    result = ArrayBuffer.isView(val);
  } else {
    result = val && val.buffer && isArrayBuffer(val.buffer);
  }
  return result;
}
var isString = typeOfTest("string");
var isFunction = typeOfTest("function");
var isNumber = typeOfTest("number");
var isObject = (thing) => thing !== null && typeof thing === "object";
var isBoolean = (thing) => thing === true || thing === false;
var isPlainObject = (val) => {
  if (kindOf(val) !== "object") {
    return false;
  }
  const prototype2 = getPrototypeOf(val);
  return (prototype2 === null || prototype2 === Object.prototype || Object.getPrototypeOf(prototype2) === null) && !(toStringTag in val) && !(iterator in val);
};
var isEmptyObject = (val) => {
  if (!isObject(val) || isBuffer(val)) {
    return false;
  }
  try {
    return Object.keys(val).length === 0 && Object.getPrototypeOf(val) === Object.prototype;
  } catch (e) {
    return false;
  }
};
var isDate = kindOfTest("Date");
var isFile = kindOfTest("File");
var isBlob = kindOfTest("Blob");
var isFileList = kindOfTest("FileList");
var isStream = (val) => isObject(val) && isFunction(val.pipe);
var isFormData = (thing) => {
  let kind;
  return thing && (typeof FormData === "function" && thing instanceof FormData || isFunction(thing.append) && ((kind = kindOf(thing)) === "formdata" || // detect form-data instance
  kind === "object" && isFunction(thing.toString) && thing.toString() === "[object FormData]"));
};
var isURLSearchParams = kindOfTest("URLSearchParams");
var [isReadableStream, isRequest, isResponse, isHeaders] = ["ReadableStream", "Request", "Response", "Headers"].map(kindOfTest);
var trim2 = (str) => str.trim ? str.trim() : str.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, "");
function forEach(obj, fn, { allOwnKeys = false } = {}) {
  if (obj === null || typeof obj === "undefined") {
    return;
  }
  let i;
  let l;
  if (typeof obj !== "object") {
    obj = [obj];
  }
  if (isArray(obj)) {
    for (i = 0, l = obj.length; i < l; i++) {
      fn.call(null, obj[i], i, obj);
    }
  } else {
    if (isBuffer(obj)) {
      return;
    }
    const keys = allOwnKeys ? Object.getOwnPropertyNames(obj) : Object.keys(obj);
    const len = keys.length;
    let key;
    for (i = 0; i < len; i++) {
      key = keys[i];
      fn.call(null, obj[key], key, obj);
    }
  }
}
function findKey(obj, key) {
  if (isBuffer(obj)) {
    return null;
  }
  key = key.toLowerCase();
  const keys = Object.keys(obj);
  let i = keys.length;
  let _key;
  while (i-- > 0) {
    _key = keys[i];
    if (key === _key.toLowerCase()) {
      return _key;
    }
  }
  return null;
}
var _global = (() => {
  if (typeof globalThis !== "undefined") return globalThis;
  return typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : global;
})();
var isContextDefined = (context) => !isUndefined(context) && context !== _global;
function merge() {
  const { caseless, skipUndefined } = isContextDefined(this) && this || {};
  const result = {};
  const assignValue = (val, key) => {
    const targetKey = caseless && findKey(result, key) || key;
    if (isPlainObject(result[targetKey]) && isPlainObject(val)) {
      result[targetKey] = merge(result[targetKey], val);
    } else if (isPlainObject(val)) {
      result[targetKey] = merge({}, val);
    } else if (isArray(val)) {
      result[targetKey] = val.slice();
    } else if (!skipUndefined || !isUndefined(val)) {
      result[targetKey] = val;
    }
  };
  for (let i = 0, l = arguments.length; i < l; i++) {
    arguments[i] && forEach(arguments[i], assignValue);
  }
  return result;
}
var extend = (a, b, thisArg, { allOwnKeys } = {}) => {
  forEach(b, (val, key) => {
    if (thisArg && isFunction(val)) {
      Object.defineProperty(a, key, {
        value: bind(val, thisArg),
        writable: true,
        enumerable: true,
        configurable: true
      });
    } else {
      Object.defineProperty(a, key, {
        value: val,
        writable: true,
        enumerable: true,
        configurable: true
      });
    }
  }, { allOwnKeys });
  return a;
};
var stripBOM = (content) => {
  if (content.charCodeAt(0) === 65279) {
    content = content.slice(1);
  }
  return content;
};
var inherits = (constructor, superConstructor, props, descriptors) => {
  constructor.prototype = Object.create(superConstructor.prototype, descriptors);
  Object.defineProperty(constructor.prototype, "constructor", {
    value: constructor,
    writable: true,
    enumerable: false,
    configurable: true
  });
  Object.defineProperty(constructor, "super", {
    value: superConstructor.prototype
  });
  props && Object.assign(constructor.prototype, props);
};
var toFlatObject = (sourceObj, destObj, filter2, propFilter) => {
  let props;
  let i;
  let prop;
  const merged = {};
  destObj = destObj || {};
  if (sourceObj == null) return destObj;
  do {
    props = Object.getOwnPropertyNames(sourceObj);
    i = props.length;
    while (i-- > 0) {
      prop = props[i];
      if ((!propFilter || propFilter(prop, sourceObj, destObj)) && !merged[prop]) {
        destObj[prop] = sourceObj[prop];
        merged[prop] = true;
      }
    }
    sourceObj = filter2 !== false && getPrototypeOf(sourceObj);
  } while (sourceObj && (!filter2 || filter2(sourceObj, destObj)) && sourceObj !== Object.prototype);
  return destObj;
};
var endsWith = (str, searchString, position) => {
  str = String(str);
  if (position === void 0 || position > str.length) {
    position = str.length;
  }
  position -= searchString.length;
  const lastIndex = str.indexOf(searchString, position);
  return lastIndex !== -1 && lastIndex === position;
};
var toArray = (thing) => {
  if (!thing) return null;
  if (isArray(thing)) return thing;
  let i = thing.length;
  if (!isNumber(i)) return null;
  const arr = new Array(i);
  while (i-- > 0) {
    arr[i] = thing[i];
  }
  return arr;
};
var isTypedArray = /* @__PURE__ */ ((TypedArray) => {
  return (thing) => {
    return TypedArray && thing instanceof TypedArray;
  };
})(typeof Uint8Array !== "undefined" && getPrototypeOf(Uint8Array));
var forEachEntry = (obj, fn) => {
  const generator = obj && obj[iterator];
  const _iterator = generator.call(obj);
  let result;
  while ((result = _iterator.next()) && !result.done) {
    const pair = result.value;
    fn.call(obj, pair[0], pair[1]);
  }
};
var matchAll = (regExp, str) => {
  let matches;
  const arr = [];
  while ((matches = regExp.exec(str)) !== null) {
    arr.push(matches);
  }
  return arr;
};
var isHTMLForm = kindOfTest("HTMLFormElement");
var toCamelCase = (str) => {
  return str.toLowerCase().replace(
    /[-_\s]([a-z\d])(\w*)/g,
    function replacer(m, p1, p2) {
      return p1.toUpperCase() + p2;
    }
  );
};
var hasOwnProperty = (({ hasOwnProperty: hasOwnProperty2 }) => (obj, prop) => hasOwnProperty2.call(obj, prop))(Object.prototype);
var isRegExp = kindOfTest("RegExp");
var reduceDescriptors = (obj, reducer) => {
  const descriptors = Object.getOwnPropertyDescriptors(obj);
  const reducedDescriptors = {};
  forEach(descriptors, (descriptor, name) => {
    let ret;
    if ((ret = reducer(descriptor, name, obj)) !== false) {
      reducedDescriptors[name] = ret || descriptor;
    }
  });
  Object.defineProperties(obj, reducedDescriptors);
};
var freezeMethods = (obj) => {
  reduceDescriptors(obj, (descriptor, name) => {
    if (isFunction(obj) && ["arguments", "caller", "callee"].indexOf(name) !== -1) {
      return false;
    }
    const value = obj[name];
    if (!isFunction(value)) return;
    descriptor.enumerable = false;
    if ("writable" in descriptor) {
      descriptor.writable = false;
      return;
    }
    if (!descriptor.set) {
      descriptor.set = () => {
        throw Error("Can not rewrite read-only method '" + name + "'");
      };
    }
  });
};
var toObjectSet = (arrayOrString, delimiter) => {
  const obj = {};
  const define = (arr) => {
    arr.forEach((value) => {
      obj[value] = true;
    });
  };
  isArray(arrayOrString) ? define(arrayOrString) : define(String(arrayOrString).split(delimiter));
  return obj;
};
var noop = () => {
};
var toFiniteNumber = (value, defaultValue) => {
  return value != null && Number.isFinite(value = +value) ? value : defaultValue;
};
function isSpecCompliantForm(thing) {
  return !!(thing && isFunction(thing.append) && thing[toStringTag] === "FormData" && thing[iterator]);
}
var toJSONObject = (obj) => {
  const stack = new Array(10);
  const visit = (source, i) => {
    if (isObject(source)) {
      if (stack.indexOf(source) >= 0) {
        return;
      }
      if (isBuffer(source)) {
        return source;
      }
      if (!("toJSON" in source)) {
        stack[i] = source;
        const target = isArray(source) ? [] : {};
        forEach(source, (value, key) => {
          const reducedValue = visit(value, i + 1);
          !isUndefined(reducedValue) && (target[key] = reducedValue);
        });
        stack[i] = void 0;
        return target;
      }
    }
    return source;
  };
  return visit(obj, 0);
};
var isAsyncFn = kindOfTest("AsyncFunction");
var isThenable = (thing) => thing && (isObject(thing) || isFunction(thing)) && isFunction(thing.then) && isFunction(thing.catch);
var _setImmediate = ((setImmediateSupported, postMessageSupported) => {
  if (setImmediateSupported) {
    return setImmediate;
  }
  return postMessageSupported ? ((token, callbacks) => {
    _global.addEventListener("message", ({ source, data }) => {
      if (source === _global && data === token) {
        callbacks.length && callbacks.shift()();
      }
    }, false);
    return (cb) => {
      callbacks.push(cb);
      _global.postMessage(token, "*");
    };
  })(`axios@${Math.random()}`, []) : (cb) => setTimeout(cb);
})(
  typeof setImmediate === "function",
  isFunction(_global.postMessage)
);
var asap = typeof queueMicrotask !== "undefined" ? queueMicrotask.bind(_global) : typeof process !== "undefined" && process.nextTick || _setImmediate;
var isIterable = (thing) => thing != null && isFunction(thing[iterator]);
var utils_default = {
  isArray,
  isArrayBuffer,
  isBuffer,
  isFormData,
  isArrayBufferView,
  isString,
  isNumber,
  isBoolean,
  isObject,
  isPlainObject,
  isEmptyObject,
  isReadableStream,
  isRequest,
  isResponse,
  isHeaders,
  isUndefined,
  isDate,
  isFile,
  isBlob,
  isRegExp,
  isFunction,
  isStream,
  isURLSearchParams,
  isTypedArray,
  isFileList,
  forEach,
  merge,
  extend,
  trim: trim2,
  stripBOM,
  inherits,
  toFlatObject,
  kindOf,
  kindOfTest,
  endsWith,
  toArray,
  forEachEntry,
  matchAll,
  isHTMLForm,
  hasOwnProperty,
  hasOwnProp: hasOwnProperty,
  // an alias to avoid ESLint no-prototype-builtins detection
  reduceDescriptors,
  freezeMethods,
  toObjectSet,
  toCamelCase,
  noop,
  toFiniteNumber,
  findKey,
  global: _global,
  isContextDefined,
  isSpecCompliantForm,
  toJSONObject,
  isAsyncFn,
  isThenable,
  setImmediate: _setImmediate,
  asap,
  isIterable
};

// ../../node_modules/axios/lib/core/Axios.js
var import_dist982 = __toESM(require_dist(), 1);
var import_dist983 = __toESM(require_dist2(), 1);
var import_dist984 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/helpers/buildURL.js
var import_dist871 = __toESM(require_dist(), 1);
var import_dist872 = __toESM(require_dist2(), 1);
var import_dist873 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/helpers/AxiosURLSearchParams.js
var import_dist868 = __toESM(require_dist(), 1);
var import_dist869 = __toESM(require_dist2(), 1);
var import_dist870 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/helpers/toFormData.js
var import_dist865 = __toESM(require_dist(), 1);
var import_dist866 = __toESM(require_dist2(), 1);
var import_dist867 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/core/AxiosError.js
var import_dist859 = __toESM(require_dist(), 1);
var import_dist860 = __toESM(require_dist2(), 1);
var import_dist861 = __toESM(require_dist3(), 1);
var AxiosError = class _AxiosError extends Error {
  static from(error, code, config, request2, response, customProps) {
    const axiosError = new _AxiosError(error.message, code || error.code, config, request2, response);
    axiosError.cause = error;
    axiosError.name = error.name;
    customProps && Object.assign(axiosError, customProps);
    return axiosError;
  }
  /**
   * Create an Error with the specified message, config, error code, request and response.
   *
   * @param {string} message The error message.
   * @param {string} [code] The error code (for example, 'ECONNABORTED').
   * @param {Object} [config] The config.
   * @param {Object} [request] The request.
   * @param {Object} [response] The response.
   *
   * @returns {Error} The created error.
   */
  constructor(message, code, config, request2, response) {
    super(message);
    this.name = "AxiosError";
    this.isAxiosError = true;
    code && (this.code = code);
    config && (this.config = config);
    request2 && (this.request = request2);
    if (response) {
      this.response = response;
      this.status = response.status;
    }
  }
  toJSON() {
    return {
      // Standard
      message: this.message,
      name: this.name,
      // Microsoft
      description: this.description,
      number: this.number,
      // Mozilla
      fileName: this.fileName,
      lineNumber: this.lineNumber,
      columnNumber: this.columnNumber,
      stack: this.stack,
      // Axios
      config: utils_default.toJSONObject(this.config),
      code: this.code,
      status: this.status
    };
  }
};
AxiosError.ERR_BAD_OPTION_VALUE = "ERR_BAD_OPTION_VALUE";
AxiosError.ERR_BAD_OPTION = "ERR_BAD_OPTION";
AxiosError.ECONNABORTED = "ECONNABORTED";
AxiosError.ETIMEDOUT = "ETIMEDOUT";
AxiosError.ERR_NETWORK = "ERR_NETWORK";
AxiosError.ERR_FR_TOO_MANY_REDIRECTS = "ERR_FR_TOO_MANY_REDIRECTS";
AxiosError.ERR_DEPRECATED = "ERR_DEPRECATED";
AxiosError.ERR_BAD_RESPONSE = "ERR_BAD_RESPONSE";
AxiosError.ERR_BAD_REQUEST = "ERR_BAD_REQUEST";
AxiosError.ERR_CANCELED = "ERR_CANCELED";
AxiosError.ERR_NOT_SUPPORT = "ERR_NOT_SUPPORT";
AxiosError.ERR_INVALID_URL = "ERR_INVALID_URL";
var AxiosError_default = AxiosError;

// ../../node_modules/axios/lib/helpers/null.js
var import_dist862 = __toESM(require_dist(), 1);
var import_dist863 = __toESM(require_dist2(), 1);
var import_dist864 = __toESM(require_dist3(), 1);
var null_default = null;

// ../../node_modules/axios/lib/helpers/toFormData.js
function isVisitable(thing) {
  return utils_default.isPlainObject(thing) || utils_default.isArray(thing);
}
function removeBrackets(key) {
  return utils_default.endsWith(key, "[]") ? key.slice(0, -2) : key;
}
function renderKey(path, key, dots) {
  if (!path) return key;
  return path.concat(key).map(function each(token, i) {
    token = removeBrackets(token);
    return !dots && i ? "[" + token + "]" : token;
  }).join(dots ? "." : "");
}
function isFlatArray(arr) {
  return utils_default.isArray(arr) && !arr.some(isVisitable);
}
var predicates = utils_default.toFlatObject(utils_default, {}, null, function filter(prop) {
  return /^is[A-Z]/.test(prop);
});
function toFormData(obj, formData, options) {
  if (!utils_default.isObject(obj)) {
    throw new TypeError("target must be an object");
  }
  formData = formData || new (null_default || FormData)();
  options = utils_default.toFlatObject(options, {
    metaTokens: true,
    dots: false,
    indexes: false
  }, false, function defined(option, source) {
    return !utils_default.isUndefined(source[option]);
  });
  const metaTokens = options.metaTokens;
  const visitor = options.visitor || defaultVisitor;
  const dots = options.dots;
  const indexes = options.indexes;
  const _Blob = options.Blob || typeof Blob !== "undefined" && Blob;
  const useBlob = _Blob && utils_default.isSpecCompliantForm(formData);
  if (!utils_default.isFunction(visitor)) {
    throw new TypeError("visitor must be a function");
  }
  function convertValue(value) {
    if (value === null) return "";
    if (utils_default.isDate(value)) {
      return value.toISOString();
    }
    if (utils_default.isBoolean(value)) {
      return value.toString();
    }
    if (!useBlob && utils_default.isBlob(value)) {
      throw new AxiosError_default("Blob is not supported. Use a Buffer instead.");
    }
    if (utils_default.isArrayBuffer(value) || utils_default.isTypedArray(value)) {
      return useBlob && typeof Blob === "function" ? new Blob([value]) : Buffer.from(value);
    }
    return value;
  }
  function defaultVisitor(value, key, path) {
    let arr = value;
    if (value && !path && typeof value === "object") {
      if (utils_default.endsWith(key, "{}")) {
        key = metaTokens ? key : key.slice(0, -2);
        value = JSON.stringify(value);
      } else if (utils_default.isArray(value) && isFlatArray(value) || (utils_default.isFileList(value) || utils_default.endsWith(key, "[]")) && (arr = utils_default.toArray(value))) {
        key = removeBrackets(key);
        arr.forEach(function each(el, index) {
          !(utils_default.isUndefined(el) || el === null) && formData.append(
            // eslint-disable-next-line no-nested-ternary
            indexes === true ? renderKey([key], index, dots) : indexes === null ? key : key + "[]",
            convertValue(el)
          );
        });
        return false;
      }
    }
    if (isVisitable(value)) {
      return true;
    }
    formData.append(renderKey(path, key, dots), convertValue(value));
    return false;
  }
  const stack = [];
  const exposedHelpers = Object.assign(predicates, {
    defaultVisitor,
    convertValue,
    isVisitable
  });
  function build(value, path) {
    if (utils_default.isUndefined(value)) return;
    if (stack.indexOf(value) !== -1) {
      throw Error("Circular reference detected in " + path.join("."));
    }
    stack.push(value);
    utils_default.forEach(value, function each(el, key) {
      const result = !(utils_default.isUndefined(el) || el === null) && visitor.call(
        formData,
        el,
        utils_default.isString(key) ? key.trim() : key,
        path,
        exposedHelpers
      );
      if (result === true) {
        build(el, path ? path.concat(key) : [key]);
      }
    });
    stack.pop();
  }
  if (!utils_default.isObject(obj)) {
    throw new TypeError("data must be an object");
  }
  build(obj);
  return formData;
}
var toFormData_default = toFormData;

// ../../node_modules/axios/lib/helpers/AxiosURLSearchParams.js
function encode4(str) {
  const charMap = {
    "!": "%21",
    "'": "%27",
    "(": "%28",
    ")": "%29",
    "~": "%7E",
    "%20": "+",
    "%00": "\0"
  };
  return encodeURIComponent(str).replace(/[!'()~]|%20|%00/g, function replacer(match) {
    return charMap[match];
  });
}
function AxiosURLSearchParams(params, options) {
  this._pairs = [];
  params && toFormData_default(params, this, options);
}
var prototype = AxiosURLSearchParams.prototype;
prototype.append = function append(name, value) {
  this._pairs.push([name, value]);
};
prototype.toString = function toString3(encoder) {
  const _encode = encoder ? function(value) {
    return encoder.call(this, value, encode4);
  } : encode4;
  return this._pairs.map(function each(pair) {
    return _encode(pair[0]) + "=" + _encode(pair[1]);
  }, "").join("&");
};
var AxiosURLSearchParams_default = AxiosURLSearchParams;

// ../../node_modules/axios/lib/helpers/buildURL.js
function encode5(val) {
  return encodeURIComponent(val).replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%20/g, "+");
}
function buildURL(url, params, options) {
  if (!params) {
    return url;
  }
  const _encode = options && options.encode || encode5;
  const _options = utils_default.isFunction(options) ? {
    serialize: options
  } : options;
  const serializeFn = _options && _options.serialize;
  let serializedParams;
  if (serializeFn) {
    serializedParams = serializeFn(params, _options);
  } else {
    serializedParams = utils_default.isURLSearchParams(params) ? params.toString() : new AxiosURLSearchParams_default(params, _options).toString(_encode);
  }
  if (serializedParams) {
    const hashmarkIndex = url.indexOf("#");
    if (hashmarkIndex !== -1) {
      url = url.slice(0, hashmarkIndex);
    }
    url += (url.indexOf("?") === -1 ? "?" : "&") + serializedParams;
  }
  return url;
}

// ../../node_modules/axios/lib/core/InterceptorManager.js
var import_dist874 = __toESM(require_dist(), 1);
var import_dist875 = __toESM(require_dist2(), 1);
var import_dist876 = __toESM(require_dist3(), 1);
var InterceptorManager = class {
  constructor() {
    this.handlers = [];
  }
  /**
   * Add a new interceptor to the stack
   *
   * @param {Function} fulfilled The function to handle `then` for a `Promise`
   * @param {Function} rejected The function to handle `reject` for a `Promise`
   * @param {Object} options The options for the interceptor, synchronous and runWhen
   *
   * @return {Number} An ID used to remove interceptor later
   */
  use(fulfilled, rejected, options) {
    this.handlers.push({
      fulfilled,
      rejected,
      synchronous: options ? options.synchronous : false,
      runWhen: options ? options.runWhen : null
    });
    return this.handlers.length - 1;
  }
  /**
   * Remove an interceptor from the stack
   *
   * @param {Number} id The ID that was returned by `use`
   *
   * @returns {void}
   */
  eject(id) {
    if (this.handlers[id]) {
      this.handlers[id] = null;
    }
  }
  /**
   * Clear all interceptors from the stack
   *
   * @returns {void}
   */
  clear() {
    if (this.handlers) {
      this.handlers = [];
    }
  }
  /**
   * Iterate over all the registered interceptors
   *
   * This method is particularly useful for skipping over any
   * interceptors that may have become `null` calling `eject`.
   *
   * @param {Function} fn The function to call for each interceptor
   *
   * @returns {void}
   */
  forEach(fn) {
    utils_default.forEach(this.handlers, function forEachHandler(h) {
      if (h !== null) {
        fn(h);
      }
    });
  }
};
var InterceptorManager_default = InterceptorManager;

// ../../node_modules/axios/lib/core/dispatchRequest.js
var import_dist973 = __toESM(require_dist(), 1);
var import_dist974 = __toESM(require_dist2(), 1);
var import_dist975 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/core/transformData.js
var import_dist913 = __toESM(require_dist(), 1);
var import_dist914 = __toESM(require_dist2(), 1);
var import_dist915 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/defaults/index.js
var import_dist904 = __toESM(require_dist(), 1);
var import_dist905 = __toESM(require_dist2(), 1);
var import_dist906 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/defaults/transitional.js
var import_dist877 = __toESM(require_dist(), 1);
var import_dist878 = __toESM(require_dist2(), 1);
var import_dist879 = __toESM(require_dist3(), 1);
var transitional_default = {
  silentJSONParsing: true,
  forcedJSONParsing: true,
  clarifyTimeoutError: false
};

// ../../node_modules/axios/lib/helpers/toURLEncodedForm.js
var import_dist898 = __toESM(require_dist(), 1);
var import_dist899 = __toESM(require_dist2(), 1);
var import_dist900 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/platform/index.js
var import_dist895 = __toESM(require_dist(), 1);
var import_dist896 = __toESM(require_dist2(), 1);
var import_dist897 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/platform/browser/index.js
var import_dist889 = __toESM(require_dist(), 1);
var import_dist890 = __toESM(require_dist2(), 1);
var import_dist891 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/platform/browser/classes/URLSearchParams.js
var import_dist880 = __toESM(require_dist(), 1);
var import_dist881 = __toESM(require_dist2(), 1);
var import_dist882 = __toESM(require_dist3(), 1);
var URLSearchParams_default = typeof URLSearchParams !== "undefined" ? URLSearchParams : AxiosURLSearchParams_default;

// ../../node_modules/axios/lib/platform/browser/classes/FormData.js
var import_dist883 = __toESM(require_dist(), 1);
var import_dist884 = __toESM(require_dist2(), 1);
var import_dist885 = __toESM(require_dist3(), 1);
var FormData_default = typeof FormData !== "undefined" ? FormData : null;

// ../../node_modules/axios/lib/platform/browser/classes/Blob.js
var import_dist886 = __toESM(require_dist(), 1);
var import_dist887 = __toESM(require_dist2(), 1);
var import_dist888 = __toESM(require_dist3(), 1);
var Blob_default = typeof Blob !== "undefined" ? Blob : null;

// ../../node_modules/axios/lib/platform/browser/index.js
var browser_default = {
  isBrowser: true,
  classes: {
    URLSearchParams: URLSearchParams_default,
    FormData: FormData_default,
    Blob: Blob_default
  },
  protocols: ["http", "https", "file", "blob", "url", "data"]
};

// ../../node_modules/axios/lib/platform/common/utils.js
var utils_exports = {};
__export(utils_exports, {
  hasBrowserEnv: () => hasBrowserEnv,
  hasStandardBrowserEnv: () => hasStandardBrowserEnv,
  hasStandardBrowserWebWorkerEnv: () => hasStandardBrowserWebWorkerEnv,
  navigator: () => _navigator,
  origin: () => origin
});
var import_dist892 = __toESM(require_dist(), 1);
var import_dist893 = __toESM(require_dist2(), 1);
var import_dist894 = __toESM(require_dist3(), 1);
var hasBrowserEnv = typeof window !== "undefined" && typeof document !== "undefined";
var _navigator = typeof navigator === "object" && navigator || void 0;
var hasStandardBrowserEnv = hasBrowserEnv && (!_navigator || ["ReactNative", "NativeScript", "NS"].indexOf(_navigator.product) < 0);
var hasStandardBrowserWebWorkerEnv = (() => {
  return typeof WorkerGlobalScope !== "undefined" && // eslint-disable-next-line no-undef
  self instanceof WorkerGlobalScope && typeof self.importScripts === "function";
})();
var origin = hasBrowserEnv && window.location.href || "http://localhost";

// ../../node_modules/axios/lib/platform/index.js
var platform_default = {
  ...utils_exports,
  ...browser_default
};

// ../../node_modules/axios/lib/helpers/toURLEncodedForm.js
function toURLEncodedForm(data, options) {
  return toFormData_default(data, new platform_default.classes.URLSearchParams(), {
    visitor: function(value, key, path, helpers) {
      if (platform_default.isNode && utils_default.isBuffer(value)) {
        this.append(key, value.toString("base64"));
        return false;
      }
      return helpers.defaultVisitor.apply(this, arguments);
    },
    ...options
  });
}

// ../../node_modules/axios/lib/helpers/formDataToJSON.js
var import_dist901 = __toESM(require_dist(), 1);
var import_dist902 = __toESM(require_dist2(), 1);
var import_dist903 = __toESM(require_dist3(), 1);
function parsePropPath(name) {
  return utils_default.matchAll(/\w+|\[(\w*)]/g, name).map((match) => {
    return match[0] === "[]" ? "" : match[1] || match[0];
  });
}
function arrayToObject(arr) {
  const obj = {};
  const keys = Object.keys(arr);
  let i;
  const len = keys.length;
  let key;
  for (i = 0; i < len; i++) {
    key = keys[i];
    obj[key] = arr[key];
  }
  return obj;
}
function formDataToJSON(formData) {
  function buildPath(path, value, target, index) {
    let name = path[index++];
    if (name === "__proto__") return true;
    const isNumericKey = Number.isFinite(+name);
    const isLast = index >= path.length;
    name = !name && utils_default.isArray(target) ? target.length : name;
    if (isLast) {
      if (utils_default.hasOwnProp(target, name)) {
        target[name] = [target[name], value];
      } else {
        target[name] = value;
      }
      return !isNumericKey;
    }
    if (!target[name] || !utils_default.isObject(target[name])) {
      target[name] = [];
    }
    const result = buildPath(path, value, target[name], index);
    if (result && utils_default.isArray(target[name])) {
      target[name] = arrayToObject(target[name]);
    }
    return !isNumericKey;
  }
  if (utils_default.isFormData(formData) && utils_default.isFunction(formData.entries)) {
    const obj = {};
    utils_default.forEachEntry(formData, (name, value) => {
      buildPath(parsePropPath(name), value, obj, 0);
    });
    return obj;
  }
  return null;
}
var formDataToJSON_default = formDataToJSON;

// ../../node_modules/axios/lib/defaults/index.js
function stringifySafely(rawValue, parser, encoder) {
  if (utils_default.isString(rawValue)) {
    try {
      (parser || JSON.parse)(rawValue);
      return utils_default.trim(rawValue);
    } catch (e) {
      if (e.name !== "SyntaxError") {
        throw e;
      }
    }
  }
  return (encoder || JSON.stringify)(rawValue);
}
var defaults = {
  transitional: transitional_default,
  adapter: ["xhr", "http", "fetch"],
  transformRequest: [function transformRequest(data, headers) {
    const contentType = headers.getContentType() || "";
    const hasJSONContentType = contentType.indexOf("application/json") > -1;
    const isObjectPayload = utils_default.isObject(data);
    if (isObjectPayload && utils_default.isHTMLForm(data)) {
      data = new FormData(data);
    }
    const isFormData2 = utils_default.isFormData(data);
    if (isFormData2) {
      return hasJSONContentType ? JSON.stringify(formDataToJSON_default(data)) : data;
    }
    if (utils_default.isArrayBuffer(data) || utils_default.isBuffer(data) || utils_default.isStream(data) || utils_default.isFile(data) || utils_default.isBlob(data) || utils_default.isReadableStream(data)) {
      return data;
    }
    if (utils_default.isArrayBufferView(data)) {
      return data.buffer;
    }
    if (utils_default.isURLSearchParams(data)) {
      headers.setContentType("application/x-www-form-urlencoded;charset=utf-8", false);
      return data.toString();
    }
    let isFileList2;
    if (isObjectPayload) {
      if (contentType.indexOf("application/x-www-form-urlencoded") > -1) {
        return toURLEncodedForm(data, this.formSerializer).toString();
      }
      if ((isFileList2 = utils_default.isFileList(data)) || contentType.indexOf("multipart/form-data") > -1) {
        const _FormData = this.env && this.env.FormData;
        return toFormData_default(
          isFileList2 ? { "files[]": data } : data,
          _FormData && new _FormData(),
          this.formSerializer
        );
      }
    }
    if (isObjectPayload || hasJSONContentType) {
      headers.setContentType("application/json", false);
      return stringifySafely(data);
    }
    return data;
  }],
  transformResponse: [function transformResponse(data) {
    const transitional2 = this.transitional || defaults.transitional;
    const forcedJSONParsing = transitional2 && transitional2.forcedJSONParsing;
    const JSONRequested = this.responseType === "json";
    if (utils_default.isResponse(data) || utils_default.isReadableStream(data)) {
      return data;
    }
    if (data && utils_default.isString(data) && (forcedJSONParsing && !this.responseType || JSONRequested)) {
      const silentJSONParsing = transitional2 && transitional2.silentJSONParsing;
      const strictJSONParsing = !silentJSONParsing && JSONRequested;
      try {
        return JSON.parse(data, this.parseReviver);
      } catch (e) {
        if (strictJSONParsing) {
          if (e.name === "SyntaxError") {
            throw AxiosError_default.from(e, AxiosError_default.ERR_BAD_RESPONSE, this, null, this.response);
          }
          throw e;
        }
      }
    }
    return data;
  }],
  /**
   * A timeout in milliseconds to abort a request. If set to 0 (default) a
   * timeout is not created.
   */
  timeout: 0,
  xsrfCookieName: "XSRF-TOKEN",
  xsrfHeaderName: "X-XSRF-TOKEN",
  maxContentLength: -1,
  maxBodyLength: -1,
  env: {
    FormData: platform_default.classes.FormData,
    Blob: platform_default.classes.Blob
  },
  validateStatus: function validateStatus(status) {
    return status >= 200 && status < 300;
  },
  headers: {
    common: {
      "Accept": "application/json, text/plain, */*",
      "Content-Type": void 0
    }
  }
};
utils_default.forEach(["delete", "get", "head", "post", "put", "patch"], (method) => {
  defaults.headers[method] = {};
});
var defaults_default = defaults;

// ../../node_modules/axios/lib/core/AxiosHeaders.js
var import_dist910 = __toESM(require_dist(), 1);
var import_dist911 = __toESM(require_dist2(), 1);
var import_dist912 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/helpers/parseHeaders.js
var import_dist907 = __toESM(require_dist(), 1);
var import_dist908 = __toESM(require_dist2(), 1);
var import_dist909 = __toESM(require_dist3(), 1);
var ignoreDuplicateOf = utils_default.toObjectSet([
  "age",
  "authorization",
  "content-length",
  "content-type",
  "etag",
  "expires",
  "from",
  "host",
  "if-modified-since",
  "if-unmodified-since",
  "last-modified",
  "location",
  "max-forwards",
  "proxy-authorization",
  "referer",
  "retry-after",
  "user-agent"
]);
var parseHeaders_default = (rawHeaders) => {
  const parsed = {};
  let key;
  let val;
  let i;
  rawHeaders && rawHeaders.split("\n").forEach(function parser(line) {
    i = line.indexOf(":");
    key = line.substring(0, i).trim().toLowerCase();
    val = line.substring(i + 1).trim();
    if (!key || parsed[key] && ignoreDuplicateOf[key]) {
      return;
    }
    if (key === "set-cookie") {
      if (parsed[key]) {
        parsed[key].push(val);
      } else {
        parsed[key] = [val];
      }
    } else {
      parsed[key] = parsed[key] ? parsed[key] + ", " + val : val;
    }
  });
  return parsed;
};

// ../../node_modules/axios/lib/core/AxiosHeaders.js
var $internals = Symbol("internals");
function normalizeHeader(header) {
  return header && String(header).trim().toLowerCase();
}
function normalizeValue(value) {
  if (value === false || value == null) {
    return value;
  }
  return utils_default.isArray(value) ? value.map(normalizeValue) : String(value);
}
function parseTokens(str) {
  const tokens = /* @__PURE__ */ Object.create(null);
  const tokensRE = /([^\s,;=]+)\s*(?:=\s*([^,;]+))?/g;
  let match;
  while (match = tokensRE.exec(str)) {
    tokens[match[1]] = match[2];
  }
  return tokens;
}
var isValidHeaderName = (str) => /^[-_a-zA-Z0-9^`|~,!#$%&'*+.]+$/.test(str.trim());
function matchHeaderValue(context, value, header, filter2, isHeaderNameFilter) {
  if (utils_default.isFunction(filter2)) {
    return filter2.call(this, value, header);
  }
  if (isHeaderNameFilter) {
    value = header;
  }
  if (!utils_default.isString(value)) return;
  if (utils_default.isString(filter2)) {
    return value.indexOf(filter2) !== -1;
  }
  if (utils_default.isRegExp(filter2)) {
    return filter2.test(value);
  }
}
function formatHeader(header) {
  return header.trim().toLowerCase().replace(/([a-z\d])(\w*)/g, (w, char, str) => {
    return char.toUpperCase() + str;
  });
}
function buildAccessors(obj, header) {
  const accessorName = utils_default.toCamelCase(" " + header);
  ["get", "set", "has"].forEach((methodName) => {
    Object.defineProperty(obj, methodName + accessorName, {
      value: function(arg1, arg2, arg3) {
        return this[methodName].call(this, header, arg1, arg2, arg3);
      },
      configurable: true
    });
  });
}
var AxiosHeaders = class {
  constructor(headers) {
    headers && this.set(headers);
  }
  set(header, valueOrRewrite, rewrite) {
    const self2 = this;
    function setHeader(_value, _header, _rewrite) {
      const lHeader = normalizeHeader(_header);
      if (!lHeader) {
        throw new Error("header name must be a non-empty string");
      }
      const key = utils_default.findKey(self2, lHeader);
      if (!key || self2[key] === void 0 || _rewrite === true || _rewrite === void 0 && self2[key] !== false) {
        self2[key || _header] = normalizeValue(_value);
      }
    }
    const setHeaders = (headers, _rewrite) => utils_default.forEach(headers, (_value, _header) => setHeader(_value, _header, _rewrite));
    if (utils_default.isPlainObject(header) || header instanceof this.constructor) {
      setHeaders(header, valueOrRewrite);
    } else if (utils_default.isString(header) && (header = header.trim()) && !isValidHeaderName(header)) {
      setHeaders(parseHeaders_default(header), valueOrRewrite);
    } else if (utils_default.isObject(header) && utils_default.isIterable(header)) {
      let obj = {}, dest, key;
      for (const entry of header) {
        if (!utils_default.isArray(entry)) {
          throw TypeError("Object iterator must return a key-value pair");
        }
        obj[key = entry[0]] = (dest = obj[key]) ? utils_default.isArray(dest) ? [...dest, entry[1]] : [dest, entry[1]] : entry[1];
      }
      setHeaders(obj, valueOrRewrite);
    } else {
      header != null && setHeader(valueOrRewrite, header, rewrite);
    }
    return this;
  }
  get(header, parser) {
    header = normalizeHeader(header);
    if (header) {
      const key = utils_default.findKey(this, header);
      if (key) {
        const value = this[key];
        if (!parser) {
          return value;
        }
        if (parser === true) {
          return parseTokens(value);
        }
        if (utils_default.isFunction(parser)) {
          return parser.call(this, value, key);
        }
        if (utils_default.isRegExp(parser)) {
          return parser.exec(value);
        }
        throw new TypeError("parser must be boolean|regexp|function");
      }
    }
  }
  has(header, matcher) {
    header = normalizeHeader(header);
    if (header) {
      const key = utils_default.findKey(this, header);
      return !!(key && this[key] !== void 0 && (!matcher || matchHeaderValue(this, this[key], key, matcher)));
    }
    return false;
  }
  delete(header, matcher) {
    const self2 = this;
    let deleted = false;
    function deleteHeader(_header) {
      _header = normalizeHeader(_header);
      if (_header) {
        const key = utils_default.findKey(self2, _header);
        if (key && (!matcher || matchHeaderValue(self2, self2[key], key, matcher))) {
          delete self2[key];
          deleted = true;
        }
      }
    }
    if (utils_default.isArray(header)) {
      header.forEach(deleteHeader);
    } else {
      deleteHeader(header);
    }
    return deleted;
  }
  clear(matcher) {
    const keys = Object.keys(this);
    let i = keys.length;
    let deleted = false;
    while (i--) {
      const key = keys[i];
      if (!matcher || matchHeaderValue(this, this[key], key, matcher, true)) {
        delete this[key];
        deleted = true;
      }
    }
    return deleted;
  }
  normalize(format) {
    const self2 = this;
    const headers = {};
    utils_default.forEach(this, (value, header) => {
      const key = utils_default.findKey(headers, header);
      if (key) {
        self2[key] = normalizeValue(value);
        delete self2[header];
        return;
      }
      const normalized = format ? formatHeader(header) : String(header).trim();
      if (normalized !== header) {
        delete self2[header];
      }
      self2[normalized] = normalizeValue(value);
      headers[normalized] = true;
    });
    return this;
  }
  concat(...targets) {
    return this.constructor.concat(this, ...targets);
  }
  toJSON(asStrings) {
    const obj = /* @__PURE__ */ Object.create(null);
    utils_default.forEach(this, (value, header) => {
      value != null && value !== false && (obj[header] = asStrings && utils_default.isArray(value) ? value.join(", ") : value);
    });
    return obj;
  }
  [Symbol.iterator]() {
    return Object.entries(this.toJSON())[Symbol.iterator]();
  }
  toString() {
    return Object.entries(this.toJSON()).map(([header, value]) => header + ": " + value).join("\n");
  }
  getSetCookie() {
    return this.get("set-cookie") || [];
  }
  get [Symbol.toStringTag]() {
    return "AxiosHeaders";
  }
  static from(thing) {
    return thing instanceof this ? thing : new this(thing);
  }
  static concat(first, ...targets) {
    const computed = new this(first);
    targets.forEach((target) => computed.set(target));
    return computed;
  }
  static accessor(header) {
    const internals = this[$internals] = this[$internals] = {
      accessors: {}
    };
    const accessors = internals.accessors;
    const prototype2 = this.prototype;
    function defineAccessor(_header) {
      const lHeader = normalizeHeader(_header);
      if (!accessors[lHeader]) {
        buildAccessors(prototype2, _header);
        accessors[lHeader] = true;
      }
    }
    utils_default.isArray(header) ? header.forEach(defineAccessor) : defineAccessor(header);
    return this;
  }
};
AxiosHeaders.accessor(["Content-Type", "Content-Length", "Accept", "Accept-Encoding", "User-Agent", "Authorization"]);
utils_default.reduceDescriptors(AxiosHeaders.prototype, ({ value }, key) => {
  let mapped = key[0].toUpperCase() + key.slice(1);
  return {
    get: () => value,
    set(headerValue) {
      this[mapped] = headerValue;
    }
  };
});
utils_default.freezeMethods(AxiosHeaders);
var AxiosHeaders_default = AxiosHeaders;

// ../../node_modules/axios/lib/core/transformData.js
function transformData(fns, response) {
  const config = this || defaults_default;
  const context = response || config;
  const headers = AxiosHeaders_default.from(context.headers);
  let data = context.data;
  utils_default.forEach(fns, function transform(fn) {
    data = fn.call(config, data, headers.normalize(), response ? response.status : void 0);
  });
  headers.normalize();
  return data;
}

// ../../node_modules/axios/lib/cancel/isCancel.js
var import_dist916 = __toESM(require_dist(), 1);
var import_dist917 = __toESM(require_dist2(), 1);
var import_dist918 = __toESM(require_dist3(), 1);
function isCancel(value) {
  return !!(value && value.__CANCEL__);
}

// ../../node_modules/axios/lib/cancel/CanceledError.js
var import_dist919 = __toESM(require_dist(), 1);
var import_dist920 = __toESM(require_dist2(), 1);
var import_dist921 = __toESM(require_dist3(), 1);
var CanceledError = class extends AxiosError_default {
  /**
   * A `CanceledError` is an object that is thrown when an operation is canceled.
   *
   * @param {string=} message The message.
   * @param {Object=} config The config.
   * @param {Object=} request The request.
   *
   * @returns {CanceledError} The created error.
   */
  constructor(message, config, request2) {
    super(message == null ? "canceled" : message, AxiosError_default.ERR_CANCELED, config, request2);
    this.name = "CanceledError";
    this.__CANCEL__ = true;
  }
};
var CanceledError_default = CanceledError;

// ../../node_modules/axios/lib/adapters/adapters.js
var import_dist970 = __toESM(require_dist(), 1);
var import_dist971 = __toESM(require_dist2(), 1);
var import_dist972 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/adapters/xhr.js
var import_dist958 = __toESM(require_dist(), 1);
var import_dist959 = __toESM(require_dist2(), 1);
var import_dist960 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/core/settle.js
var import_dist922 = __toESM(require_dist(), 1);
var import_dist923 = __toESM(require_dist2(), 1);
var import_dist924 = __toESM(require_dist3(), 1);
function settle(resolve, reject, response) {
  const validateStatus2 = response.config.validateStatus;
  if (!response.status || !validateStatus2 || validateStatus2(response.status)) {
    resolve(response);
  } else {
    reject(new AxiosError_default(
      "Request failed with status code " + response.status,
      [AxiosError_default.ERR_BAD_REQUEST, AxiosError_default.ERR_BAD_RESPONSE][Math.floor(response.status / 100) - 4],
      response.config,
      response.request,
      response
    ));
  }
}

// ../../node_modules/axios/lib/helpers/parseProtocol.js
var import_dist925 = __toESM(require_dist(), 1);
var import_dist926 = __toESM(require_dist2(), 1);
var import_dist927 = __toESM(require_dist3(), 1);
function parseProtocol(url) {
  const match = /^([-+\w]{1,25})(:?\/\/|:)/.exec(url);
  return match && match[1] || "";
}

// ../../node_modules/axios/lib/helpers/progressEventReducer.js
var import_dist934 = __toESM(require_dist(), 1);
var import_dist935 = __toESM(require_dist2(), 1);
var import_dist936 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/helpers/speedometer.js
var import_dist928 = __toESM(require_dist(), 1);
var import_dist929 = __toESM(require_dist2(), 1);
var import_dist930 = __toESM(require_dist3(), 1);
function speedometer(samplesCount, min) {
  samplesCount = samplesCount || 10;
  const bytes = new Array(samplesCount);
  const timestamps = new Array(samplesCount);
  let head = 0;
  let tail = 0;
  let firstSampleTS;
  min = min !== void 0 ? min : 1e3;
  return function push(chunkLength) {
    const now = Date.now();
    const startedAt = timestamps[tail];
    if (!firstSampleTS) {
      firstSampleTS = now;
    }
    bytes[head] = chunkLength;
    timestamps[head] = now;
    let i = tail;
    let bytesCount = 0;
    while (i !== head) {
      bytesCount += bytes[i++];
      i = i % samplesCount;
    }
    head = (head + 1) % samplesCount;
    if (head === tail) {
      tail = (tail + 1) % samplesCount;
    }
    if (now - firstSampleTS < min) {
      return;
    }
    const passed = startedAt && now - startedAt;
    return passed ? Math.round(bytesCount * 1e3 / passed) : void 0;
  };
}
var speedometer_default = speedometer;

// ../../node_modules/axios/lib/helpers/throttle.js
var import_dist931 = __toESM(require_dist(), 1);
var import_dist932 = __toESM(require_dist2(), 1);
var import_dist933 = __toESM(require_dist3(), 1);
function throttle(fn, freq) {
  let timestamp = 0;
  let threshold = 1e3 / freq;
  let lastArgs;
  let timer;
  const invoke = (args, now = Date.now()) => {
    timestamp = now;
    lastArgs = null;
    if (timer) {
      clearTimeout(timer);
      timer = null;
    }
    fn(...args);
  };
  const throttled = (...args) => {
    const now = Date.now();
    const passed = now - timestamp;
    if (passed >= threshold) {
      invoke(args, now);
    } else {
      lastArgs = args;
      if (!timer) {
        timer = setTimeout(() => {
          timer = null;
          invoke(lastArgs);
        }, threshold - passed);
      }
    }
  };
  const flush = () => lastArgs && invoke(lastArgs);
  return [throttled, flush];
}
var throttle_default = throttle;

// ../../node_modules/axios/lib/helpers/progressEventReducer.js
var progressEventReducer = (listener, isDownloadStream, freq = 3) => {
  let bytesNotified = 0;
  const _speedometer = speedometer_default(50, 250);
  return throttle_default((e) => {
    const loaded = e.loaded;
    const total = e.lengthComputable ? e.total : void 0;
    const progressBytes = loaded - bytesNotified;
    const rate = _speedometer(progressBytes);
    const inRange = loaded <= total;
    bytesNotified = loaded;
    const data = {
      loaded,
      total,
      progress: total ? loaded / total : void 0,
      bytes: progressBytes,
      rate: rate ? rate : void 0,
      estimated: rate && total && inRange ? (total - loaded) / rate : void 0,
      event: e,
      lengthComputable: total != null,
      [isDownloadStream ? "download" : "upload"]: true
    };
    listener(data);
  }, freq);
};
var progressEventDecorator = (total, throttled) => {
  const lengthComputable = total != null;
  return [(loaded) => throttled[0]({
    lengthComputable,
    total,
    loaded
  }), throttled[1]];
};
var asyncDecorator = (fn) => (...args) => utils_default.asap(() => fn(...args));

// ../../node_modules/axios/lib/helpers/resolveConfig.js
var import_dist955 = __toESM(require_dist(), 1);
var import_dist956 = __toESM(require_dist2(), 1);
var import_dist957 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/helpers/isURLSameOrigin.js
var import_dist937 = __toESM(require_dist(), 1);
var import_dist938 = __toESM(require_dist2(), 1);
var import_dist939 = __toESM(require_dist3(), 1);
var isURLSameOrigin_default = platform_default.hasStandardBrowserEnv ? /* @__PURE__ */ ((origin2, isMSIE) => (url) => {
  url = new URL(url, platform_default.origin);
  return origin2.protocol === url.protocol && origin2.host === url.host && (isMSIE || origin2.port === url.port);
})(
  new URL(platform_default.origin),
  platform_default.navigator && /(msie|trident)/i.test(platform_default.navigator.userAgent)
) : () => true;

// ../../node_modules/axios/lib/helpers/cookies.js
var import_dist940 = __toESM(require_dist(), 1);
var import_dist941 = __toESM(require_dist2(), 1);
var import_dist942 = __toESM(require_dist3(), 1);
var cookies_default = platform_default.hasStandardBrowserEnv ? (
  // Standard browser envs support document.cookie
  {
    write(name, value, expires, path, domain, secure, sameSite) {
      if (typeof document === "undefined") return;
      const cookie = [`${name}=${encodeURIComponent(value)}`];
      if (utils_default.isNumber(expires)) {
        cookie.push(`expires=${new Date(expires).toUTCString()}`);
      }
      if (utils_default.isString(path)) {
        cookie.push(`path=${path}`);
      }
      if (utils_default.isString(domain)) {
        cookie.push(`domain=${domain}`);
      }
      if (secure === true) {
        cookie.push("secure");
      }
      if (utils_default.isString(sameSite)) {
        cookie.push(`SameSite=${sameSite}`);
      }
      document.cookie = cookie.join("; ");
    },
    read(name) {
      if (typeof document === "undefined") return null;
      const match = document.cookie.match(new RegExp("(?:^|; )" + name + "=([^;]*)"));
      return match ? decodeURIComponent(match[1]) : null;
    },
    remove(name) {
      this.write(name, "", Date.now() - 864e5, "/");
    }
  }
) : (
  // Non-standard browser env (web workers, react-native) lack needed support.
  {
    write() {
    },
    read() {
      return null;
    },
    remove() {
    }
  }
);

// ../../node_modules/axios/lib/core/buildFullPath.js
var import_dist949 = __toESM(require_dist(), 1);
var import_dist950 = __toESM(require_dist2(), 1);
var import_dist951 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/helpers/isAbsoluteURL.js
var import_dist943 = __toESM(require_dist(), 1);
var import_dist944 = __toESM(require_dist2(), 1);
var import_dist945 = __toESM(require_dist3(), 1);
function isAbsoluteURL(url) {
  return /^([a-z][a-z\d+\-.]*:)?\/\//i.test(url);
}

// ../../node_modules/axios/lib/helpers/combineURLs.js
var import_dist946 = __toESM(require_dist(), 1);
var import_dist947 = __toESM(require_dist2(), 1);
var import_dist948 = __toESM(require_dist3(), 1);
function combineURLs(baseURL, relativeURL) {
  return relativeURL ? baseURL.replace(/\/?\/$/, "") + "/" + relativeURL.replace(/^\/+/, "") : baseURL;
}

// ../../node_modules/axios/lib/core/buildFullPath.js
function buildFullPath(baseURL, requestedURL, allowAbsoluteUrls) {
  let isRelativeUrl = !isAbsoluteURL(requestedURL);
  if (baseURL && (isRelativeUrl || allowAbsoluteUrls == false)) {
    return combineURLs(baseURL, requestedURL);
  }
  return requestedURL;
}

// ../../node_modules/axios/lib/core/mergeConfig.js
var import_dist952 = __toESM(require_dist(), 1);
var import_dist953 = __toESM(require_dist2(), 1);
var import_dist954 = __toESM(require_dist3(), 1);
var headersToObject = (thing) => thing instanceof AxiosHeaders_default ? { ...thing } : thing;
function mergeConfig(config1, config2) {
  config2 = config2 || {};
  const config = {};
  function getMergedValue(target, source, prop, caseless) {
    if (utils_default.isPlainObject(target) && utils_default.isPlainObject(source)) {
      return utils_default.merge.call({ caseless }, target, source);
    } else if (utils_default.isPlainObject(source)) {
      return utils_default.merge({}, source);
    } else if (utils_default.isArray(source)) {
      return source.slice();
    }
    return source;
  }
  function mergeDeepProperties(a, b, prop, caseless) {
    if (!utils_default.isUndefined(b)) {
      return getMergedValue(a, b, prop, caseless);
    } else if (!utils_default.isUndefined(a)) {
      return getMergedValue(void 0, a, prop, caseless);
    }
  }
  function valueFromConfig2(a, b) {
    if (!utils_default.isUndefined(b)) {
      return getMergedValue(void 0, b);
    }
  }
  function defaultToConfig2(a, b) {
    if (!utils_default.isUndefined(b)) {
      return getMergedValue(void 0, b);
    } else if (!utils_default.isUndefined(a)) {
      return getMergedValue(void 0, a);
    }
  }
  function mergeDirectKeys(a, b, prop) {
    if (prop in config2) {
      return getMergedValue(a, b);
    } else if (prop in config1) {
      return getMergedValue(void 0, a);
    }
  }
  const mergeMap = {
    url: valueFromConfig2,
    method: valueFromConfig2,
    data: valueFromConfig2,
    baseURL: defaultToConfig2,
    transformRequest: defaultToConfig2,
    transformResponse: defaultToConfig2,
    paramsSerializer: defaultToConfig2,
    timeout: defaultToConfig2,
    timeoutMessage: defaultToConfig2,
    withCredentials: defaultToConfig2,
    withXSRFToken: defaultToConfig2,
    adapter: defaultToConfig2,
    responseType: defaultToConfig2,
    xsrfCookieName: defaultToConfig2,
    xsrfHeaderName: defaultToConfig2,
    onUploadProgress: defaultToConfig2,
    onDownloadProgress: defaultToConfig2,
    decompress: defaultToConfig2,
    maxContentLength: defaultToConfig2,
    maxBodyLength: defaultToConfig2,
    beforeRedirect: defaultToConfig2,
    transport: defaultToConfig2,
    httpAgent: defaultToConfig2,
    httpsAgent: defaultToConfig2,
    cancelToken: defaultToConfig2,
    socketPath: defaultToConfig2,
    responseEncoding: defaultToConfig2,
    validateStatus: mergeDirectKeys,
    headers: (a, b, prop) => mergeDeepProperties(headersToObject(a), headersToObject(b), prop, true)
  };
  utils_default.forEach(Object.keys({ ...config1, ...config2 }), function computeConfigValue(prop) {
    const merge2 = mergeMap[prop] || mergeDeepProperties;
    const configValue = merge2(config1[prop], config2[prop], prop);
    utils_default.isUndefined(configValue) && merge2 !== mergeDirectKeys || (config[prop] = configValue);
  });
  return config;
}

// ../../node_modules/axios/lib/helpers/resolveConfig.js
var resolveConfig_default = (config) => {
  const newConfig = mergeConfig({}, config);
  let { data, withXSRFToken, xsrfHeaderName, xsrfCookieName, headers, auth } = newConfig;
  newConfig.headers = headers = AxiosHeaders_default.from(headers);
  newConfig.url = buildURL(buildFullPath(newConfig.baseURL, newConfig.url, newConfig.allowAbsoluteUrls), config.params, config.paramsSerializer);
  if (auth) {
    headers.set(
      "Authorization",
      "Basic " + btoa((auth.username || "") + ":" + (auth.password ? unescape(encodeURIComponent(auth.password)) : ""))
    );
  }
  if (utils_default.isFormData(data)) {
    if (platform_default.hasStandardBrowserEnv || platform_default.hasStandardBrowserWebWorkerEnv) {
      headers.setContentType(void 0);
    } else if (utils_default.isFunction(data.getHeaders)) {
      const formHeaders = data.getHeaders();
      const allowedHeaders = ["content-type", "content-length"];
      Object.entries(formHeaders).forEach(([key, val]) => {
        if (allowedHeaders.includes(key.toLowerCase())) {
          headers.set(key, val);
        }
      });
    }
  }
  if (platform_default.hasStandardBrowserEnv) {
    withXSRFToken && utils_default.isFunction(withXSRFToken) && (withXSRFToken = withXSRFToken(newConfig));
    if (withXSRFToken || withXSRFToken !== false && isURLSameOrigin_default(newConfig.url)) {
      const xsrfValue = xsrfHeaderName && xsrfCookieName && cookies_default.read(xsrfCookieName);
      if (xsrfValue) {
        headers.set(xsrfHeaderName, xsrfValue);
      }
    }
  }
  return newConfig;
};

// ../../node_modules/axios/lib/adapters/xhr.js
var isXHRAdapterSupported = typeof XMLHttpRequest !== "undefined";
var xhr_default = isXHRAdapterSupported && function(config) {
  return new Promise(function dispatchXhrRequest(resolve, reject) {
    const _config = resolveConfig_default(config);
    let requestData = _config.data;
    const requestHeaders = AxiosHeaders_default.from(_config.headers).normalize();
    let { responseType, onUploadProgress, onDownloadProgress } = _config;
    let onCanceled;
    let uploadThrottled, downloadThrottled;
    let flushUpload, flushDownload;
    function done() {
      flushUpload && flushUpload();
      flushDownload && flushDownload();
      _config.cancelToken && _config.cancelToken.unsubscribe(onCanceled);
      _config.signal && _config.signal.removeEventListener("abort", onCanceled);
    }
    let request2 = new XMLHttpRequest();
    request2.open(_config.method.toUpperCase(), _config.url, true);
    request2.timeout = _config.timeout;
    function onloadend() {
      if (!request2) {
        return;
      }
      const responseHeaders = AxiosHeaders_default.from(
        "getAllResponseHeaders" in request2 && request2.getAllResponseHeaders()
      );
      const responseData = !responseType || responseType === "text" || responseType === "json" ? request2.responseText : request2.response;
      const response = {
        data: responseData,
        status: request2.status,
        statusText: request2.statusText,
        headers: responseHeaders,
        config,
        request: request2
      };
      settle(function _resolve(value) {
        resolve(value);
        done();
      }, function _reject(err) {
        reject(err);
        done();
      }, response);
      request2 = null;
    }
    if ("onloadend" in request2) {
      request2.onloadend = onloadend;
    } else {
      request2.onreadystatechange = function handleLoad() {
        if (!request2 || request2.readyState !== 4) {
          return;
        }
        if (request2.status === 0 && !(request2.responseURL && request2.responseURL.indexOf("file:") === 0)) {
          return;
        }
        setTimeout(onloadend);
      };
    }
    request2.onabort = function handleAbort() {
      if (!request2) {
        return;
      }
      reject(new AxiosError_default("Request aborted", AxiosError_default.ECONNABORTED, config, request2));
      request2 = null;
    };
    request2.onerror = function handleError(event) {
      const msg = event && event.message ? event.message : "Network Error";
      const err = new AxiosError_default(msg, AxiosError_default.ERR_NETWORK, config, request2);
      err.event = event || null;
      reject(err);
      request2 = null;
    };
    request2.ontimeout = function handleTimeout() {
      let timeoutErrorMessage = _config.timeout ? "timeout of " + _config.timeout + "ms exceeded" : "timeout exceeded";
      const transitional2 = _config.transitional || transitional_default;
      if (_config.timeoutErrorMessage) {
        timeoutErrorMessage = _config.timeoutErrorMessage;
      }
      reject(new AxiosError_default(
        timeoutErrorMessage,
        transitional2.clarifyTimeoutError ? AxiosError_default.ETIMEDOUT : AxiosError_default.ECONNABORTED,
        config,
        request2
      ));
      request2 = null;
    };
    requestData === void 0 && requestHeaders.setContentType(null);
    if ("setRequestHeader" in request2) {
      utils_default.forEach(requestHeaders.toJSON(), function setRequestHeader(val, key) {
        request2.setRequestHeader(key, val);
      });
    }
    if (!utils_default.isUndefined(_config.withCredentials)) {
      request2.withCredentials = !!_config.withCredentials;
    }
    if (responseType && responseType !== "json") {
      request2.responseType = _config.responseType;
    }
    if (onDownloadProgress) {
      [downloadThrottled, flushDownload] = progressEventReducer(onDownloadProgress, true);
      request2.addEventListener("progress", downloadThrottled);
    }
    if (onUploadProgress && request2.upload) {
      [uploadThrottled, flushUpload] = progressEventReducer(onUploadProgress);
      request2.upload.addEventListener("progress", uploadThrottled);
      request2.upload.addEventListener("loadend", flushUpload);
    }
    if (_config.cancelToken || _config.signal) {
      onCanceled = (cancel) => {
        if (!request2) {
          return;
        }
        reject(!cancel || cancel.type ? new CanceledError_default(null, config, request2) : cancel);
        request2.abort();
        request2 = null;
      };
      _config.cancelToken && _config.cancelToken.subscribe(onCanceled);
      if (_config.signal) {
        _config.signal.aborted ? onCanceled() : _config.signal.addEventListener("abort", onCanceled);
      }
    }
    const protocol = parseProtocol(_config.url);
    if (protocol && platform_default.protocols.indexOf(protocol) === -1) {
      reject(new AxiosError_default("Unsupported protocol " + protocol + ":", AxiosError_default.ERR_BAD_REQUEST, config));
      return;
    }
    request2.send(requestData || null);
  });
};

// ../../node_modules/axios/lib/adapters/fetch.js
var import_dist967 = __toESM(require_dist(), 1);
var import_dist968 = __toESM(require_dist2(), 1);
var import_dist969 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/helpers/composeSignals.js
var import_dist961 = __toESM(require_dist(), 1);
var import_dist962 = __toESM(require_dist2(), 1);
var import_dist963 = __toESM(require_dist3(), 1);
var composeSignals = (signals, timeout) => {
  const { length } = signals = signals ? signals.filter(Boolean) : [];
  if (timeout || length) {
    let controller = new AbortController();
    let aborted;
    const onabort = function(reason) {
      if (!aborted) {
        aborted = true;
        unsubscribe();
        const err = reason instanceof Error ? reason : this.reason;
        controller.abort(err instanceof AxiosError_default ? err : new CanceledError_default(err instanceof Error ? err.message : err));
      }
    };
    let timer = timeout && setTimeout(() => {
      timer = null;
      onabort(new AxiosError_default(`timeout of ${timeout}ms exceeded`, AxiosError_default.ETIMEDOUT));
    }, timeout);
    const unsubscribe = () => {
      if (signals) {
        timer && clearTimeout(timer);
        timer = null;
        signals.forEach((signal2) => {
          signal2.unsubscribe ? signal2.unsubscribe(onabort) : signal2.removeEventListener("abort", onabort);
        });
        signals = null;
      }
    };
    signals.forEach((signal2) => signal2.addEventListener("abort", onabort));
    const { signal } = controller;
    signal.unsubscribe = () => utils_default.asap(unsubscribe);
    return signal;
  }
};
var composeSignals_default = composeSignals;

// ../../node_modules/axios/lib/helpers/trackStream.js
var import_dist964 = __toESM(require_dist(), 1);
var import_dist965 = __toESM(require_dist2(), 1);
var import_dist966 = __toESM(require_dist3(), 1);
var streamChunk = function* (chunk, chunkSize) {
  let len = chunk.byteLength;
  if (!chunkSize || len < chunkSize) {
    yield chunk;
    return;
  }
  let pos = 0;
  let end;
  while (pos < len) {
    end = pos + chunkSize;
    yield chunk.slice(pos, end);
    pos = end;
  }
};
var readBytes = async function* (iterable, chunkSize) {
  for await (const chunk of readStream(iterable)) {
    yield* streamChunk(chunk, chunkSize);
  }
};
var readStream = async function* (stream) {
  if (stream[Symbol.asyncIterator]) {
    yield* stream;
    return;
  }
  const reader = stream.getReader();
  try {
    for (; ; ) {
      const { done, value } = await reader.read();
      if (done) {
        break;
      }
      yield value;
    }
  } finally {
    await reader.cancel();
  }
};
var trackStream = (stream, chunkSize, onProgress, onFinish) => {
  const iterator2 = readBytes(stream, chunkSize);
  let bytes = 0;
  let done;
  let _onFinish = (e) => {
    if (!done) {
      done = true;
      onFinish && onFinish(e);
    }
  };
  return new ReadableStream({
    async pull(controller) {
      try {
        const { done: done2, value } = await iterator2.next();
        if (done2) {
          _onFinish();
          controller.close();
          return;
        }
        let len = value.byteLength;
        if (onProgress) {
          let loadedBytes = bytes += len;
          onProgress(loadedBytes);
        }
        controller.enqueue(new Uint8Array(value));
      } catch (err) {
        _onFinish(err);
        throw err;
      }
    },
    cancel(reason) {
      _onFinish(reason);
      return iterator2.return();
    }
  }, {
    highWaterMark: 2
  });
};

// ../../node_modules/axios/lib/adapters/fetch.js
var DEFAULT_CHUNK_SIZE = 64 * 1024;
var { isFunction: isFunction2 } = utils_default;
var globalFetchAPI = (({ Request: Request2, Response }) => ({
  Request: Request2,
  Response
}))(utils_default.global);
var {
  ReadableStream: ReadableStream2,
  TextEncoder: TextEncoder2
} = utils_default.global;
var test = (fn, ...args) => {
  try {
    return !!fn(...args);
  } catch (e) {
    return false;
  }
};
var factory = (env) => {
  env = utils_default.merge.call({
    skipUndefined: true
  }, globalFetchAPI, env);
  const { fetch: envFetch, Request: Request2, Response } = env;
  const isFetchSupported = envFetch ? isFunction2(envFetch) : typeof fetch === "function";
  const isRequestSupported = isFunction2(Request2);
  const isResponseSupported = isFunction2(Response);
  if (!isFetchSupported) {
    return false;
  }
  const isReadableStreamSupported = isFetchSupported && isFunction2(ReadableStream2);
  const encodeText = isFetchSupported && (typeof TextEncoder2 === "function" ? /* @__PURE__ */ ((encoder) => (str) => encoder.encode(str))(new TextEncoder2()) : async (str) => new Uint8Array(await new Request2(str).arrayBuffer()));
  const supportsRequestStream = isRequestSupported && isReadableStreamSupported && test(() => {
    let duplexAccessed = false;
    const hasContentType = new Request2(platform_default.origin, {
      body: new ReadableStream2(),
      method: "POST",
      get duplex() {
        duplexAccessed = true;
        return "half";
      }
    }).headers.has("Content-Type");
    return duplexAccessed && !hasContentType;
  });
  const supportsResponseStream = isResponseSupported && isReadableStreamSupported && test(() => utils_default.isReadableStream(new Response("").body));
  const resolvers = {
    stream: supportsResponseStream && ((res) => res.body)
  };
  isFetchSupported && (() => {
    ["text", "arrayBuffer", "blob", "formData", "stream"].forEach((type) => {
      !resolvers[type] && (resolvers[type] = (res, config) => {
        let method = res && res[type];
        if (method) {
          return method.call(res);
        }
        throw new AxiosError_default(`Response type '${type}' is not supported`, AxiosError_default.ERR_NOT_SUPPORT, config);
      });
    });
  })();
  const getBodyLength = async (body) => {
    if (body == null) {
      return 0;
    }
    if (utils_default.isBlob(body)) {
      return body.size;
    }
    if (utils_default.isSpecCompliantForm(body)) {
      const _request = new Request2(platform_default.origin, {
        method: "POST",
        body
      });
      return (await _request.arrayBuffer()).byteLength;
    }
    if (utils_default.isArrayBufferView(body) || utils_default.isArrayBuffer(body)) {
      return body.byteLength;
    }
    if (utils_default.isURLSearchParams(body)) {
      body = body + "";
    }
    if (utils_default.isString(body)) {
      return (await encodeText(body)).byteLength;
    }
  };
  const resolveBodyLength = async (headers, body) => {
    const length = utils_default.toFiniteNumber(headers.getContentLength());
    return length == null ? getBodyLength(body) : length;
  };
  return async (config) => {
    let {
      url,
      method,
      data,
      signal,
      cancelToken,
      timeout,
      onDownloadProgress,
      onUploadProgress,
      responseType,
      headers,
      withCredentials = "same-origin",
      fetchOptions
    } = resolveConfig_default(config);
    let _fetch = envFetch || fetch;
    responseType = responseType ? (responseType + "").toLowerCase() : "text";
    let composedSignal = composeSignals_default([signal, cancelToken && cancelToken.toAbortSignal()], timeout);
    let request2 = null;
    const unsubscribe = composedSignal && composedSignal.unsubscribe && (() => {
      composedSignal.unsubscribe();
    });
    let requestContentLength;
    try {
      if (onUploadProgress && supportsRequestStream && method !== "get" && method !== "head" && (requestContentLength = await resolveBodyLength(headers, data)) !== 0) {
        let _request = new Request2(url, {
          method: "POST",
          body: data,
          duplex: "half"
        });
        let contentTypeHeader;
        if (utils_default.isFormData(data) && (contentTypeHeader = _request.headers.get("content-type"))) {
          headers.setContentType(contentTypeHeader);
        }
        if (_request.body) {
          const [onProgress, flush] = progressEventDecorator(
            requestContentLength,
            progressEventReducer(asyncDecorator(onUploadProgress))
          );
          data = trackStream(_request.body, DEFAULT_CHUNK_SIZE, onProgress, flush);
        }
      }
      if (!utils_default.isString(withCredentials)) {
        withCredentials = withCredentials ? "include" : "omit";
      }
      const isCredentialsSupported = isRequestSupported && "credentials" in Request2.prototype;
      const resolvedOptions = {
        ...fetchOptions,
        signal: composedSignal,
        method: method.toUpperCase(),
        headers: headers.normalize().toJSON(),
        body: data,
        duplex: "half",
        credentials: isCredentialsSupported ? withCredentials : void 0
      };
      request2 = isRequestSupported && new Request2(url, resolvedOptions);
      let response = await (isRequestSupported ? _fetch(request2, fetchOptions) : _fetch(url, resolvedOptions));
      const isStreamResponse = supportsResponseStream && (responseType === "stream" || responseType === "response");
      if (supportsResponseStream && (onDownloadProgress || isStreamResponse && unsubscribe)) {
        const options = {};
        ["status", "statusText", "headers"].forEach((prop) => {
          options[prop] = response[prop];
        });
        const responseContentLength = utils_default.toFiniteNumber(response.headers.get("content-length"));
        const [onProgress, flush] = onDownloadProgress && progressEventDecorator(
          responseContentLength,
          progressEventReducer(asyncDecorator(onDownloadProgress), true)
        ) || [];
        response = new Response(
          trackStream(response.body, DEFAULT_CHUNK_SIZE, onProgress, () => {
            flush && flush();
            unsubscribe && unsubscribe();
          }),
          options
        );
      }
      responseType = responseType || "text";
      let responseData = await resolvers[utils_default.findKey(resolvers, responseType) || "text"](response, config);
      !isStreamResponse && unsubscribe && unsubscribe();
      return await new Promise((resolve, reject) => {
        settle(resolve, reject, {
          data: responseData,
          headers: AxiosHeaders_default.from(response.headers),
          status: response.status,
          statusText: response.statusText,
          config,
          request: request2
        });
      });
    } catch (err) {
      unsubscribe && unsubscribe();
      if (err && err.name === "TypeError" && /Load failed|fetch/i.test(err.message)) {
        throw Object.assign(
          new AxiosError_default("Network Error", AxiosError_default.ERR_NETWORK, config, request2),
          {
            cause: err.cause || err
          }
        );
      }
      throw AxiosError_default.from(err, err && err.code, config, request2);
    }
  };
};
var seedCache = /* @__PURE__ */ new Map();
var getFetch = (config) => {
  let env = config && config.env || {};
  const { fetch: fetch2, Request: Request2, Response } = env;
  const seeds = [
    Request2,
    Response,
    fetch2
  ];
  let len = seeds.length, i = len, seed, target, map = seedCache;
  while (i--) {
    seed = seeds[i];
    target = map.get(seed);
    target === void 0 && map.set(seed, target = i ? /* @__PURE__ */ new Map() : factory(env));
    map = target;
  }
  return target;
};
var adapter = getFetch();

// ../../node_modules/axios/lib/adapters/adapters.js
var knownAdapters = {
  http: null_default,
  xhr: xhr_default,
  fetch: {
    get: getFetch
  }
};
utils_default.forEach(knownAdapters, (fn, value) => {
  if (fn) {
    try {
      Object.defineProperty(fn, "name", { value });
    } catch (e) {
    }
    Object.defineProperty(fn, "adapterName", { value });
  }
});
var renderReason = (reason) => `- ${reason}`;
var isResolvedHandle = (adapter2) => utils_default.isFunction(adapter2) || adapter2 === null || adapter2 === false;
function getAdapter(adapters, config) {
  adapters = utils_default.isArray(adapters) ? adapters : [adapters];
  const { length } = adapters;
  let nameOrAdapter;
  let adapter2;
  const rejectedReasons = {};
  for (let i = 0; i < length; i++) {
    nameOrAdapter = adapters[i];
    let id;
    adapter2 = nameOrAdapter;
    if (!isResolvedHandle(nameOrAdapter)) {
      adapter2 = knownAdapters[(id = String(nameOrAdapter)).toLowerCase()];
      if (adapter2 === void 0) {
        throw new AxiosError_default(`Unknown adapter '${id}'`);
      }
    }
    if (adapter2 && (utils_default.isFunction(adapter2) || (adapter2 = adapter2.get(config)))) {
      break;
    }
    rejectedReasons[id || "#" + i] = adapter2;
  }
  if (!adapter2) {
    const reasons = Object.entries(rejectedReasons).map(
      ([id, state]) => `adapter ${id} ` + (state === false ? "is not supported by the environment" : "is not available in the build")
    );
    let s = length ? reasons.length > 1 ? "since :\n" + reasons.map(renderReason).join("\n") : " " + renderReason(reasons[0]) : "as no adapter specified";
    throw new AxiosError_default(
      `There is no suitable adapter to dispatch the request ` + s,
      "ERR_NOT_SUPPORT"
    );
  }
  return adapter2;
}
var adapters_default = {
  /**
   * Resolve an adapter from a list of adapter names or functions.
   * @type {Function}
   */
  getAdapter,
  /**
   * Exposes all known adapters
   * @type {Object<string, Function|Object>}
   */
  adapters: knownAdapters
};

// ../../node_modules/axios/lib/core/dispatchRequest.js
function throwIfCancellationRequested(config) {
  if (config.cancelToken) {
    config.cancelToken.throwIfRequested();
  }
  if (config.signal && config.signal.aborted) {
    throw new CanceledError_default(null, config);
  }
}
function dispatchRequest(config) {
  throwIfCancellationRequested(config);
  config.headers = AxiosHeaders_default.from(config.headers);
  config.data = transformData.call(
    config,
    config.transformRequest
  );
  if (["post", "put", "patch"].indexOf(config.method) !== -1) {
    config.headers.setContentType("application/x-www-form-urlencoded", false);
  }
  const adapter2 = adapters_default.getAdapter(config.adapter || defaults_default.adapter, config);
  return adapter2(config).then(function onAdapterResolution(response) {
    throwIfCancellationRequested(config);
    response.data = transformData.call(
      config,
      config.transformResponse,
      response
    );
    response.headers = AxiosHeaders_default.from(response.headers);
    return response;
  }, function onAdapterRejection(reason) {
    if (!isCancel(reason)) {
      throwIfCancellationRequested(config);
      if (reason && reason.response) {
        reason.response.data = transformData.call(
          config,
          config.transformResponse,
          reason.response
        );
        reason.response.headers = AxiosHeaders_default.from(reason.response.headers);
      }
    }
    return Promise.reject(reason);
  });
}

// ../../node_modules/axios/lib/helpers/validator.js
var import_dist979 = __toESM(require_dist(), 1);
var import_dist980 = __toESM(require_dist2(), 1);
var import_dist981 = __toESM(require_dist3(), 1);

// ../../node_modules/axios/lib/env/data.js
var import_dist976 = __toESM(require_dist(), 1);
var import_dist977 = __toESM(require_dist2(), 1);
var import_dist978 = __toESM(require_dist3(), 1);
var VERSION = "1.13.4";

// ../../node_modules/axios/lib/helpers/validator.js
var validators = {};
["object", "boolean", "number", "function", "string", "symbol"].forEach((type, i) => {
  validators[type] = function validator(thing) {
    return typeof thing === type || "a" + (i < 1 ? "n " : " ") + type;
  };
});
var deprecatedWarnings = {};
validators.transitional = function transitional(validator, version, message) {
  function formatMessage(opt, desc) {
    return "[Axios v" + VERSION + "] Transitional option '" + opt + "'" + desc + (message ? ". " + message : "");
  }
  return (value, opt, opts) => {
    if (validator === false) {
      throw new AxiosError_default(
        formatMessage(opt, " has been removed" + (version ? " in " + version : "")),
        AxiosError_default.ERR_DEPRECATED
      );
    }
    if (version && !deprecatedWarnings[opt]) {
      deprecatedWarnings[opt] = true;
      console.warn(
        formatMessage(
          opt,
          " has been deprecated since v" + version + " and will be removed in the near future"
        )
      );
    }
    return validator ? validator(value, opt, opts) : true;
  };
};
validators.spelling = function spelling(correctSpelling) {
  return (value, opt) => {
    console.warn(`${opt} is likely a misspelling of ${correctSpelling}`);
    return true;
  };
};
function assertOptions(options, schema, allowUnknown) {
  if (typeof options !== "object") {
    throw new AxiosError_default("options must be an object", AxiosError_default.ERR_BAD_OPTION_VALUE);
  }
  const keys = Object.keys(options);
  let i = keys.length;
  while (i-- > 0) {
    const opt = keys[i];
    const validator = schema[opt];
    if (validator) {
      const value = options[opt];
      const result = value === void 0 || validator(value, opt, options);
      if (result !== true) {
        throw new AxiosError_default("option " + opt + " must be " + result, AxiosError_default.ERR_BAD_OPTION_VALUE);
      }
      continue;
    }
    if (allowUnknown !== true) {
      throw new AxiosError_default("Unknown option " + opt, AxiosError_default.ERR_BAD_OPTION);
    }
  }
}
var validator_default = {
  assertOptions,
  validators
};

// ../../node_modules/axios/lib/core/Axios.js
var validators2 = validator_default.validators;
var Axios = class {
  constructor(instanceConfig) {
    this.defaults = instanceConfig || {};
    this.interceptors = {
      request: new InterceptorManager_default(),
      response: new InterceptorManager_default()
    };
  }
  /**
   * Dispatch a request
   *
   * @param {String|Object} configOrUrl The config specific for this request (merged with this.defaults)
   * @param {?Object} config
   *
   * @returns {Promise} The Promise to be fulfilled
   */
  async request(configOrUrl, config) {
    try {
      return await this._request(configOrUrl, config);
    } catch (err) {
      if (err instanceof Error) {
        let dummy = {};
        Error.captureStackTrace ? Error.captureStackTrace(dummy) : dummy = new Error();
        const stack = dummy.stack ? dummy.stack.replace(/^.+\n/, "") : "";
        try {
          if (!err.stack) {
            err.stack = stack;
          } else if (stack && !String(err.stack).endsWith(stack.replace(/^.+\n.+\n/, ""))) {
            err.stack += "\n" + stack;
          }
        } catch (e) {
        }
      }
      throw err;
    }
  }
  _request(configOrUrl, config) {
    if (typeof configOrUrl === "string") {
      config = config || {};
      config.url = configOrUrl;
    } else {
      config = configOrUrl || {};
    }
    config = mergeConfig(this.defaults, config);
    const { transitional: transitional2, paramsSerializer, headers } = config;
    if (transitional2 !== void 0) {
      validator_default.assertOptions(transitional2, {
        silentJSONParsing: validators2.transitional(validators2.boolean),
        forcedJSONParsing: validators2.transitional(validators2.boolean),
        clarifyTimeoutError: validators2.transitional(validators2.boolean)
      }, false);
    }
    if (paramsSerializer != null) {
      if (utils_default.isFunction(paramsSerializer)) {
        config.paramsSerializer = {
          serialize: paramsSerializer
        };
      } else {
        validator_default.assertOptions(paramsSerializer, {
          encode: validators2.function,
          serialize: validators2.function
        }, true);
      }
    }
    if (config.allowAbsoluteUrls !== void 0) {
    } else if (this.defaults.allowAbsoluteUrls !== void 0) {
      config.allowAbsoluteUrls = this.defaults.allowAbsoluteUrls;
    } else {
      config.allowAbsoluteUrls = true;
    }
    validator_default.assertOptions(config, {
      baseUrl: validators2.spelling("baseURL"),
      withXsrfToken: validators2.spelling("withXSRFToken")
    }, true);
    config.method = (config.method || this.defaults.method || "get").toLowerCase();
    let contextHeaders = headers && utils_default.merge(
      headers.common,
      headers[config.method]
    );
    headers && utils_default.forEach(
      ["delete", "get", "head", "post", "put", "patch", "common"],
      (method) => {
        delete headers[method];
      }
    );
    config.headers = AxiosHeaders_default.concat(contextHeaders, headers);
    const requestInterceptorChain = [];
    let synchronousRequestInterceptors = true;
    this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
      if (typeof interceptor.runWhen === "function" && interceptor.runWhen(config) === false) {
        return;
      }
      synchronousRequestInterceptors = synchronousRequestInterceptors && interceptor.synchronous;
      requestInterceptorChain.unshift(interceptor.fulfilled, interceptor.rejected);
    });
    const responseInterceptorChain = [];
    this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
      responseInterceptorChain.push(interceptor.fulfilled, interceptor.rejected);
    });
    let promise;
    let i = 0;
    let len;
    if (!synchronousRequestInterceptors) {
      const chain = [dispatchRequest.bind(this), void 0];
      chain.unshift(...requestInterceptorChain);
      chain.push(...responseInterceptorChain);
      len = chain.length;
      promise = Promise.resolve(config);
      while (i < len) {
        promise = promise.then(chain[i++], chain[i++]);
      }
      return promise;
    }
    len = requestInterceptorChain.length;
    let newConfig = config;
    while (i < len) {
      const onFulfilled = requestInterceptorChain[i++];
      const onRejected = requestInterceptorChain[i++];
      try {
        newConfig = onFulfilled(newConfig);
      } catch (error) {
        onRejected.call(this, error);
        break;
      }
    }
    try {
      promise = dispatchRequest.call(this, newConfig);
    } catch (error) {
      return Promise.reject(error);
    }
    i = 0;
    len = responseInterceptorChain.length;
    while (i < len) {
      promise = promise.then(responseInterceptorChain[i++], responseInterceptorChain[i++]);
    }
    return promise;
  }
  getUri(config) {
    config = mergeConfig(this.defaults, config);
    const fullPath = buildFullPath(config.baseURL, config.url, config.allowAbsoluteUrls);
    return buildURL(fullPath, config.params, config.paramsSerializer);
  }
};
utils_default.forEach(["delete", "get", "head", "options"], function forEachMethodNoData(method) {
  Axios.prototype[method] = function(url, config) {
    return this.request(mergeConfig(config || {}, {
      method,
      url,
      data: (config || {}).data
    }));
  };
});
utils_default.forEach(["post", "put", "patch"], function forEachMethodWithData(method) {
  function generateHTTPMethod(isForm) {
    return function httpMethod(url, data, config) {
      return this.request(mergeConfig(config || {}, {
        method,
        headers: isForm ? {
          "Content-Type": "multipart/form-data"
        } : {},
        url,
        data
      }));
    };
  }
  Axios.prototype[method] = generateHTTPMethod();
  Axios.prototype[method + "Form"] = generateHTTPMethod(true);
});
var Axios_default = Axios;

// ../../node_modules/axios/lib/cancel/CancelToken.js
var import_dist985 = __toESM(require_dist(), 1);
var import_dist986 = __toESM(require_dist2(), 1);
var import_dist987 = __toESM(require_dist3(), 1);
var CancelToken = class _CancelToken {
  constructor(executor) {
    if (typeof executor !== "function") {
      throw new TypeError("executor must be a function.");
    }
    let resolvePromise;
    this.promise = new Promise(function promiseExecutor(resolve) {
      resolvePromise = resolve;
    });
    const token = this;
    this.promise.then((cancel) => {
      if (!token._listeners) return;
      let i = token._listeners.length;
      while (i-- > 0) {
        token._listeners[i](cancel);
      }
      token._listeners = null;
    });
    this.promise.then = (onfulfilled) => {
      let _resolve;
      const promise = new Promise((resolve) => {
        token.subscribe(resolve);
        _resolve = resolve;
      }).then(onfulfilled);
      promise.cancel = function reject() {
        token.unsubscribe(_resolve);
      };
      return promise;
    };
    executor(function cancel(message, config, request2) {
      if (token.reason) {
        return;
      }
      token.reason = new CanceledError_default(message, config, request2);
      resolvePromise(token.reason);
    });
  }
  /**
   * Throws a `CanceledError` if cancellation has been requested.
   */
  throwIfRequested() {
    if (this.reason) {
      throw this.reason;
    }
  }
  /**
   * Subscribe to the cancel signal
   */
  subscribe(listener) {
    if (this.reason) {
      listener(this.reason);
      return;
    }
    if (this._listeners) {
      this._listeners.push(listener);
    } else {
      this._listeners = [listener];
    }
  }
  /**
   * Unsubscribe from the cancel signal
   */
  unsubscribe(listener) {
    if (!this._listeners) {
      return;
    }
    const index = this._listeners.indexOf(listener);
    if (index !== -1) {
      this._listeners.splice(index, 1);
    }
  }
  toAbortSignal() {
    const controller = new AbortController();
    const abort = (err) => {
      controller.abort(err);
    };
    this.subscribe(abort);
    controller.signal.unsubscribe = () => this.unsubscribe(abort);
    return controller.signal;
  }
  /**
   * Returns an object that contains a new `CancelToken` and a function that, when called,
   * cancels the `CancelToken`.
   */
  static source() {
    let cancel;
    const token = new _CancelToken(function executor(c) {
      cancel = c;
    });
    return {
      token,
      cancel
    };
  }
};
var CancelToken_default = CancelToken;

// ../../node_modules/axios/lib/helpers/spread.js
var import_dist988 = __toESM(require_dist(), 1);
var import_dist989 = __toESM(require_dist2(), 1);
var import_dist990 = __toESM(require_dist3(), 1);
function spread(callback) {
  return function wrap3(arr) {
    return callback.apply(null, arr);
  };
}

// ../../node_modules/axios/lib/helpers/isAxiosError.js
var import_dist991 = __toESM(require_dist(), 1);
var import_dist992 = __toESM(require_dist2(), 1);
var import_dist993 = __toESM(require_dist3(), 1);
function isAxiosError(payload) {
  return utils_default.isObject(payload) && payload.isAxiosError === true;
}

// ../../node_modules/axios/lib/helpers/HttpStatusCode.js
var import_dist994 = __toESM(require_dist(), 1);
var import_dist995 = __toESM(require_dist2(), 1);
var import_dist996 = __toESM(require_dist3(), 1);
var HttpStatusCode = {
  Continue: 100,
  SwitchingProtocols: 101,
  Processing: 102,
  EarlyHints: 103,
  Ok: 200,
  Created: 201,
  Accepted: 202,
  NonAuthoritativeInformation: 203,
  NoContent: 204,
  ResetContent: 205,
  PartialContent: 206,
  MultiStatus: 207,
  AlreadyReported: 208,
  ImUsed: 226,
  MultipleChoices: 300,
  MovedPermanently: 301,
  Found: 302,
  SeeOther: 303,
  NotModified: 304,
  UseProxy: 305,
  Unused: 306,
  TemporaryRedirect: 307,
  PermanentRedirect: 308,
  BadRequest: 400,
  Unauthorized: 401,
  PaymentRequired: 402,
  Forbidden: 403,
  NotFound: 404,
  MethodNotAllowed: 405,
  NotAcceptable: 406,
  ProxyAuthenticationRequired: 407,
  RequestTimeout: 408,
  Conflict: 409,
  Gone: 410,
  LengthRequired: 411,
  PreconditionFailed: 412,
  PayloadTooLarge: 413,
  UriTooLong: 414,
  UnsupportedMediaType: 415,
  RangeNotSatisfiable: 416,
  ExpectationFailed: 417,
  ImATeapot: 418,
  MisdirectedRequest: 421,
  UnprocessableEntity: 422,
  Locked: 423,
  FailedDependency: 424,
  TooEarly: 425,
  UpgradeRequired: 426,
  PreconditionRequired: 428,
  TooManyRequests: 429,
  RequestHeaderFieldsTooLarge: 431,
  UnavailableForLegalReasons: 451,
  InternalServerError: 500,
  NotImplemented: 501,
  BadGateway: 502,
  ServiceUnavailable: 503,
  GatewayTimeout: 504,
  HttpVersionNotSupported: 505,
  VariantAlsoNegotiates: 506,
  InsufficientStorage: 507,
  LoopDetected: 508,
  NotExtended: 510,
  NetworkAuthenticationRequired: 511,
  WebServerIsDown: 521,
  ConnectionTimedOut: 522,
  OriginIsUnreachable: 523,
  TimeoutOccurred: 524,
  SslHandshakeFailed: 525,
  InvalidSslCertificate: 526
};
Object.entries(HttpStatusCode).forEach(([key, value]) => {
  HttpStatusCode[value] = key;
});
var HttpStatusCode_default = HttpStatusCode;

// ../../node_modules/axios/lib/axios.js
function createInstance(defaultConfig) {
  const context = new Axios_default(defaultConfig);
  const instance = bind(Axios_default.prototype.request, context);
  utils_default.extend(instance, Axios_default.prototype, context, { allOwnKeys: true });
  utils_default.extend(instance, context, null, { allOwnKeys: true });
  instance.create = function create2(instanceConfig) {
    return createInstance(mergeConfig(defaultConfig, instanceConfig));
  };
  return instance;
}
var axios = createInstance(defaults_default);
axios.Axios = Axios_default;
axios.CanceledError = CanceledError_default;
axios.CancelToken = CancelToken_default;
axios.isCancel = isCancel;
axios.VERSION = VERSION;
axios.toFormData = toFormData_default;
axios.AxiosError = AxiosError_default;
axios.Cancel = axios.CanceledError;
axios.all = function all(promises) {
  return Promise.all(promises);
};
axios.spread = spread;
axios.isAxiosError = isAxiosError;
axios.mergeConfig = mergeConfig;
axios.AxiosHeaders = AxiosHeaders_default;
axios.formToJSON = (thing) => formDataToJSON_default(utils_default.isHTMLForm(thing) ? new FormData(thing) : thing);
axios.getAdapter = adapters_default.getAdapter;
axios.HttpStatusCode = HttpStatusCode_default;
axios.default = axios;
var axios_default = axios;

// ../../node_modules/axios/index.js
var {
  Axios: Axios2,
  AxiosError: AxiosError2,
  CanceledError: CanceledError2,
  isCancel: isCancel2,
  CancelToken: CancelToken2,
  VERSION: VERSION2,
  all: all2,
  Cancel,
  isAxiosError: isAxiosError2,
  spread: spread2,
  toFormData: toFormData2,
  AxiosHeaders: AxiosHeaders2,
  HttpStatusCode: HttpStatusCode2,
  formToJSON,
  getAdapter: getAdapter2,
  mergeConfig: mergeConfig2
} = axios_default;

// ../../node_modules/@polymarket/clob-client/dist/http-helpers/index.js
var import_browser_or_node = __toESM(require_lib(), 1);
var GET = "GET";
var POST = "POST";
var DELETE = "DELETE";
var PUT = "PUT";
var overloadHeaders = (method, headers) => {
  if (import_browser_or_node.isBrowser) {
    return;
  }
  if (!headers || typeof headers === void 0) {
    headers = {};
  }
  if (headers) {
    headers["User-Agent"] = `@polymarket/clob-client`;
    headers["Accept"] = "*/*";
    headers["Connection"] = "keep-alive";
    headers["Content-Type"] = "application/json";
    if (method === GET) {
      headers["Accept-Encoding"] = "gzip";
    }
  }
};
var request = async (endpoint, method, headers, data, params) => {
  overloadHeaders(method, headers);
  return await axios_default({ method, url: endpoint, headers, data, params });
};
var sleep = (ms) => new Promise((res) => setTimeout(res, ms));
var isTransientAxiosError = (err) => {
  if (!axios_default.isAxiosError(err))
    return false;
  if (!err.response)
    return true;
  const status = err.response.status ?? 0;
  if (status >= 500 && status < 600)
    return true;
  const code = (err.code ?? "").toString();
  return ["ECONNABORTED", "ENETUNREACH", "EAI_AGAIN", "ETIMEDOUT"].includes(code);
};
var post = async (endpoint, options, retryOnError) => {
  try {
    const resp = await request(endpoint, POST, options == null ? void 0 : options.headers, options == null ? void 0 : options.data, options == null ? void 0 : options.params);
    return resp.data;
  } catch (err) {
    if (retryOnError && isTransientAxiosError(err)) {
      console.log("[CLOB Client] transient error, retrying once after 30 ms");
      await sleep(30);
      try {
        const resp = await request(endpoint, POST, options == null ? void 0 : options.headers, options == null ? void 0 : options.data, options == null ? void 0 : options.params);
        return resp.data;
      } catch (retryErr) {
        return errorHandling(retryErr);
      }
    }
    return errorHandling(err);
  }
};
var get = async (endpoint, options) => {
  try {
    const resp = await request(endpoint, GET, options == null ? void 0 : options.headers, options == null ? void 0 : options.data, options == null ? void 0 : options.params);
    return resp.data;
  } catch (err) {
    return errorHandling(err);
  }
};
var del = async (endpoint, options) => {
  try {
    const resp = await request(endpoint, DELETE, options == null ? void 0 : options.headers, options == null ? void 0 : options.data, options == null ? void 0 : options.params);
    return resp.data;
  } catch (err) {
    return errorHandling(err);
  }
};
var put = async (endpoint, options) => {
  try {
    const resp = await request(endpoint, PUT, options == null ? void 0 : options.headers, options == null ? void 0 : options.data, options == null ? void 0 : options.params);
    return resp.data;
  } catch (err) {
    return errorHandling(err);
  }
};
var errorHandling = (err) => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n;
  if (axios_default.isAxiosError(err)) {
    if (err.response) {
      console.error("[CLOB Client] request error", JSON.stringify({
        status: (_a = err.response) == null ? void 0 : _a.status,
        statusText: (_b = err.response) == null ? void 0 : _b.statusText,
        data: (_c = err.response) == null ? void 0 : _c.data,
        config: (_d = err.response) == null ? void 0 : _d.config
      }));
      if ((_e = err.response) == null ? void 0 : _e.data) {
        if (typeof ((_f = err.response) == null ? void 0 : _f.data) === "string" || ((_g = err.response) == null ? void 0 : _g.data) instanceof String) {
          return { error: (_h = err.response) == null ? void 0 : _h.data, status: (_i = err.response) == null ? void 0 : _i.status };
        }
        if (!Object.prototype.hasOwnProperty.call((_j = err.response) == null ? void 0 : _j.data, "error")) {
          return { error: (_k = err.response) == null ? void 0 : _k.data, status: (_l = err.response) == null ? void 0 : _l.status };
        }
        return { ...(_m = err.response) == null ? void 0 : _m.data, status: (_n = err.response) == null ? void 0 : _n.status };
      }
    }
    if (err.message) {
      console.error("[CLOB Client] request error", JSON.stringify({
        error: err.message
      }));
      return { error: err.message };
    }
  }
  console.error("[CLOB Client] request error", err);
  return { error: err };
};
var parseDropNotificationParams = (dropNotificationParams) => {
  const params = {};
  if (dropNotificationParams !== void 0) {
    if (dropNotificationParams.ids !== void 0) {
      params["ids"] = dropNotificationParams == null ? void 0 : dropNotificationParams.ids.join(",");
    }
  }
  return params;
};

// ../../node_modules/@polymarket/clob-client/dist/errors.js
var import_dist1006 = __toESM(require_dist(), 1);
var import_dist1007 = __toESM(require_dist2(), 1);
var import_dist1008 = __toESM(require_dist3(), 1);
var L1_AUTH_UNAVAILABLE_ERROR = new Error("Signer is needed to interact with this endpoint!");
var L2_AUTH_NOT_AVAILABLE = new Error("API Credentials are needed to interact with this endpoint!");
var BUILDER_AUTH_NOT_AVAILABLE = new Error("Builder API Credentials needed to interact with this endpoint!");
var BUILDER_AUTH_FAILED = new Error("Builder key auth failed!");

// ../../node_modules/@polymarket/clob-client/dist/utilities.js
var import_dist1009 = __toESM(require_dist(), 1);
var import_dist1010 = __toESM(require_dist2(), 1);
var import_dist1011 = __toESM(require_dist3(), 1);
function orderToJson(order, owner, orderType, deferExec = false, postOnly) {
  if (postOnly === true && orderType !== OrderType.GTC && orderType !== OrderType.GTD) {
    throw new Error("postOnly is only supported for GTC and GTD orders");
  }
  let side = Side2.BUY;
  if (order.side == Side.BUY) {
    side = Side2.BUY;
  } else {
    side = Side2.SELL;
  }
  return {
    deferExec,
    order: {
      salt: parseInt(order.salt, 10),
      maker: order.maker,
      signer: order.signer,
      taker: order.taker,
      tokenId: order.tokenId,
      makerAmount: order.makerAmount,
      takerAmount: order.takerAmount,
      side,
      expiration: order.expiration,
      nonce: order.nonce,
      feeRateBps: order.feeRateBps,
      signatureType: order.signatureType,
      signature: order.signature
    },
    owner,
    orderType,
    ...typeof postOnly === "boolean" ? { postOnly } : {}
  };
}
var roundNormal = (num, decimals) => {
  if (decimalPlaces(num) <= decimals) {
    return num;
  }
  return Math.round((num + Number.EPSILON) * 10 ** decimals) / 10 ** decimals;
};
var roundDown = (num, decimals) => {
  if (decimalPlaces(num) <= decimals) {
    return num;
  }
  return Math.floor(num * 10 ** decimals) / 10 ** decimals;
};
var roundUp = (num, decimals) => {
  if (decimalPlaces(num) <= decimals) {
    return num;
  }
  return Math.ceil(num * 10 ** decimals) / 10 ** decimals;
};
var decimalPlaces = (num) => {
  if (Number.isInteger(num)) {
    return 0;
  }
  const arr = num.toString().split(".");
  if (arr.length <= 1) {
    return 0;
  }
  return arr[1].length;
};
function arrayBufferToHex(buffer) {
  const bytes = new Uint8Array(buffer);
  return Array.from(bytes).map((b) => b.toString(16).padStart(2, "0")).join("");
}
var generateOrderBookSummaryHash = async (orderbook) => {
  orderbook.hash = "";
  const message = JSON.stringify(orderbook);
  const messageBuffer = new TextEncoder().encode(message);
  const hashBuffer = await globalThis.crypto.subtle.digest("SHA-1", messageBuffer);
  const hash2 = arrayBufferToHex(hashBuffer);
  orderbook.hash = hash2;
  return hash2;
};
var isTickSizeSmaller = (a, b) => {
  return parseFloat(a) < parseFloat(b);
};
var priceValid = (price, tickSize) => {
  return price >= parseFloat(tickSize) && price <= 1 - parseFloat(tickSize);
};

// ../../node_modules/@polymarket/clob-client/dist/endpoints.js
var import_dist1012 = __toESM(require_dist(), 1);
var import_dist1013 = __toESM(require_dist2(), 1);
var import_dist1014 = __toESM(require_dist3(), 1);
var TIME = "/time";
var CREATE_API_KEY = "/auth/api-key";
var GET_API_KEYS = "/auth/api-keys";
var DELETE_API_KEY = "/auth/api-key";
var DERIVE_API_KEY = "/auth/derive-api-key";
var CLOSED_ONLY = "/auth/ban-status/closed-only";
var CREATE_READONLY_API_KEY = "/auth/readonly-api-key";
var GET_READONLY_API_KEYS = "/auth/readonly-api-keys";
var DELETE_READONLY_API_KEY = "/auth/readonly-api-key";
var VALIDATE_READONLY_API_KEY = "/auth/validate-readonly-api-key";
var CREATE_BUILDER_API_KEY = "/auth/builder-api-key";
var GET_BUILDER_API_KEYS = "/auth/builder-api-key";
var REVOKE_BUILDER_API_KEY = "/auth/builder-api-key";
var GET_SAMPLING_SIMPLIFIED_MARKETS = "/sampling-simplified-markets";
var GET_SAMPLING_MARKETS = "/sampling-markets";
var GET_SIMPLIFIED_MARKETS = "/simplified-markets";
var GET_MARKETS = "/markets";
var GET_MARKET = "/markets/";
var GET_ORDER_BOOK = "/book";
var GET_ORDER_BOOKS = "/books";
var GET_MIDPOINT = "/midpoint";
var GET_MIDPOINTS = "/midpoints";
var GET_PRICE = "/price";
var GET_PRICES = "/prices";
var GET_SPREAD = "/spread";
var GET_SPREADS = "/spreads";
var GET_LAST_TRADE_PRICE = "/last-trade-price";
var GET_LAST_TRADES_PRICES = "/last-trades-prices";
var GET_TICK_SIZE = "/tick-size";
var GET_NEG_RISK = "/neg-risk";
var GET_FEE_RATE = "/fee-rate";
var POST_ORDER = "/order";
var POST_ORDERS = "/orders";
var CANCEL_ORDER = "/order";
var CANCEL_ORDERS = "/orders";
var GET_ORDER = "/data/order/";
var CANCEL_ALL = "/cancel-all";
var CANCEL_MARKET_ORDERS = "/cancel-market-orders";
var GET_OPEN_ORDERS = "/data/orders";
var GET_TRADES = "/data/trades";
var IS_ORDER_SCORING = "/order-scoring";
var ARE_ORDERS_SCORING = "/orders-scoring";
var GET_PRICES_HISTORY = "/prices-history";
var GET_NOTIFICATIONS = "/notifications";
var DROP_NOTIFICATIONS = "/notifications";
var GET_BALANCE_ALLOWANCE = "/balance-allowance";
var UPDATE_BALANCE_ALLOWANCE = "/balance-allowance/update";
var GET_MARKET_TRADES_EVENTS = "/live-activity/events/";
var GET_EARNINGS_FOR_USER_FOR_DAY = "/rewards/user";
var GET_TOTAL_EARNINGS_FOR_USER_FOR_DAY = "/rewards/user/total";
var GET_LIQUIDITY_REWARD_PERCENTAGES = "/rewards/user/percentages";
var GET_REWARDS_MARKETS_CURRENT = "/rewards/markets/current";
var GET_REWARDS_MARKETS = "/rewards/markets/";
var GET_REWARDS_EARNINGS_PERCENTAGES = "/rewards/user/markets";
var GET_BUILDER_TRADES = "/builder/trades";
var POST_HEARTBEAT = "/v1/heartbeats";
var CREATE_RFQ_REQUEST = "/rfq/request";
var CANCEL_RFQ_REQUEST = "/rfq/request";
var GET_RFQ_REQUESTS = "/rfq/data/requests";
var CREATE_RFQ_QUOTE = "/rfq/quote";
var CANCEL_RFQ_QUOTE = "/rfq/quote";
var RFQ_REQUESTS_ACCEPT = "/rfq/request/accept";
var RFQ_QUOTE_APPROVE = "/rfq/quote/approve";
var GET_RFQ_REQUESTER_QUOTES = "/rfq/data/requester/quotes";
var GET_RFQ_QUOTER_QUOTES = "/rfq/data/quoter/quotes";
var GET_RFQ_BEST_QUOTE = "/rfq/data/best-quote";
var RFQ_CONFIG = "/rfq/config";

// ../../node_modules/@polymarket/clob-client/dist/order-builder/builder.js
var import_dist1021 = __toESM(require_dist(), 1);
var import_dist1022 = __toESM(require_dist2(), 1);
var import_dist1023 = __toESM(require_dist3(), 1);

// ../../node_modules/@polymarket/clob-client/dist/order-builder/helpers.js
var import_dist1018 = __toESM(require_dist(), 1);
var import_dist1019 = __toESM(require_dist2(), 1);
var import_dist1020 = __toESM(require_dist3(), 1);

// ../../node_modules/@polymarket/clob-client/dist/config.js
var import_dist1015 = __toESM(require_dist(), 1);
var import_dist1016 = __toESM(require_dist2(), 1);
var import_dist1017 = __toESM(require_dist3(), 1);
var AMOY_CONTRACTS = {
  exchange: "0xdFE02Eb6733538f8Ea35D585af8DE5958AD99E40",
  negRiskAdapter: "0xd91E80cF2E7be2e162c6513ceD06f1dD0dA35296",
  negRiskExchange: "0xC5d563A36AE78145C45a50134d48A1215220f80a",
  collateral: "0x9c4e1703476e875070ee25b56a58b008cfb8fa78",
  conditionalTokens: "0x69308FB512518e39F9b16112fA8d994F4e2Bf8bB"
};
var MATIC_CONTRACTS = {
  exchange: "0x4bFb41d5B3570DeFd03C39a9A4D8dE6Bd8B8982E",
  negRiskAdapter: "0xd91E80cF2E7be2e162c6513ceD06f1dD0dA35296",
  negRiskExchange: "0xC5d563A36AE78145C45a50134d48A1215220f80a",
  collateral: "0x2791Bca1f2de4661ED88A30C99A7a9449Aa84174",
  conditionalTokens: "0x4D97DCd97eC945f40cF65F87097ACe5EA0476045"
};
var COLLATERAL_TOKEN_DECIMALS = 6;
var CONDITIONAL_TOKEN_DECIMALS = 6;
var getContractConfig = (chainID) => {
  switch (chainID) {
    case 137:
      return MATIC_CONTRACTS;
    case 80002:
      return AMOY_CONTRACTS;
    default:
      throw new Error("Invalid network");
  }
};

// ../../node_modules/@polymarket/clob-client/dist/order-builder/helpers.js
var ROUNDING_CONFIG = {
  "0.1": {
    price: 1,
    size: 2,
    amount: 3
  },
  "0.01": {
    price: 2,
    size: 2,
    amount: 4
  },
  "0.001": {
    price: 3,
    size: 2,
    amount: 5
  },
  "0.0001": {
    price: 4,
    size: 2,
    amount: 6
  }
};
var buildOrder = async (signer, exchangeAddress, chainId, orderData) => {
  const cTFExchangeOrderBuilder = new ExchangeOrderBuilder(exchangeAddress, chainId, signer);
  return cTFExchangeOrderBuilder.buildSignedOrder(orderData);
};
var getOrderRawAmounts = (side, size4, price, roundConfig) => {
  const rawPrice = roundNormal(price, roundConfig.price);
  if (side === Side2.BUY) {
    const rawTakerAmt = roundDown(size4, roundConfig.size);
    let rawMakerAmt = rawTakerAmt * rawPrice;
    if (decimalPlaces(rawMakerAmt) > roundConfig.amount) {
      rawMakerAmt = roundUp(rawMakerAmt, roundConfig.amount + 4);
      if (decimalPlaces(rawMakerAmt) > roundConfig.amount) {
        rawMakerAmt = roundDown(rawMakerAmt, roundConfig.amount);
      }
    }
    return {
      side: Side.BUY,
      rawMakerAmt,
      rawTakerAmt
    };
  } else {
    const rawMakerAmt = roundDown(size4, roundConfig.size);
    let rawTakerAmt = rawMakerAmt * rawPrice;
    if (decimalPlaces(rawTakerAmt) > roundConfig.amount) {
      rawTakerAmt = roundUp(rawTakerAmt, roundConfig.amount + 4);
      if (decimalPlaces(rawTakerAmt) > roundConfig.amount) {
        rawTakerAmt = roundDown(rawTakerAmt, roundConfig.amount);
      }
    }
    return {
      side: Side.SELL,
      rawMakerAmt,
      rawTakerAmt
    };
  }
};
var buildOrderCreationArgs = async (signer, maker, signatureType, userOrder, roundConfig) => {
  const { side, rawMakerAmt, rawTakerAmt } = getOrderRawAmounts(userOrder.side, userOrder.size, userOrder.price, roundConfig);
  const makerAmount = parseUnits(rawMakerAmt.toString(), COLLATERAL_TOKEN_DECIMALS).toString();
  const takerAmount = parseUnits(rawTakerAmt.toString(), COLLATERAL_TOKEN_DECIMALS).toString();
  let taker;
  if (typeof userOrder.taker !== "undefined" && userOrder.taker) {
    taker = userOrder.taker;
  } else {
    taker = "0x0000000000000000000000000000000000000000";
  }
  let feeRateBps;
  if (typeof userOrder.feeRateBps !== "undefined" && userOrder.feeRateBps) {
    feeRateBps = userOrder.feeRateBps.toString();
  } else {
    feeRateBps = "0";
  }
  let nonce;
  if (typeof userOrder.nonce !== "undefined" && userOrder.nonce) {
    nonce = userOrder.nonce.toString();
  } else {
    nonce = "0";
  }
  return {
    maker,
    taker,
    tokenId: userOrder.tokenID,
    makerAmount,
    takerAmount,
    side,
    feeRateBps,
    nonce,
    signer,
    expiration: (userOrder.expiration || 0).toString(),
    signatureType
  };
};
var createOrder = async (eoaSigner, chainId, signatureType, funderAddress, userOrder, options) => {
  const eoaSignerAddress = await eoaSigner.getAddress();
  const maker = funderAddress === void 0 ? eoaSignerAddress : funderAddress;
  const contractConfig = getContractConfig(chainId);
  const orderData = await buildOrderCreationArgs(eoaSignerAddress, maker, signatureType, userOrder, ROUNDING_CONFIG[options.tickSize]);
  const exchangeContract = options.negRisk ? contractConfig.negRiskExchange : contractConfig.exchange;
  return buildOrder(eoaSigner, exchangeContract, chainId, orderData);
};
var getMarketOrderRawAmounts = (side, amount, price, roundConfig) => {
  const rawPrice = roundDown(price, roundConfig.price);
  if (side === Side2.BUY) {
    const rawMakerAmt = roundDown(amount, roundConfig.size);
    let rawTakerAmt = rawMakerAmt / rawPrice;
    if (decimalPlaces(rawTakerAmt) > roundConfig.amount) {
      rawTakerAmt = roundUp(rawTakerAmt, roundConfig.amount + 4);
      if (decimalPlaces(rawTakerAmt) > roundConfig.amount) {
        rawTakerAmt = roundDown(rawTakerAmt, roundConfig.amount);
      }
    }
    return {
      side: Side.BUY,
      rawMakerAmt,
      rawTakerAmt
    };
  } else {
    const rawMakerAmt = roundDown(amount, roundConfig.size);
    let rawTakerAmt = rawMakerAmt * rawPrice;
    if (decimalPlaces(rawTakerAmt) > roundConfig.amount) {
      rawTakerAmt = roundUp(rawTakerAmt, roundConfig.amount + 4);
      if (decimalPlaces(rawTakerAmt) > roundConfig.amount) {
        rawTakerAmt = roundDown(rawTakerAmt, roundConfig.amount);
      }
    }
    return {
      side: Side.SELL,
      rawMakerAmt,
      rawTakerAmt
    };
  }
};
var buildMarketOrderCreationArgs = async (signer, maker, signatureType, userMarketOrder, roundConfig) => {
  const { side, rawMakerAmt, rawTakerAmt } = getMarketOrderRawAmounts(userMarketOrder.side, userMarketOrder.amount, userMarketOrder.price || 1, roundConfig);
  const makerAmount = parseUnits(rawMakerAmt.toString(), COLLATERAL_TOKEN_DECIMALS).toString();
  const takerAmount = parseUnits(rawTakerAmt.toString(), COLLATERAL_TOKEN_DECIMALS).toString();
  let taker;
  if (typeof userMarketOrder.taker !== "undefined" && userMarketOrder.taker) {
    taker = userMarketOrder.taker;
  } else {
    taker = "0x0000000000000000000000000000000000000000";
  }
  let feeRateBps;
  if (typeof userMarketOrder.feeRateBps !== "undefined" && userMarketOrder.feeRateBps) {
    feeRateBps = userMarketOrder.feeRateBps.toString();
  } else {
    feeRateBps = "0";
  }
  let nonce;
  if (typeof userMarketOrder.nonce !== "undefined" && userMarketOrder.nonce) {
    nonce = userMarketOrder.nonce.toString();
  } else {
    nonce = "0";
  }
  return {
    maker,
    taker,
    tokenId: userMarketOrder.tokenID,
    makerAmount,
    takerAmount,
    side,
    feeRateBps,
    nonce,
    signer,
    expiration: "0",
    signatureType
  };
};
var createMarketOrder = async (eoaSigner, chainId, signatureType, funderAddress, userMarketOrder, options) => {
  const eoaSignerAddress = await eoaSigner.getAddress();
  const maker = funderAddress === void 0 ? eoaSignerAddress : funderAddress;
  const contractConfig = getContractConfig(chainId);
  const orderData = await buildMarketOrderCreationArgs(eoaSignerAddress, maker, signatureType, userMarketOrder, ROUNDING_CONFIG[options.tickSize]);
  const exchangeContract = options.negRisk ? contractConfig.negRiskExchange : contractConfig.exchange;
  return buildOrder(eoaSigner, exchangeContract, chainId, orderData);
};
var calculateBuyMarketPrice = (positions, amountToMatch, orderType) => {
  if (!positions.length) {
    throw new Error("no match");
  }
  let sum = 0;
  for (let i = positions.length - 1; i >= 0; i--) {
    const p = positions[i];
    sum += parseFloat(p.size) * parseFloat(p.price);
    if (sum >= amountToMatch) {
      return parseFloat(p.price);
    }
  }
  if (orderType === OrderType.FOK) {
    throw new Error("no match");
  }
  return parseFloat(positions[0].price);
};
var calculateSellMarketPrice = (positions, amountToMatch, orderType) => {
  if (!positions.length) {
    throw new Error("no match");
  }
  let sum = 0;
  for (let i = positions.length - 1; i >= 0; i--) {
    const p = positions[i];
    sum += parseFloat(p.size);
    if (sum >= amountToMatch) {
      return parseFloat(p.price);
    }
  }
  if (orderType === OrderType.FOK) {
    throw new Error("no match");
  }
  return parseFloat(positions[0].price);
};

// ../../node_modules/@polymarket/clob-client/dist/order-builder/builder.js
var OrderBuilder = class {
  constructor(signer, chainId, signatureType, funderAddress, getSigner) {
    __publicField(this, "signer");
    __publicField(this, "chainId");
    // Signature type used sign orders, defaults to EOA type
    __publicField(this, "signatureType");
    // Address which holds funds to be used.
    // Used for Polymarket proxy wallets and other smart contract wallets
    // If not provided, funderAddress is the signer address
    __publicField(this, "funderAddress");
    /**
     * Optional function to dynamically resolve the signer.
     * If provided, this function will be called to obtain a fresh signer instance
     * (e.g., for smart contract wallets or when the signer may change).
     * Should return a Wallet or JsonRpcSigner, or a Promise resolving to one.
     * If not provided, the static `signer` property is used.
     */
    __publicField(this, "getSigner");
    this.signer = signer;
    this.chainId = chainId;
    this.signatureType = signatureType === void 0 ? SignatureType.EOA : signatureType;
    this.funderAddress = funderAddress;
    this.getSigner = getSigner;
  }
  /**
   * Generate and sign a order
   */
  async buildOrder(userOrder, options) {
    const signer = await this.resolveSigner();
    return createOrder(signer, this.chainId, this.signatureType, this.funderAddress, userOrder, options);
  }
  /**
   * Generate and sign a market order
   */
  async buildMarketOrder(userMarketOrder, options) {
    const signer = await this.resolveSigner();
    return createMarketOrder(signer, this.chainId, this.signatureType, this.funderAddress, userMarketOrder, options);
  }
  /** Unified getter: use fresh signer if available */
  async resolveSigner() {
    if (this.getSigner) {
      const s = await this.getSigner();
      if (!s)
        throw new Error("getSigner() function returned undefined or null");
      return s;
    }
    return this.signer;
  }
};

// ../../node_modules/@polymarket/clob-client/dist/constants.js
var import_dist1024 = __toESM(require_dist(), 1);
var import_dist1025 = __toESM(require_dist2(), 1);
var import_dist1026 = __toESM(require_dist3(), 1);
var INITIAL_CURSOR = "MA==";
var END_CURSOR = "LTE=";

// ../../node_modules/@polymarket/clob-client/dist/rfq-client.js
var import_dist1027 = __toESM(require_dist(), 1);
var import_dist1028 = __toESM(require_dist2(), 1);
var import_dist1029 = __toESM(require_dist3(), 1);
var buildRepeatedQuery = (params) => {
  const sp = new URLSearchParams();
  if (!params)
    return "";
  Object.entries(params).forEach(([key, value]) => {
    if (value === void 0 || value === null) {
      return;
    }
    if (Array.isArray(value)) {
      value.forEach((v) => sp.append(key, String(v)));
    } else {
      sp.append(key, String(value));
    }
  });
  return sp.toString();
};
var RfqClient = class {
  constructor(deps) {
    __publicField(this, "deps");
    this.deps = deps;
  }
  /**
   * Creates and posts an RFQ request from user order parameters.
   * Converts the order into the proper RFQ request format with asset amounts and submits it.
   */
  async createRfqRequest(userOrder, options) {
    this.ensureL2Auth();
    const { tokenID, price, side, size: size4 } = userOrder;
    const tickSize = await this.deps.resolveTickSize(tokenID, options == null ? void 0 : options.tickSize);
    const roundConfig = ROUNDING_CONFIG[tickSize];
    const roundedPrice = roundNormal(price, roundConfig.price).toFixed(roundConfig.price);
    const roundedSize = roundDown(size4, roundConfig.size).toFixed(roundConfig.size);
    const sizeNum = parseFloat(roundedSize);
    const priceNum = parseFloat(roundedPrice);
    let amountIn;
    let amountOut;
    let assetIn;
    let assetOut;
    if (side === Side2.BUY) {
      amountIn = parseUnits(roundedSize, COLLATERAL_TOKEN_DECIMALS).toString();
      amountOut = parseUnits((sizeNum * priceNum).toFixed(roundConfig.amount), COLLATERAL_TOKEN_DECIMALS).toString();
      assetIn = tokenID;
      assetOut = "0";
    } else {
      amountIn = parseUnits((sizeNum * priceNum).toFixed(roundConfig.amount), COLLATERAL_TOKEN_DECIMALS).toString();
      amountOut = parseUnits(roundedSize, COLLATERAL_TOKEN_DECIMALS).toString();
      assetIn = "0";
      assetOut = tokenID;
    }
    const payload = {
      assetIn,
      assetOut,
      amountIn,
      amountOut,
      userType: this.deps.userType
    };
    const endpoint = CREATE_RFQ_REQUEST;
    const l2HeaderArgs = {
      method: POST,
      requestPath: endpoint,
      body: JSON.stringify(payload)
    };
    const headers = await createL2Headers(this.deps.signer, this.deps.creds, l2HeaderArgs, this.deps.useServerTime ? await this.deps.getServerTime() : void 0);
    return this.deps.post(`${this.deps.host}${endpoint}`, { headers, data: payload });
  }
  /**
   * Cancels an existing RFQ request
   */
  async cancelRfqRequest(request2) {
    this.ensureL2Auth();
    const endpoint = CANCEL_RFQ_REQUEST;
    const l2HeaderArgs = {
      method: DELETE,
      requestPath: endpoint,
      body: JSON.stringify(request2)
    };
    const headers = await createL2Headers(this.deps.signer, this.deps.creds, l2HeaderArgs, this.deps.useServerTime ? await this.deps.getServerTime() : void 0);
    return this.deps.del(`${this.deps.host}${endpoint}`, { headers, data: request2 });
  }
  /**
   * Gets RFQ requests with optional filtering parameters
   */
  async getRfqRequests(params) {
    this.ensureL2Auth();
    const endpoint = GET_RFQ_REQUESTS;
    const l2HeaderArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.deps.signer, this.deps.creds, l2HeaderArgs, this.deps.useServerTime ? await this.deps.getServerTime() : void 0);
    const query = buildRepeatedQuery(params);
    const url = query ? `${this.deps.host}${endpoint}?${query}` : `${this.deps.host}${endpoint}`;
    return this.deps.get(url, { headers });
  }
  /**
   * Creates a quote in response to an RFQ request.
   * Converts user-friendly parameters into the proper RFQ quote format with asset amounts and submits it.
   */
  async createRfqQuote(userQuote, options) {
    this.ensureL2Auth();
    const { requestId, tokenID, price, side, size: size4 } = userQuote;
    const tickSize = await this.deps.resolveTickSize(tokenID, options == null ? void 0 : options.tickSize);
    const roundConfig = ROUNDING_CONFIG[tickSize];
    const roundedPrice = roundNormal(price, roundConfig.price).toFixed(roundConfig.price);
    const roundedSize = roundDown(size4, roundConfig.size).toFixed(roundConfig.size);
    const sizeNum = parseFloat(roundedSize);
    const priceNum = parseFloat(roundedPrice);
    let amountIn;
    let amountOut;
    let assetIn;
    let assetOut;
    if (side === Side2.SELL) {
      amountIn = parseUnits((sizeNum * priceNum).toFixed(roundConfig.amount), COLLATERAL_TOKEN_DECIMALS).toString();
      amountOut = parseUnits(roundedSize, COLLATERAL_TOKEN_DECIMALS).toString();
      assetIn = "0";
      assetOut = tokenID;
    } else {
      amountIn = parseUnits(roundedSize, COLLATERAL_TOKEN_DECIMALS).toString();
      amountOut = parseUnits((sizeNum * priceNum).toFixed(roundConfig.amount), COLLATERAL_TOKEN_DECIMALS).toString();
      assetIn = tokenID;
      assetOut = "0";
    }
    const payload = {
      requestId,
      assetIn,
      assetOut,
      amountIn,
      amountOut
    };
    const endpoint = CREATE_RFQ_QUOTE;
    const quoteWithUserType = {
      ...payload,
      userType: this.deps.userType
    };
    const l2HeaderArgs = {
      method: POST,
      requestPath: endpoint,
      body: JSON.stringify(quoteWithUserType)
    };
    const headers = await createL2Headers(this.deps.signer, this.deps.creds, l2HeaderArgs, this.deps.useServerTime ? await this.deps.getServerTime() : void 0);
    return this.deps.post(`${this.deps.host}${endpoint}`, { headers, data: quoteWithUserType });
  }
  /**
   * Gets quotes on requests created by the authenticated user (requester view).
   * Returns quotes that others have made on your requests.
   */
  async getRfqRequesterQuotes(params) {
    this.ensureL2Auth();
    const endpoint = GET_RFQ_REQUESTER_QUOTES;
    const l2HeaderArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.deps.signer, this.deps.creds, l2HeaderArgs, this.deps.useServerTime ? await this.deps.getServerTime() : void 0);
    const query = buildRepeatedQuery(params);
    const url = query ? `${this.deps.host}${endpoint}?${query}` : `${this.deps.host}${endpoint}`;
    return this.deps.get(url, { headers });
  }
  /**
   * Gets quotes created by the authenticated user (quoter view).
   * Returns quotes that you have made on others' requests.
   */
  async getRfqQuoterQuotes(params) {
    this.ensureL2Auth();
    const endpoint = GET_RFQ_QUOTER_QUOTES;
    const l2HeaderArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.deps.signer, this.deps.creds, l2HeaderArgs, this.deps.useServerTime ? await this.deps.getServerTime() : void 0);
    const query = buildRepeatedQuery(params);
    const url = query ? `${this.deps.host}${endpoint}?${query}` : `${this.deps.host}${endpoint}`;
    return this.deps.get(url, { headers });
  }
  /**
   * Gets the best quote for a given request ID
   */
  async getRfqBestQuote(params) {
    this.ensureL2Auth();
    const endpoint = GET_RFQ_BEST_QUOTE;
    const l2HeaderArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.deps.signer, this.deps.creds, l2HeaderArgs, this.deps.useServerTime ? await this.deps.getServerTime() : void 0);
    return this.deps.get(`${this.deps.host}${endpoint}`, { headers, params });
  }
  /**
   * Cancels an existing quote
   */
  async cancelRfqQuote(quote) {
    this.ensureL2Auth();
    const endpoint = CANCEL_RFQ_QUOTE;
    const l2HeaderArgs = {
      method: DELETE,
      requestPath: endpoint,
      body: JSON.stringify(quote)
    };
    const headers = await createL2Headers(this.deps.signer, this.deps.creds, l2HeaderArgs, this.deps.useServerTime ? await this.deps.getServerTime() : void 0);
    return this.deps.del(`${this.deps.host}${endpoint}`, { headers, data: quote });
  }
  /**
   * Gets the RFQ configuration from the server
   */
  async rfqConfig() {
    this.ensureL2Auth();
    const endpoint = RFQ_CONFIG;
    const l2HeaderArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.deps.signer, this.deps.creds, l2HeaderArgs, this.deps.useServerTime ? await this.deps.getServerTime() : void 0);
    return this.deps.get(`${this.deps.host}${endpoint}`, { headers });
  }
  /**
   * Accepts a quote and creates an order (taker side)
   * This fetches the request details, creates an order, and submits the acceptance
   */
  async acceptRfqQuote(payload) {
    this.ensureL2Auth();
    const rfqQuotes = await this.getRfqRequesterQuotes({
      quoteIds: [payload.quoteId]
    });
    if ("error" in rfqQuotes) {
      const errorMsg = typeof rfqQuotes.error === "string" ? rfqQuotes.error : JSON.stringify(rfqQuotes.error);
      throw new Error(`Error fetching RFQ quote: ${errorMsg}`);
    }
    if (!(rfqQuotes == null ? void 0 : rfqQuotes.data) || rfqQuotes.data.length === 0) {
      throw new Error("RFQ quote not found");
    }
    const rfqQuote = rfqQuotes.data[0];
    const orderPayload = this.getRequestOrderCreationPayload(rfqQuote);
    const orderSide = orderPayload.side;
    const size4 = orderPayload.size;
    const token = orderPayload.token;
    const order = await this.deps.createOrder({
      tokenID: token,
      price: orderPayload.price,
      size: parseFloat(size4),
      side: orderSide,
      expiration: payload.expiration
    });
    if (!order) {
      throw new Error("Error creating order");
    }
    const acceptPayload = {
      requestId: payload.requestId,
      quoteId: payload.quoteId,
      owner: this.deps.creds.key,
      ...order,
      expiration: parseInt(order.expiration),
      side: orderSide,
      salt: parseInt(order.salt.toString())
    };
    const endpoint = RFQ_REQUESTS_ACCEPT;
    const l2HeaderArgs = {
      method: POST,
      requestPath: endpoint,
      body: JSON.stringify(acceptPayload)
    };
    const headers = await createL2Headers(this.deps.signer, this.deps.creds, l2HeaderArgs, this.deps.useServerTime ? await this.deps.getServerTime() : void 0);
    return this.deps.post(`${this.deps.host}${endpoint}`, { headers, data: acceptPayload });
  }
  /**
   * Approves a quote and creates an order (maker side)
   * This fetches the quote details, creates an order, and submits the approval
   */
  async approveRfqOrder(payload) {
    this.ensureL2Auth();
    const rfqQuotes = await this.getRfqQuoterQuotes({
      quoteIds: [payload.quoteId]
    });
    if ("error" in rfqQuotes) {
      const errorMsg = typeof rfqQuotes.error === "string" ? rfqQuotes.error : JSON.stringify(rfqQuotes.error);
      throw new Error(`Error fetching RFQ quote: ${errorMsg}`);
    }
    if (!(rfqQuotes == null ? void 0 : rfqQuotes.data) || rfqQuotes.data.length === 0) {
      throw new Error("RFQ quote not found");
    }
    const rfqQuote = rfqQuotes.data[0];
    const side = rfqQuote.side === "BUY" ? Side2.BUY : Side2.SELL;
    const size4 = rfqQuote.side === "BUY" ? rfqQuote.sizeIn : rfqQuote.sizeOut;
    const order = await this.deps.createOrder({
      tokenID: rfqQuote.token,
      price: rfqQuote.price,
      size: parseFloat(size4),
      side,
      expiration: payload.expiration
    });
    if (!order) {
      throw new Error("Error creating order");
    }
    const approvePayload = {
      requestId: payload.requestId,
      quoteId: payload.quoteId,
      owner: this.deps.creds.key,
      ...order,
      expiration: parseInt(order.expiration),
      side,
      salt: parseInt(order.salt.toString())
    };
    const endpoint = RFQ_QUOTE_APPROVE;
    const l2HeaderArgs = {
      method: POST,
      requestPath: endpoint,
      body: JSON.stringify(approvePayload)
    };
    const headers = await createL2Headers(this.deps.signer, this.deps.creds, l2HeaderArgs, this.deps.useServerTime ? await this.deps.getServerTime() : void 0);
    return this.deps.post(`${this.deps.host}${endpoint}`, { headers, data: approvePayload });
  }
  /**
   * Ensures L2 authentication is available for RFQ endpoints.
   */
  ensureL2Auth() {
    if (this.deps.signer === void 0) {
      throw L1_AUTH_UNAVAILABLE_ERROR;
    }
    if (this.deps.creds === void 0) {
      throw L2_AUTH_NOT_AVAILABLE;
    }
  }
  getRequestOrderCreationPayload(quote) {
    const quoteSide = quote.side;
    const matchType = quote.matchType;
    let side;
    let token;
    let size4;
    let price;
    switch (matchType) {
      case RfqMatchType.COMPLEMENTARY:
        side = quoteSide === "BUY" ? Side2.SELL : Side2.BUY;
        token = quote.token;
        size4 = side == Side2.BUY ? quote.sizeOut : quote.sizeIn;
        price = quote.price;
        return {
          token,
          side,
          size: size4,
          price
        };
      case RfqMatchType.MINT:
      case RfqMatchType.MERGE:
        side = quoteSide === "BUY" ? Side2.BUY : Side2.SELL;
        token = quote.complement;
        size4 = side == Side2.BUY ? quote.sizeIn : quote.sizeOut;
        price = 1 - quote.price;
        return {
          token,
          side,
          size: size4,
          price
        };
      default:
        throw new Error("invalid match type");
    }
  }
};

// ../../node_modules/@polymarket/clob-client/dist/client.js
var ClobClient = class {
  // eslint-disable-next-line max-params
  constructor(host, chainId, signer, creds, signatureType, funderAddress, geoBlockToken, useServerTime, builderConfig, getSigner, retryOnError) {
    __publicField(this, "host");
    __publicField(this, "chainId");
    // Used to perform Level 1 authentication and sign orders
    __publicField(this, "signer");
    // Used to perform Level 2 authentication
    __publicField(this, "creds");
    __publicField(this, "orderBuilder");
    __publicField(this, "tickSizes");
    __publicField(this, "negRisk");
    __publicField(this, "feeRates");
    __publicField(this, "geoBlockToken");
    __publicField(this, "useServerTime");
    __publicField(this, "builderConfig");
    __publicField(this, "rfq");
    __publicField(this, "retryOnError");
    this.host = host.endsWith("/") ? host.slice(0, -1) : host;
    this.chainId = chainId;
    if (signer !== void 0) {
      this.signer = signer;
    }
    if (creds !== void 0) {
      this.creds = creds;
    }
    this.orderBuilder = new OrderBuilder(signer, chainId, signatureType, funderAddress, getSigner);
    this.tickSizes = {};
    this.negRisk = {};
    this.feeRates = {};
    this.geoBlockToken = geoBlockToken;
    this.useServerTime = useServerTime;
    this.retryOnError = retryOnError;
    if (builderConfig !== void 0) {
      this.builderConfig = builderConfig;
    }
    const rfqDeps = {
      host: this.host,
      signer: this.signer,
      creds: this.creds,
      useServerTime: this.useServerTime,
      geoBlockToken: this.geoBlockToken,
      userType: this.orderBuilder.signatureType,
      getServerTime: this.getServerTime.bind(this),
      getTickSize: this.getTickSize.bind(this),
      resolveTickSize: this._resolveTickSize.bind(this),
      createOrder: this.createOrder.bind(this),
      get: this.get.bind(this),
      post: this.post.bind(this),
      put: this.put.bind(this),
      del: this.del.bind(this)
    };
    this.rfq = new RfqClient(rfqDeps);
  }
  // Public endpoints
  async getOk() {
    return this.get(`${this.host}/`);
  }
  async getServerTime() {
    return this.get(`${this.host}${TIME}`);
  }
  async getSamplingSimplifiedMarkets(next_cursor = INITIAL_CURSOR) {
    return this.get(`${this.host}${GET_SAMPLING_SIMPLIFIED_MARKETS}`, {
      params: { next_cursor }
    });
  }
  async getSamplingMarkets(next_cursor = INITIAL_CURSOR) {
    return this.get(`${this.host}${GET_SAMPLING_MARKETS}`, {
      params: { next_cursor }
    });
  }
  async getSimplifiedMarkets(next_cursor = INITIAL_CURSOR) {
    return this.get(`${this.host}${GET_SIMPLIFIED_MARKETS}`, {
      params: { next_cursor }
    });
  }
  async getMarkets(next_cursor = INITIAL_CURSOR) {
    return this.get(`${this.host}${GET_MARKETS}`, {
      params: { next_cursor }
    });
  }
  async getMarket(conditionID) {
    return this.get(`${this.host}${GET_MARKET}${conditionID}`);
  }
  async getOrderBook(tokenID) {
    return this.get(`${this.host}${GET_ORDER_BOOK}`, {
      params: { token_id: tokenID }
    });
  }
  async getOrderBooks(params) {
    return this.post(`${this.host}${GET_ORDER_BOOKS}`, {
      data: params
    });
  }
  async getTickSize(tokenID) {
    if (tokenID in this.tickSizes) {
      return this.tickSizes[tokenID];
    }
    const result = await this.get(`${this.host}${GET_TICK_SIZE}`, {
      params: { token_id: tokenID }
    });
    this.tickSizes[tokenID] = result.minimum_tick_size.toString();
    return this.tickSizes[tokenID];
  }
  async getNegRisk(tokenID) {
    if (tokenID in this.negRisk) {
      return this.negRisk[tokenID];
    }
    const result = await this.get(`${this.host}${GET_NEG_RISK}`, {
      params: { token_id: tokenID }
    });
    this.negRisk[tokenID] = result.neg_risk;
    return this.negRisk[tokenID];
  }
  async getFeeRateBps(tokenID) {
    if (tokenID in this.feeRates) {
      return this.feeRates[tokenID];
    }
    const result = await this.get(`${this.host}${GET_FEE_RATE}`, {
      params: { token_id: tokenID }
    });
    this.feeRates[tokenID] = result.base_fee;
    return this.feeRates[tokenID];
  }
  /**
   * Calculates the hash for the given orderbook
   * @param orderbook
   * @returns
   */
  getOrderBookHash(orderbook) {
    return generateOrderBookSummaryHash(orderbook);
  }
  async getMidpoint(tokenID) {
    return this.get(`${this.host}${GET_MIDPOINT}`, {
      params: { token_id: tokenID }
    });
  }
  async getMidpoints(params) {
    return this.post(`${this.host}${GET_MIDPOINTS}`, {
      data: params
    });
  }
  async getPrice(tokenID, side) {
    return this.get(`${this.host}${GET_PRICE}`, {
      params: { token_id: tokenID, side }
    });
  }
  async getPrices(params) {
    return this.post(`${this.host}${GET_PRICES}`, {
      data: params
    });
  }
  async getSpread(tokenID) {
    return this.get(`${this.host}${GET_SPREAD}`, {
      params: { token_id: tokenID }
    });
  }
  async getSpreads(params) {
    return this.post(`${this.host}${GET_SPREADS}`, {
      data: params
    });
  }
  async getLastTradePrice(tokenID) {
    return this.get(`${this.host}${GET_LAST_TRADE_PRICE}`, {
      params: { token_id: tokenID }
    });
  }
  async getLastTradesPrices(params) {
    return this.post(`${this.host}${GET_LAST_TRADES_PRICES}`, {
      data: params
    });
  }
  async getPricesHistory(params) {
    return this.get(`${this.host}${GET_PRICES_HISTORY}`, {
      params
    });
  }
  // L1 Authed
  /**
   * Creates a new API key for a user
   * @param nonce
   * @returns ApiKeyCreds
   */
  async createApiKey(nonce) {
    this.canL1Auth();
    const endpoint = `${this.host}${CREATE_API_KEY}`;
    const headers = await createL1Headers(this.signer, this.chainId, nonce, this.useServerTime ? await this.getServerTime() : void 0);
    return await this.post(endpoint, { headers }).then((apiKeyRaw) => {
      const apiKey = {
        key: apiKeyRaw.apiKey,
        secret: apiKeyRaw.secret,
        passphrase: apiKeyRaw.passphrase
      };
      return apiKey;
    });
  }
  /**
   * Derives an existing API key for a user
   * @param nonce
   * @returns ApiKeyCreds
   */
  async deriveApiKey(nonce) {
    this.canL1Auth();
    const endpoint = `${this.host}${DERIVE_API_KEY}`;
    const headers = await createL1Headers(this.signer, this.chainId, nonce, this.useServerTime ? await this.getServerTime() : void 0);
    return await this.get(endpoint, { headers }).then((apiKeyRaw) => {
      const apiKey = {
        key: apiKeyRaw.apiKey,
        secret: apiKeyRaw.secret,
        passphrase: apiKeyRaw.passphrase
      };
      return apiKey;
    });
  }
  async createOrDeriveApiKey(nonce) {
    return this.createApiKey(nonce).then((response) => {
      if (!response.key) {
        return this.deriveApiKey(nonce);
      }
      return response;
    });
  }
  async getApiKeys() {
    this.canL2Auth();
    const endpoint = GET_API_KEYS;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.get(`${this.host}${endpoint}`, { headers });
  }
  async getClosedOnlyMode() {
    this.canL2Auth();
    const endpoint = CLOSED_ONLY;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.get(`${this.host}${endpoint}`, { headers });
  }
  async deleteApiKey() {
    this.canL2Auth();
    const endpoint = DELETE_API_KEY;
    const headerArgs = {
      method: DELETE,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.del(`${this.host}${endpoint}`, { headers });
  }
  /**
   * Creates a new readonly API key for a user
   * @returns ReadonlyApiKeyResponse
   */
  async createReadonlyApiKey() {
    this.canL2Auth();
    const endpoint = CREATE_READONLY_API_KEY;
    const headerArgs = {
      method: POST,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.post(`${this.host}${endpoint}`, { headers });
  }
  async getReadonlyApiKeys() {
    this.canL2Auth();
    const endpoint = GET_READONLY_API_KEYS;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.get(`${this.host}${endpoint}`, { headers });
  }
  /**
   * Deletes a readonly API key for a user
   * @param key The readonly API key to delete
   * @returns boolean
   */
  async deleteReadonlyApiKey(key) {
    this.canL2Auth();
    const endpoint = DELETE_READONLY_API_KEY;
    const payload = { key };
    const headerArgs = {
      method: DELETE,
      requestPath: endpoint,
      body: JSON.stringify(payload)
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.del(`${this.host}${endpoint}`, { headers, data: payload });
  }
  /**
   * Validates a readonly API key for a given address
   * @param address The wallet address
   * @param key The readonly API key to validate
   * @returns string
   */
  async validateReadonlyApiKey(address, key) {
    return this.get(`${this.host}${VALIDATE_READONLY_API_KEY}`, {
      params: { address, key }
    });
  }
  async getOrder(orderID) {
    this.canL2Auth();
    const endpoint = `${GET_ORDER}${orderID}`;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.get(`${this.host}${endpoint}`, { headers });
  }
  async getTrades(params, only_first_page = false, next_cursor) {
    this.canL2Auth();
    const endpoint = GET_TRADES;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    let results = [];
    next_cursor = next_cursor || INITIAL_CURSOR;
    while (next_cursor != END_CURSOR && (next_cursor === INITIAL_CURSOR || !only_first_page)) {
      const _params = {
        ...params,
        next_cursor
      };
      const response = await this.get(`${this.host}${endpoint}`, {
        headers,
        params: _params
      });
      next_cursor = response.next_cursor;
      results = [...results, ...response.data];
    }
    return results;
  }
  async getTradesPaginated(params, next_cursor) {
    this.canL2Auth();
    const endpoint = GET_TRADES;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    next_cursor = next_cursor || INITIAL_CURSOR;
    const _params = { ...params, next_cursor };
    const { data, ...rest } = await this.get(`${this.host}${endpoint}`, {
      headers,
      params: _params
    });
    return { trades: Array.isArray(data) ? [...data] : [], ...rest };
  }
  async getBuilderTrades(params, next_cursor) {
    this.mustBuilderAuth();
    const endpoint = GET_BUILDER_TRADES;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await this._getBuilderHeaders(headerArgs.method, headerArgs.requestPath);
    if (headers == void 0) {
      throw BUILDER_AUTH_FAILED;
    }
    next_cursor = next_cursor || INITIAL_CURSOR;
    const _params = { ...params, next_cursor };
    const { data, ...rest } = await this.get(`${this.host}${endpoint}`, {
      headers,
      params: _params
    });
    return { trades: Array.isArray(data) ? [...data] : [], ...rest };
  }
  async getNotifications() {
    this.canL2Auth();
    const endpoint = GET_NOTIFICATIONS;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.get(`${this.host}${endpoint}`, {
      headers,
      params: { signature_type: this.orderBuilder.signatureType }
    });
  }
  async dropNotifications(params) {
    this.canL2Auth();
    const endpoint = DROP_NOTIFICATIONS;
    const l2HeaderArgs = {
      method: DELETE,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, l2HeaderArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.del(`${this.host}${endpoint}`, {
      headers,
      params: parseDropNotificationParams(params)
    });
  }
  async getBalanceAllowance(params) {
    this.canL2Auth();
    const endpoint = GET_BALANCE_ALLOWANCE;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    const _params = {
      ...params,
      signature_type: this.orderBuilder.signatureType
    };
    return this.get(`${this.host}${endpoint}`, { headers, params: _params });
  }
  async updateBalanceAllowance(params) {
    this.canL2Auth();
    const endpoint = UPDATE_BALANCE_ALLOWANCE;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    const _params = {
      ...params,
      signature_type: this.orderBuilder.signatureType
    };
    return this.get(`${this.host}${endpoint}`, { headers, params: _params });
  }
  async createOrder(userOrder, options) {
    this.canL1Auth();
    const { tokenID } = userOrder;
    const tickSize = await this._resolveTickSize(tokenID, options == null ? void 0 : options.tickSize);
    const feeRateBps = await this._resolveFeeRateBps(tokenID, userOrder.feeRateBps);
    userOrder.feeRateBps = feeRateBps;
    if (!priceValid(userOrder.price, tickSize)) {
      throw new Error(`invalid price (${userOrder.price}), min: ${parseFloat(tickSize)} - max: ${1 - parseFloat(tickSize)}`);
    }
    const negRisk = (options == null ? void 0 : options.negRisk) ?? await this.getNegRisk(tokenID);
    return this.orderBuilder.buildOrder(userOrder, {
      tickSize,
      negRisk
    });
  }
  async createMarketOrder(userMarketOrder, options) {
    this.canL1Auth();
    const { tokenID } = userMarketOrder;
    const tickSize = await this._resolveTickSize(tokenID, options == null ? void 0 : options.tickSize);
    const feeRateBps = await this._resolveFeeRateBps(tokenID, userMarketOrder.feeRateBps);
    userMarketOrder.feeRateBps = feeRateBps;
    if (!userMarketOrder.price) {
      userMarketOrder.price = await this.calculateMarketPrice(tokenID, userMarketOrder.side, userMarketOrder.amount, userMarketOrder.orderType);
    }
    if (!priceValid(userMarketOrder.price, tickSize)) {
      throw new Error(`invalid price (${userMarketOrder.price}), min: ${parseFloat(tickSize)} - max: ${1 - parseFloat(tickSize)}`);
    }
    const negRisk = (options == null ? void 0 : options.negRisk) ?? await this.getNegRisk(tokenID);
    return this.orderBuilder.buildMarketOrder(userMarketOrder, {
      tickSize,
      negRisk
    });
  }
  async createAndPostOrder(userOrder, options, orderType = OrderType.GTC, deferExec = false, postOnly = false) {
    const order = await this.createOrder(userOrder, options);
    return this.postOrder(order, orderType, deferExec, postOnly);
  }
  async createAndPostMarketOrder(userMarketOrder, options, orderType = OrderType.FOK, deferExec = false) {
    const order = await this.createMarketOrder(userMarketOrder, options);
    return this.postOrder(order, orderType, deferExec);
  }
  async getOpenOrders(params, only_first_page = false, next_cursor) {
    this.canL2Auth();
    const endpoint = GET_OPEN_ORDERS;
    const l2HeaderArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, l2HeaderArgs, this.useServerTime ? await this.getServerTime() : void 0);
    let results = [];
    next_cursor = next_cursor || INITIAL_CURSOR;
    while (next_cursor != END_CURSOR && (next_cursor === INITIAL_CURSOR || !only_first_page)) {
      const _params = {
        ...params,
        next_cursor
      };
      const response = await this.get(`${this.host}${endpoint}`, {
        headers,
        params: _params
      });
      next_cursor = response.next_cursor;
      results = [...results, ...response.data];
    }
    return results;
  }
  async postOrder(order, orderType = OrderType.GTC, deferExec = false, postOnly = false) {
    var _a;
    this.canL2Auth();
    const endpoint = POST_ORDER;
    const orderPayload = orderToJson(order, ((_a = this.creds) == null ? void 0 : _a.key) || "", orderType, deferExec, postOnly);
    const l2HeaderArgs = {
      method: POST,
      requestPath: endpoint,
      body: JSON.stringify(orderPayload)
    };
    const headers = await createL2Headers(this.signer, this.creds, l2HeaderArgs, this.useServerTime ? await this.getServerTime() : void 0);
    if (this.canBuilderAuth()) {
      const builderHeaders = await this._generateBuilderHeaders(headers, l2HeaderArgs);
      if (builderHeaders !== void 0) {
        return this.post(`${this.host}${endpoint}`, { headers: builderHeaders, data: orderPayload });
      }
    }
    return this.post(`${this.host}${endpoint}`, { headers, data: orderPayload });
  }
  async postOrders(args, deferExec = false, defaultPostOnly = false) {
    var _a;
    this.canL2Auth();
    const endpoint = POST_ORDERS;
    const ordersPayload = [];
    for (const { order, orderType, postOnly: orderPostOnly } of args) {
      const orderPayload = orderToJson(order, ((_a = this.creds) == null ? void 0 : _a.key) || "", orderType, deferExec, orderPostOnly ?? defaultPostOnly);
      ordersPayload.push(orderPayload);
    }
    const l2HeaderArgs = {
      method: POST,
      requestPath: endpoint,
      body: JSON.stringify(ordersPayload)
    };
    const headers = await createL2Headers(this.signer, this.creds, l2HeaderArgs, this.useServerTime ? await this.getServerTime() : void 0);
    if (this.canBuilderAuth()) {
      const builderHeaders = await this._generateBuilderHeaders(headers, l2HeaderArgs);
      if (builderHeaders !== void 0) {
        return this.post(`${this.host}${endpoint}`, { headers: builderHeaders, data: ordersPayload });
      }
    }
    return this.post(`${this.host}${endpoint}`, { headers, data: ordersPayload });
  }
  async cancelOrder(payload) {
    this.canL2Auth();
    const endpoint = CANCEL_ORDER;
    const l2HeaderArgs = {
      method: DELETE,
      requestPath: endpoint,
      body: JSON.stringify(payload)
    };
    const headers = await createL2Headers(this.signer, this.creds, l2HeaderArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.del(`${this.host}${endpoint}`, { headers, data: payload });
  }
  async cancelOrders(ordersHashes) {
    this.canL2Auth();
    const endpoint = CANCEL_ORDERS;
    const l2HeaderArgs = {
      method: DELETE,
      requestPath: endpoint,
      body: JSON.stringify(ordersHashes)
    };
    const headers = await createL2Headers(this.signer, this.creds, l2HeaderArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.del(`${this.host}${endpoint}`, { headers, data: ordersHashes });
  }
  async cancelAll() {
    this.canL2Auth();
    const endpoint = CANCEL_ALL;
    const l2HeaderArgs = {
      method: DELETE,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, l2HeaderArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.del(`${this.host}${endpoint}`, { headers });
  }
  /**
   * Sends a heartbeat to the server to keep the session active.
   *
   * If heartbeats are started and one isn't sent within 10s, all orders will be cancelled.
   * Requires Level 2 authentication.
   *
   * Pass the previously returned `heartbeat_id` to chain heartbeats.
   * Pass `undefined`/`null` to start a new heartbeat chain.
   */
  async postHeartbeat(heartbeatId) {
    this.canL2Auth();
    const endpoint = POST_HEARTBEAT;
    const bodyObj = { heartbeat_id: heartbeatId ?? null };
    const serialized = JSON.stringify(bodyObj);
    const l2HeaderArgs = {
      method: POST,
      requestPath: endpoint,
      body: serialized
    };
    const headers = await createL2Headers(this.signer, this.creds, l2HeaderArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.post(`${this.host}${endpoint}`, { headers, data: serialized });
  }
  async cancelMarketOrders(payload) {
    this.canL2Auth();
    const endpoint = CANCEL_MARKET_ORDERS;
    const l2HeaderArgs = {
      method: DELETE,
      requestPath: endpoint,
      body: JSON.stringify(payload)
    };
    const headers = await createL2Headers(this.signer, this.creds, l2HeaderArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.del(`${this.host}${endpoint}`, { headers, data: payload });
  }
  async isOrderScoring(params) {
    this.canL2Auth();
    const endpoint = IS_ORDER_SCORING;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.get(`${this.host}${endpoint}`, { headers, params });
  }
  async areOrdersScoring(params) {
    this.canL2Auth();
    const endpoint = ARE_ORDERS_SCORING;
    const payload = JSON.stringify(params == null ? void 0 : params.orderIds);
    const headerArgs = {
      method: POST,
      requestPath: endpoint,
      body: payload
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.post(`${this.host}${endpoint}`, {
      headers,
      data: payload
    });
  }
  // Rewards
  async getEarningsForUserForDay(date) {
    this.canL2Auth();
    const endpoint = GET_EARNINGS_FOR_USER_FOR_DAY;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    let results = [];
    let next_cursor = INITIAL_CURSOR;
    while (next_cursor != END_CURSOR) {
      const params = {
        date,
        signature_type: this.orderBuilder.signatureType,
        next_cursor
      };
      const response = await this.get(`${this.host}${endpoint}`, {
        headers,
        params
      });
      next_cursor = response.next_cursor;
      results = [...results, ...response.data];
    }
    return results;
  }
  async getTotalEarningsForUserForDay(date) {
    this.canL2Auth();
    const endpoint = GET_TOTAL_EARNINGS_FOR_USER_FOR_DAY;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    const params = {
      date,
      signature_type: this.orderBuilder.signatureType
    };
    return await this.get(`${this.host}${endpoint}`, {
      headers,
      params
    });
  }
  async getUserEarningsAndMarketsConfig(date, order_by = "", position = "", no_competition = false) {
    this.canL2Auth();
    const endpoint = GET_REWARDS_EARNINGS_PERCENTAGES;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    let results = [];
    let next_cursor = INITIAL_CURSOR;
    while (next_cursor != END_CURSOR) {
      const params = {
        date,
        signature_type: this.orderBuilder.signatureType,
        next_cursor,
        order_by,
        position,
        no_competition
      };
      const response = await this.get(`${this.host}${endpoint}`, {
        headers,
        params
      });
      next_cursor = response.next_cursor;
      results = [...results, ...response.data];
    }
    return results;
  }
  async getRewardPercentages() {
    this.canL2Auth();
    const endpoint = GET_LIQUIDITY_REWARD_PERCENTAGES;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    const _params = {
      signature_type: this.orderBuilder.signatureType
    };
    return this.get(`${this.host}${endpoint}`, { headers, params: _params });
  }
  async getCurrentRewards() {
    let results = [];
    let next_cursor = INITIAL_CURSOR;
    while (next_cursor != END_CURSOR) {
      const response = await this.get(`${this.host}${GET_REWARDS_MARKETS_CURRENT}`, {
        params: { next_cursor }
      });
      next_cursor = response.next_cursor;
      results = [...results, ...response.data];
    }
    return results;
  }
  async getRawRewardsForMarket(conditionId) {
    let results = [];
    let next_cursor = INITIAL_CURSOR;
    while (next_cursor != END_CURSOR) {
      const response = await this.get(`${this.host}${GET_REWARDS_MARKETS}${conditionId}`, {
        params: { next_cursor }
      });
      next_cursor = response.next_cursor;
      results = [...results, ...response.data];
    }
    return results;
  }
  async getMarketTradesEvents(conditionID) {
    return this.get(`${this.host}${GET_MARKET_TRADES_EVENTS}${conditionID}`);
  }
  async calculateMarketPrice(tokenID, side, amount, orderType = OrderType.FOK) {
    const book = await this.getOrderBook(tokenID);
    if (!book) {
      throw new Error("no orderbook");
    }
    if (side === Side2.BUY) {
      if (!book.asks) {
        throw new Error("no match");
      }
      return calculateBuyMarketPrice(book.asks, amount, orderType);
    } else {
      if (!book.bids) {
        throw new Error("no match");
      }
      return calculateSellMarketPrice(book.bids, amount, orderType);
    }
  }
  async createBuilderApiKey() {
    this.canL2Auth();
    const endpoint = CREATE_BUILDER_API_KEY;
    const headerArgs = {
      method: POST,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.post(`${this.host}${endpoint}`, { headers });
  }
  async getBuilderApiKeys() {
    this.canL2Auth();
    const endpoint = GET_BUILDER_API_KEYS;
    const headerArgs = {
      method: GET,
      requestPath: endpoint
    };
    const headers = await createL2Headers(this.signer, this.creds, headerArgs, this.useServerTime ? await this.getServerTime() : void 0);
    return this.get(`${this.host}${endpoint}`, { headers });
  }
  async revokeBuilderApiKey() {
    this.mustBuilderAuth();
    const endpoint = REVOKE_BUILDER_API_KEY;
    const headerArgs = {
      method: DELETE,
      requestPath: endpoint
    };
    const headers = await this._getBuilderHeaders(headerArgs.method, headerArgs.requestPath);
    if (headers == void 0) {
      throw BUILDER_AUTH_FAILED;
    }
    return this.del(`${this.host}${endpoint}`, { headers });
  }
  async _resolveTickSize(tokenID, tickSize) {
    const minTickSize = await this.getTickSize(tokenID);
    if (tickSize) {
      if (isTickSizeSmaller(tickSize, minTickSize)) {
        throw new Error(`invalid tick size (${tickSize}), minimum for the market is ${minTickSize}`);
      }
    } else {
      tickSize = minTickSize;
    }
    return tickSize;
  }
  // http methods
  async get(endpoint, options) {
    return get(endpoint, {
      ...options,
      params: { ...options == null ? void 0 : options.params, geo_block_token: this.geoBlockToken }
    });
  }
  async post(endpoint, options) {
    return post(endpoint, {
      ...options,
      params: { ...options == null ? void 0 : options.params, geo_block_token: this.geoBlockToken }
    }, this.retryOnError);
  }
  async put(endpoint, options) {
    return put(endpoint, {
      ...options,
      params: { ...options == null ? void 0 : options.params, geo_block_token: this.geoBlockToken }
    });
  }
  async del(endpoint, options) {
    return del(endpoint, {
      ...options,
      params: { ...options == null ? void 0 : options.params, geo_block_token: this.geoBlockToken }
    });
  }
  canL1Auth() {
    if (this.signer === void 0) {
      throw L1_AUTH_UNAVAILABLE_ERROR;
    }
  }
  canL2Auth() {
    if (this.signer === void 0) {
      throw L1_AUTH_UNAVAILABLE_ERROR;
    }
    if (this.creds === void 0) {
      throw L2_AUTH_NOT_AVAILABLE;
    }
  }
  mustBuilderAuth() {
    if (!this.canBuilderAuth()) {
      throw BUILDER_AUTH_NOT_AVAILABLE;
    }
  }
  canBuilderAuth() {
    return this.builderConfig != void 0 && this.builderConfig.isValid();
  }
  async _resolveFeeRateBps(tokenID, userFeeRateBps) {
    const marketFeeRateBps = await this.getFeeRateBps(tokenID);
    if (marketFeeRateBps > 0 && userFeeRateBps != void 0 && userFeeRateBps != marketFeeRateBps) {
      throw new Error(`invalid user provided fee rate: ${userFeeRateBps}, fee rate for the market must be ${marketFeeRateBps}`);
    }
    return marketFeeRateBps;
  }
  async _generateBuilderHeaders(headers, headerArgs) {
    if (this.builderConfig !== void 0) {
      const builderHeaders = await this._getBuilderHeaders(headerArgs.method, headerArgs.requestPath, headerArgs.body);
      if (builderHeaders == void 0) {
        return void 0;
      }
      return injectBuilderHeaders(headers, builderHeaders);
    }
    return void 0;
  }
  async _getBuilderHeaders(method, path, body) {
    return this.builderConfig.generateBuilderHeaders(method, path, body);
  }
};

// ../../node_modules/@polymarket/clob-client/dist/order-builder/index.js
var import_dist1033 = __toESM(require_dist(), 1);
var import_dist1034 = __toESM(require_dist2(), 1);
var import_dist1035 = __toESM(require_dist3(), 1);

// ../../node_modules/@polymarket/clob-client/dist/rfq-deps.js
var import_dist1036 = __toESM(require_dist(), 1);
var import_dist1037 = __toESM(require_dist2(), 1);
var import_dist1038 = __toESM(require_dist3(), 1);
export {
  AssetType,
  COLLATERAL_TOKEN_DECIMALS,
  CONDITIONAL_TOKEN_DECIMALS,
  Chain,
  ClobClient,
  OrderBuilder,
  OrderType,
  PriceHistoryInterval,
  RfqClient,
  RfqMatchType,
  Side2 as Side,
  createL1Headers,
  createL2Headers,
  getContractConfig,
  injectBuilderHeaders
};
//# sourceMappingURL=@polymarket_clob-client.js.map
