# Galactus Dashboard

React + Vite SPA that holds keys, signs requests, and talks to Galactus Relay.

## Running

From the monorepo root:

```bash
npm run dashboard:dev
```

This builds `@galactus/shared` and then starts the Vite dev server on `http://localhost:5173`.

From this directory (requires shared to be built first):

```bash
# From repo root:
npm run build --workspace=@galactus/shared

# Then from this directory:
npm run dev
```

## Environment Variables

Copy `.env.example` to `.env` and configure:

| Variable                       | Description                                                        |
| ------------------------------ | ------------------------------------------------------------------ |
| `VITE_DASHBOARD_PASSWORD_HASH` | SHA-256 hash of the dashboard gate password                        |
| `VITE_ROUTER_BASE`             | Base path for subdirectory deployment (optional)                   |
| `VITE_RELAY_HTTP_URL`          | Relay HTTP endpoint (default: `/relay/http`)                       |
| `VITE_RELAY_WS_URL`            | Relay WebSocket endpoint (default: `ws://localhost:8787/relay/ws`) |

## Build Output

Production build outputs to `apps/dashboard/dist`.

```bash
npm run dashboard:build
```

## Testing

```bash
npm run dashboard:test
```
