/**
 * Fill Notification Component
 */

import React, { useEffect } from 'react';
import type { FillNotification } from '../types';

interface FillNotificationProps {
  fill: FillNotification;
}

const FillNotificationComponent: React.FC<FillNotificationProps> = ({ fill }) => {
  // Play sound on mount
  useEffect(() => {
    try {
      const AudioContextClass =
        window.AudioContext ||
        (window as unknown as { webkitAudioContext: typeof AudioContext }).webkitAudioContext;
      const audioContext = new AudioContextClass();
      const oscillator = audioContext.createOscillator();
      const gainNode = audioContext.createGain();

      oscillator.connect(gainNode);
      gainNode.connect(audioContext.destination);

      oscillator.frequency.value = 800;
      oscillator.type = 'sine';

      gainNode.gain.setValueAtTime(0.3, audioContext.currentTime);
      gainNode.gain.exponentialRampToValueAtTime(0.01, audioContext.currentTime + 0.2);

      oscillator.start(audioContext.currentTime);
      oscillator.stop(audioContext.currentTime + 0.2);
    } catch {
      // Ignore audio errors
    }
  }, []);

  return (
    <div className="fill-notification">
      <div className="fill-notification-content">
        <strong>Order Filled</strong>
        <div>
          {fill.action.toUpperCase()} {fill.quantity} {fill.side.toUpperCase()} @{' '}
          {fill.price.toFixed(4)}
        </div>
        <div className="fill-ticker">{fill.ticker}</div>
      </div>
    </div>
  );
};

export default FillNotificationComponent;
