/**
 * AppStatusBar - Bottom status bar
 *
 * Shows connection status and any errors.
 */

import { Wifi, WifiOff, AlertCircle } from 'lucide-react';
import { cn } from '@/lib/utils';

interface AppStatusBarProps {
  status: string;
  error: string | null;
}

export function AppStatusBar({ status, error }: AppStatusBarProps) {
  const isConnected = status === 'Connected';
  const statusLabel = isConnected ? 'API connected' : 'API disconnected';

  return (
    <div className="flex h-full items-center justify-between px-3 text-xs">
      {/* Left: Connection status */}
      <div className="flex items-center gap-2">
        {isConnected ? (
          <Wifi className="h-3 w-3 text-green-500" />
        ) : (
          <WifiOff className="text-muted-foreground h-3 w-3" />
        )}
        <span className={cn(isConnected ? 'text-green-500' : 'text-muted-foreground')}>
          {statusLabel}
        </span>
      </div>

      {/* Center: Error message */}
      {error && (
        <div className="text-destructive flex items-center gap-1.5">
          <AlertCircle className="h-3 w-3" />
          <span className="max-w-md truncate">{error}</span>
        </div>
      )}

      {/* Right: Build version */}
      <span className="text-muted-foreground font-mono">{__BUILD_COMMIT__}</span>
    </div>
  );
}
