import { Modal } from '@/components/atoms/Modal';
import { changelog, CURRENT_VERSION } from '@/lib/changelog';

interface UpdatesModalProps {
  isOpen: boolean;
  onClose: () => void;
}

export function UpdatesModal({ isOpen, onClose }: UpdatesModalProps) {
  return (
    <Modal
      isOpen={isOpen}
      onClose={onClose}
      title={`Updates — ${CURRENT_VERSION}`}
      size="lg"
    >
      <div className="space-y-6">
        {changelog.map((entry) => (
          <div key={entry.version}>
            <div className="mb-2 flex items-baseline gap-3">
              <span className="bg-primary/15 text-primary rounded px-2 py-0.5 font-mono text-sm font-semibold">
                {entry.version}
              </span>
              <span className="text-muted-foreground text-xs">{entry.date}</span>
              <span className="text-sm font-medium">{entry.title}</span>
            </div>
            <ul className="text-muted-foreground space-y-1 text-sm">
              {entry.changes.map((change, i) => (
                <li
                  key={i}
                  className="flex gap-2"
                >
                  <span className="text-muted-foreground/50 select-none">-</span>
                  <span>{change}</span>
                </li>
              ))}
            </ul>
          </div>
        ))}
      </div>
    </Modal>
  );
}
