/**
 * TopMover - Compact mover display for sidebar
 */

import { cn } from '@/lib/utils';
import { PriceText } from '../atoms/PriceText';
import { ChangeIndicator } from '../atoms/ChangeIndicator';
import { TrendingUp, TrendingDown } from 'lucide-react';

interface TopMoverProps {
  ticker: string;
  title: string;
  price: number;
  change: number;
  onClick?: () => void;
  className?: string;
}

export function TopMover({ title, price, change, onClick, className }: TopMoverProps) {
  const isPositive = change > 0;

  return (
    <div
      className={cn(
        'flex items-center justify-between rounded-md p-2',
        'hover:bg-accent/50 cursor-pointer transition-colors',
        className
      )}
      onClick={onClick}
    >
      <div className="flex min-w-0 items-center gap-2">
        <div className={cn('rounded p-1', isPositive ? 'bg-green-500/20' : 'bg-red-500/20')}>
          {isPositive ? (
            <TrendingUp
              size={12}
              className="text-green-500"
            />
          ) : (
            <TrendingDown
              size={12}
              className="text-red-500"
            />
          )}
        </div>
        <span className="truncate text-sm">{title}</span>
      </div>
      <div className="flex items-center gap-2">
        <PriceText
          value={price}
          size="sm"
        />
        <ChangeIndicator
          value={change}
          size="xs"
          showIcon={false}
        />
      </div>
    </div>
  );
}

export default TopMover;
