/**
 * TopMoversPanel - List of biggest movers
 */

import { cn } from '@/lib/utils';
import { TopMover } from '../molecules/TopMover';

interface Mover {
  ticker: string;
  title: string;
  price: number;
  change: number;
}

interface TopMoversPanelProps {
  movers: Mover[];
  title?: string;
  onMoverClick?: (ticker: string) => void;
  className?: string;
}

export function TopMoversPanel({
  movers,
  title = 'Top Movers',
  onMoverClick,
  className,
}: TopMoversPanelProps) {
  const gainers = movers.filter((m) => m.change > 0).sort((a, b) => b.change - a.change);
  const losers = movers.filter((m) => m.change < 0).sort((a, b) => a.change - b.change);

  return (
    <div className={cn('bg-card border-border/50 overflow-hidden rounded-lg border', className)}>
      <div className="border-border/50 bg-muted/30 border-b px-3 py-2">
        <h3 className="text-sm font-medium">{title}</h3>
      </div>

      <div className="p-2">
        {gainers.length > 0 && (
          <div className="mb-3">
            <div className="mb-1 px-2 text-[10px] uppercase tracking-wider text-green-500">
              Gainers
            </div>
            {gainers.slice(0, 3).map((mover) => (
              <TopMover
                key={mover.ticker}
                ticker={mover.ticker}
                title={mover.title}
                price={mover.price}
                change={mover.change}
                onClick={() => onMoverClick?.(mover.ticker)}
              />
            ))}
          </div>
        )}

        {losers.length > 0 && (
          <div>
            <div className="mb-1 px-2 text-[10px] uppercase tracking-wider text-red-500">
              Losers
            </div>
            {losers.slice(0, 3).map((mover) => (
              <TopMover
                key={mover.ticker}
                ticker={mover.ticker}
                title={mover.title}
                price={mover.price}
                change={mover.change}
                onClick={() => onMoverClick?.(mover.ticker)}
              />
            ))}
          </div>
        )}
      </div>
    </div>
  );
}

export default TopMoversPanel;
