export interface ChangelogEntry {
  version: string;
  date: string;
  title: string;
  changes: string[];
}

export const changelog: ChangelogEntry[] = [
  {
    version: 'v0.3.1',
    date: '2026-02-18',
    title: 'Stability & Auto-Deploy',
    changes: [
      'Inline book panel moved into table row expansion (no more sidebar)',
      'Polymarket outcome token ordering verified from Gamma API',
      'Auto-deploy pipeline — push to staging triggers build + deploy',
      'Stale tab detection — banner prompts reload on new deploy',
      'Refresh cache button in sidebar',
      'Rotation number column limit fix',
      'Queue position polling spam fix',
    ],
  },
  {
    version: 'v0.3.0',
    date: '2026-02-17',
    title: 'Inline Trading',
    changes: [
      'Inline book panel — click game row to show order book',
      'Book sweep — Shift+click odds to stage a sweep order (IOC)',
      'Order book dollar columns (cost + depth $)',
      'Dollar risk/win display on odds cells',
      'Odds API client with rotation numbers and sportsbook odds',
      'Sortable rotation number column on all tables',
      'Odds click opens inline panel (not page navigation)',
    ],
  },
  {
    version: 'v0.2.0',
    date: '2026-02-15',
    title: 'Multi-Sport Odds',
    changes: [
      'NBA + CBB value dashboard with consolidated moneyline tables',
      'Side-by-side Polymarket odds (spreads, totals, moneylines)',
      'Sport hotkeys and click-to-trade from table cells',
      'Inline order quantity editing and unified odds display',
      'Column sorting on all sports table headers',
      'Default chronological sort + 12-hour Vegas time',
      'CBB date filter fix (UTC → local)',
      'Kalshi API deep audit — status filter, pagination, sorting',
    ],
  },
  {
    version: 'v0.1.0',
    date: '2026-02-10',
    title: 'The Big Bang',
    changes: [
      'Trading terminal with Kalshi + Polymarket integration',
      'Market explorer with real-time candlestick charts',
      'Position tracker with P&L calculation',
      'Order management (place, cancel, monitor fills)',
      'RSA-PSS authentication via WebCrypto',
      'Light/dark theme with fintech aesthetic',
      'Credential profiles for multiple accounts',
    ],
  },
];

export const CURRENT_VERSION = changelog[0].version;
