/**
 * Diagnostics Runner
 *
 * Orchestrates diagnostic check execution.
 * Yields results as an async generator so the UI can stream them.
 */

import type { DiagnosticResult, DiagnosticContext } from './types';
import { DIAGNOSTIC_CHECKS, runCheck } from './checks';

/** Run all diagnostic checks, yielding results as they complete */
export async function* runAll(
  ctx: DiagnosticContext
): AsyncGenerator<DiagnosticResult, void, unknown> {
  for (const check of DIAGNOSTIC_CHECKS) {
    yield await runCheck(check.id, ctx);
  }
}

/** Run a single check by ID */
export async function runOne(checkId: string, ctx: DiagnosticContext): Promise<DiagnosticResult> {
  return runCheck(checkId, ctx);
}
