export function fmtProbFromCents(cents: number | null): string {
  if (cents === null) return '—';
  const c = Number(cents);
  if (!Number.isFinite(c)) return '—';
  return `${Math.round(c)}¢`;
}

export function centsToAmericanOdds(cents: number | null): string {
  if (cents === null) return '—';
  const prob = Number(cents) / 100;
  if (!Number.isFinite(prob) || prob <= 0 || prob >= 1) return '—';
  const oneOverProb = 1 / prob;
  let odds: number;
  if (oneOverProb > 2) odds = (oneOverProb - 1) * 100;
  else odds = -100 / (oneOverProb - 1);
  const rounded = Math.round(odds);
  const formatted = Math.abs(rounded).toLocaleString();
  return rounded > 0 ? `+${formatted}` : `-${formatted}`;
}

export function formatDualPriceCents(cents: number | null): string {
  if (cents === null) return '—';
  return `${fmtProbFromCents(cents)} | ${centsToAmericanOdds(cents)}`;
}
