/**
 * View mode settings - persisted to localStorage
 */

import type { ViewMode } from '@/components/nba-value-dashboard/DashboardHeader';

const STORAGE_KEY = 'nba-view-mode';

export function getViewMode(): ViewMode {
  try {
    const stored = localStorage.getItem(STORAGE_KEY);
    if (stored === 'classic') return 'classic';
    return 'two-row'; // default to new 2-row format
  } catch {
    return 'two-row';
  }
}

export function setViewMode(mode: ViewMode): void {
  try {
    localStorage.setItem(STORAGE_KEY, mode);
  } catch {
    // localStorage unavailable
  }
}
