/**
 * Shared size class mappings for consistent component sizing
 */

export type SizeVariant = 'xs' | 'sm' | 'md' | 'lg' | 'xl';

/**
 * Text size classes
 */
export const TEXT_SIZE_CLASSES: Record<SizeVariant, string> = {
  xs: 'text-xs',
  sm: 'text-sm',
  md: 'text-base',
  lg: 'text-lg',
  xl: 'text-2xl font-bold',
};

/**
 * Icon sizes in pixels
 */
export const ICON_SIZES: Record<SizeVariant, number> = {
  xs: 12,
  sm: 14,
  md: 16,
  lg: 20,
  xl: 24,
};

/**
 * Padding classes for cards/containers
 */
export const PADDING_CLASSES: Record<'sm' | 'md' | 'lg', string> = {
  sm: 'p-3',
  md: 'p-4',
  lg: 'p-6',
};

/**
 * Gap classes for flex/grid layouts
 */
export const GAP_CLASSES: Record<'sm' | 'md' | 'lg', string> = {
  sm: 'gap-2',
  md: 'gap-3',
  lg: 'gap-4',
};

/**
 * Avatar/badge dimension classes
 */
export const DIMENSION_CLASSES: Record<SizeVariant, string> = {
  xs: 'w-6 h-6',
  sm: 'w-8 h-8',
  md: 'w-10 h-10',
  lg: 'w-12 h-12',
  xl: 'w-16 h-16',
};

/**
 * Button height classes
 */
export const BUTTON_HEIGHT_CLASSES: Record<'sm' | 'md' | 'lg', string> = {
  sm: 'h-8 px-3 text-xs',
  md: 'h-10 px-4 text-sm',
  lg: 'h-12 px-6 text-base',
};
