/**
 * Format totals line values for sportsbook-style display.
 * Keeps half-points as one decimal (e.g., 210.5) and avoids integer truncation.
 */
export function formatTotalLineValue(line: number | null | undefined): string {
  if (!Number.isFinite(line)) return '—';
  const numeric = line as number;
  return Number.isInteger(numeric) ? String(numeric) : numeric.toFixed(1);
}
