/**
 * React App Entry Point
 */

// Polyfills for browser build (needed by Polymarket/ethers deps under Vite)
import { Buffer } from 'buffer';
// eslint-disable-next-line @typescript-eslint/no-explicit-any
(globalThis as any).Buffer = Buffer;

import React from 'react';
import ReactDOM from 'react-dom/client';
import { BrowserRouter, Routes, Route, Navigate } from 'react-router-dom';
import App from './App';
import { ErrorBoundary } from './components/ErrorBoundary';
import { ThemeProvider } from './contexts/ThemeContext';
import { HotkeyProvider } from './lib/hotkeys';
import './globals.css';
import './styles.css';

// Router basename for subdirectory deployment (e.g., "/decoy_folder/dashboard")
const routerBasename = import.meta.env.VITE_ROUTER_BASE || '';

ReactDOM.createRoot(document.getElementById('root')!).render(
  <React.StrictMode>
    <ThemeProvider>
      <HotkeyProvider>
        <ErrorBoundary>
          <BrowserRouter basename={routerBasename}>
            <Routes>
              {/* Login route */}
              <Route
                path="/"
                element={<App />}
              />

              {/* Authenticated app routes */}
              <Route
                path="/app"
                element={<App />}
              />

              {/* Explore hierarchy routes */}
              <Route
                path="/app/explore"
                element={<App />}
              />
              <Route
                path="/app/explore/:category"
                element={<App />}
              />
              <Route
                path="/app/explore/:category/:series"
                element={<App />}
              />
              <Route
                path="/app/explore/:category/:series/:event"
                element={<App />}
              />

              {/* Direct market route */}
              <Route
                path="/app/market/:ticker"
                element={<App />}
              />

              {/* Other views */}
              <Route
                path="/app/:view"
                element={<App />}
              />

              {/* Catch-all redirect */}
              <Route
                path="*"
                element={
                  <Navigate
                    to="/"
                    replace
                  />
                }
              />
            </Routes>
          </BrowserRouter>
        </ErrorBoundary>
      </HotkeyProvider>
    </ThemeProvider>
  </React.StrictMode>
);
