/**
 * Guide/Lesson type definitions
 */

export type GuideCategory =
  | 'fundamentals'
  | 'sports-betting'
  | 'strategies'
  | 'advanced'
  | 'product'
  | 'developer';

export type Guide = {
  slug: string;
  title: string;
  description: string;
  category: GuideCategory;
  duration: string;
  order: number;
  prerequisites?: string[]; // slugs of prerequisite guides
  nextGuide?: string; // slug of the next guide in sequence
};

export const categoryLabels: Record<GuideCategory, string> = {
  fundamentals: 'Fundamentals',
  'sports-betting': 'Sports Betting',
  strategies: 'Strategies',
  advanced: 'Advanced',
  product: 'Product & UX',
  developer: 'Developer',
};

export const categoryDescriptions: Record<GuideCategory, string> = {
  fundamentals: 'Core concepts for prediction markets',
  'sports-betting': 'Sports betting fundamentals',
  strategies: 'Trading strategies and tactics',
  advanced: 'Advanced techniques for market makers',
  product: 'Understanding users to build better trading software',
  developer: 'API documentation and integration guides',
};
