/**
 * Guide Page
 *
 * Dynamic page that loads the appropriate lesson component based on slug.
 */

import { useParams, Navigate } from 'react-router-dom';
import { getGuide } from '@/data/guides';

// Import lesson components
import { WhatIsKalshiLesson } from '@/components/guides/lessons/WhatIsKalshiLesson';
import { MoneylineLesson } from '@/components/guides/lessons/MoneylineLesson';
import { SportsBetting101Lesson } from '@/components/guides/lessons/SportsBetting101Lesson';
import { ReadingOddsScreenLesson } from '@/components/guides/lessons/ReadingOddsScreenLesson';
import { YesNoMarketsLesson } from '@/components/guides/lessons/YesNoMarketsLesson';
import { BuySellYesNoLesson } from '@/components/guides/lessons/BuySellYesNoLesson';
import { ProbabilityExpectedValueLesson } from '@/components/guides/lessons/ProbabilityExpectedValueLesson';
import { MarketMakingStrategyLesson } from '@/components/guides/lessons/MarketMakingStrategyLesson';
import { RiskManagementLesson } from '@/components/guides/lessons/RiskManagementLesson';
import { VarianceLuckLesson } from '@/components/guides/lessons/VarianceLuckLesson';
import { ReadingOrderFlowLesson } from '@/components/guides/lessons/ReadingOrderFlowLesson';
import { FeesAndCostsLesson } from '@/components/guides/lessons/FeesAndCostsLesson';
import { BuildingForMarketMakersLesson } from '@/components/guides/lessons/BuildingForMarketMakersLesson';
import { MMTradeIdentificationLesson } from '@/components/guides/lessons/MMTradeIdentificationLesson';
import { MMPracticeQuizLesson } from '@/components/guides/lessons/MMPracticeQuizLesson';
import { MarketMakerScenariosLesson } from '@/components/guides/lessons/MarketMakerScenariosLesson';
import { UserInterviewGuideLesson } from '@/components/guides/lessons/UserInterviewGuideLesson';
import { GlossaryLesson } from '@/components/guides/lessons/GlossaryLesson';
import { KalshiApiEntitiesLesson } from '@/components/guides/lessons/KalshiApiEntitiesLesson';
import { KalshiApiExplorerLesson } from '@/components/guides/lessons/KalshiApiExplorerLesson';

// Map slugs to lesson components
const lessonComponents: Record<string, React.ComponentType> = {
  'what-is-kalshi': WhatIsKalshiLesson,
  moneyline: MoneylineLesson,
  'sports-betting-101': SportsBetting101Lesson,
  'reading-odds-screen': ReadingOddsScreenLesson,
  'yes-no-markets': YesNoMarketsLesson,
  'buy-sell-yes-no': BuySellYesNoLesson,
  'probability-expected-value': ProbabilityExpectedValueLesson,
  'market-making-strategy': MarketMakingStrategyLesson,
  'risk-management': RiskManagementLesson,
  'variance-luck': VarianceLuckLesson,
  'reading-order-flow': ReadingOrderFlowLesson,
  'fees-and-costs': FeesAndCostsLesson,
  'building-for-market-makers': BuildingForMarketMakersLesson,
  'mm-trade-identification': MMTradeIdentificationLesson,
  'mm-practice-quiz': MMPracticeQuizLesson,
  'mm-scenarios': MarketMakerScenariosLesson,
  'user-interview-guide': UserInterviewGuideLesson,
  'kalshi-api-entities': KalshiApiEntitiesLesson,
  'kalshi-api-explorer': KalshiApiExplorerLesson,
  glossary: GlossaryLesson,
};

export function GuidePage() {
  const { slug } = useParams<{ slug: string }>();

  if (!slug) {
    return (
      <Navigate
        to="/"
        replace
      />
    );
  }

  const guide = getGuide(slug);
  const LessonComponent = lessonComponents[slug];

  if (!guide || !LessonComponent) {
    return (
      <div className="py-12 text-center">
        <h2 className="mb-2 text-xl font-semibold">Guide not found</h2>
        <p className="text-muted-foreground">
          The guide "{slug}" doesn't exist or hasn't been created yet.
        </p>
      </div>
    );
  }

  return <LessonComponent />;
}
