import path from 'path';
import { defineConfig, loadEnv } from 'vite';
import react from '@vitejs/plugin-react';

export default defineConfig(({ mode }) => {
  const env = loadEnv(mode, __dirname, '');
  const routerBase = env.VITE_ROUTER_BASE?.trim();
  const base = routerBase ? `/${routerBase.replace(/^\/|\/$/g, '')}/` : './';

  return {
    base,
    plugins: [react()],
    resolve: {
      alias: {
        '@': path.resolve(__dirname, './src'),
      },
    },
    // Avoid writing Vite temp/cache files into node_modules
    cacheDir: '.vite',
    server: {
      port: 5174,
      strictPort: true,
      open: true,
    },
    build: {
      outDir: 'dist',
      sourcemap: true,
    },
  };
});
