/**
 * CORS Middleware
 *
 * Configures CORS for Express server.
 */
import cors from 'cors';
/**
 * Creates CORS middleware for Express.
 *
 * - Development: allows all origins
 * - Production: restricts to configured origin(s)
 *
 * @param config - Server configuration
 * @returns Express CORS middleware
 */
export function createCorsMiddleware(config) {
    const corsOptions = {
        origin: config.corsOrigin,
        credentials: true,
        methods: ['GET', 'POST', 'PUT', 'DELETE', 'PATCH', 'OPTIONS'],
        allowedHeaders: ['Content-Type', 'Authorization'],
    };
    return cors(corsOptions);
}
//# sourceMappingURL=cors.js.map