/**
 * Request Validation Middleware
 *
 * Validates HTTP relay requests before processing.
 */
import { RequestHandler } from 'express';
import { ServerConfig } from '../config.js';
/**
 * Express middleware to validate HTTP relay requests.
 *
 * Validates:
 * - Content-Type is application/json
 * - Request body structure
 * - Required fields
 * - Request size limits
 *
 * @param config - Server configuration
 * @returns Express middleware
 */
export declare function createRequestValidator(config: ServerConfig): RequestHandler;
//# sourceMappingURL=requestValidator.d.ts.map