/**
 * PolymarketFetcher — Persistent Polymarket data fetcher.
 *
 * Resolves NBA market token IDs via the Gamma API, then connects to the
 * Polymarket CLOB WebSocket for orderbook streaming. Normalizes bids/asks
 * into the same YES/NO bid-ladder format used by the cache.
 */
import type { ServerConfig } from '../config.js';
import type { Logger } from '../logger.js';
import type { MarketCache } from './MarketCache.js';
export declare class PolymarketFetcher {
    private config;
    private logger;
    private cache;
    private ws;
    private tokenIds;
    private tokenToTicker;
    private refreshTimer;
    private reconnectTimer;
    private reconnectAttempts;
    private maxReconnectAttempts;
    private stopped;
    private _isConnected;
    constructor(config: ServerConfig, logger: Logger, cache: MarketCache);
    get isConnected(): boolean;
    start(): Promise<void>;
    stop(): void;
    private discover;
    private connectWs;
    private subscribeAll;
    private handleWsMessage;
    private scheduleReconnect;
}
//# sourceMappingURL=PolymarketFetcher.d.ts.map