/**
 * StreamBroadcaster — Manages dashboard client WebSocket connections on /stream/markets.
 *
 * - On client subscribe: sends current cache snapshot, registers for live updates
 * - Listens to MarketCache events and broadcasts StreamUpdate to all subscribed clients
 * - Supports ticker filtering (client can subscribe to specific tickers or all)
 * - Periodic status heartbeat every 30s
 */
import { WebSocket } from 'ws';
import type { Logger } from '../logger.js';
import type { MarketCache } from './MarketCache.js';
import type { StreamStatus } from '@galactus/shared';
export declare class StreamBroadcaster {
    private logger;
    private cache;
    private clients;
    private heartbeatTimer;
    private startTime;
    private getKalshiConnected;
    private getPolymarketConnected;
    constructor(logger: Logger, cache: MarketCache, opts: {
        getKalshiConnected: () => boolean;
        getPolymarketConnected: () => boolean;
    });
    start(): void;
    stop(): void;
    /** Handle a new client WebSocket connection. */
    handleClientConnection(ws: WebSocket): void;
    getClientCount(): number;
    getStatus(): StreamStatus;
    private handleClientMessage;
    private broadcastMarketUpdate;
    private broadcastOrderbookUpdate;
    private broadcastStatus;
    private sendToClient;
}
//# sourceMappingURL=StreamBroadcaster.d.ts.map