/**
 * SmartRelay — Orchestrator that wires MarketCache + KalshiFetcher + PolymarketFetcher + StreamBroadcaster.
 *
 * Provides start/stop lifecycle, health stats, and API key management.
 */
import { WebSocket } from 'ws';
import type { ServerConfig } from '../config.js';
import type { Logger } from '../logger.js';
import { ApiKeyStore } from './ApiKeyStore.js';
import type { StreamStatus } from '@galactus/shared';
export declare class SmartRelay {
    private cache;
    private kalshi;
    private polymarket;
    private broadcaster;
    private keyStore;
    private logger;
    constructor(config: ServerConfig, logger: Logger);
    start(): Promise<void>;
    stop(): void;
    /** Handle a new client WebSocket connection (from /stream/markets). */
    handleClientConnection(ws: WebSocket): void;
    /** Get stats for /health and /stream/status endpoints. */
    getStats(): StreamStatus;
    /** Expose the key store for admin endpoints. */
    getKeyStore(): ApiKeyStore;
}
export { MarketCache } from './MarketCache.js';
export { KalshiFetcher } from './KalshiFetcher.js';
export { PolymarketFetcher } from './PolymarketFetcher.js';
export { StreamBroadcaster } from './StreamBroadcaster.js';
export { ApiKeyStore } from './ApiKeyStore.js';
//# sourceMappingURL=index.d.ts.map