/**
 * HTTP Relay Unit Tests
 *
 * Unit tests for HTTP request forwarding.
 */

import { validateHttpRequest } from '../../src/httpRelay';
import { HttpRelayRequest, ValidationError } from '@galactus/shared';

describe('validateHttpRequest', () => {
  it('should validate a correct request', () => {
    const request: HttpRelayRequest = {
      id: 'test-123',
      method: 'GET',
      url: 'https://api.elections.kalshi.com/trade-api/v2/markets',
      headers: {},
    };
    expect(() => validateHttpRequest(request)).not.toThrow();
  });

  it('should throw ValidationError for missing id', () => {
    const request = {
      method: 'GET',
      url: 'https://api.elections.kalshi.com/trade-api/v2/markets',
      headers: {},
    } as HttpRelayRequest;
    expect(() => validateHttpRequest(request)).toThrow(ValidationError);
  });

  it('should throw ValidationError for invalid method', () => {
    const request = {
      id: 'test-123',
      method: 'INVALID' as unknown as HttpRelayRequest['method'],
      url: 'https://api.elections.kalshi.com/trade-api/v2/markets',
      headers: {},
    };
    expect(() => validateHttpRequest(request)).toThrow(ValidationError);
  });

  it('should throw ValidationError for invalid URL', () => {
    const request: HttpRelayRequest = {
      id: 'test-123',
      method: 'GET',
      url: 'not-a-url',
      headers: {},
    };
    expect(() => validateHttpRequest(request)).toThrow(ValidationError);
  });
});

// Note: Integration tests for forwardHttpRequest should be in integration test file
// with mock Kalshi API server
