# Feature Backlog

> Triaged feature requests. Batched into semver version milestones.
> **Priority:** `critical` (affects trading/money), `high` (traders asked for it), `medium` (nice to have), `low` (aspirational)

---

## Unscheduled

| ID    | Request                                                         | Source        | Priority | Notes                                                                           |
| ----- | --------------------------------------------------------------- | ------------- | -------- | ------------------------------------------------------------------------------- |
| F-001 | Batch orders (10x10 for queue position management)              | StreamRift    | low      | Example of sophisticated order strategy                                         |
| F-002 | Telegram alerts (configurable per user, auto-cancel risk)       | StreamRift    | high     | User sets telegram ID + chat ID in settings                                     |
| F-003 | In-app changelog (bottom-left icon, feature/patch history)      | StreamRift    | medium   | Feeds from docs/changelog.md at build time                                      |
| F-004 | Roto numbers for all games (fix first-10 limit)                 | StreamRift    | high     | Odds API limit param — low effort fix                                           |
| F-005 | Pipeline hardening Phase 1A (WS reconnect + circuit break)      | StreamRift    | high     | No blockers                                                                     |
| F-006 | Pipeline hardening Phase 1B (stale data UI — grey/fade)         | StreamRift    | high     | After F-005                                                                     |
| F-007 | Wire Odds API into table UI (sportsbook odds columns)           | StreamRift    | medium   | Blocked by VITE_ODDS_API_KEY                                                    |
| F-008 | ~~Hide volume columns when inline panel is open~~               | StreamRift    | —        | OBSOLETED — volume columns removed entirely (`40491bd`)                         |
| F-009 | Pipeline hardening Phase 2 (Smart Relay default)                | StreamRift    | medium   | Blocked by server-side Kalshi API key (StreamRift action)                       |
| F-010 | Better liquidity columns (Price/American/Liquidity $/Contracts) | The Professor | high     | PARTIAL — venue grouping + vol/liq split shipped (`40491bd`), American odds TBD |
| F-011 | Dollar figures everywhere (cost, payout, P&L on all surfaces)   | The Professor | high     | Drop 2 — extends Money component usage                                          |
| F-012 | Date formatting consistency (12h time, relative dates)          | The Professor | medium   | Drop 2 — standardize across all views                                           |
| F-013 | Remove completed events from active view                        | The Professor | high     | Drop 2 — event lifecycle management                                             |
| F-014 | Color-code live/in-progress events                              | The Professor | medium   | Drop 2 — visual status indicators                                               |
| F-015 | Historic events toggle (show/hide settled markets)              | The Professor | medium   | Drop 2 — archive view                                                           |
| F-016 | MLB support (new sport)                                         | The Professor | high     | Drop 2 — new sport config + discovery                                           |
| F-017 | Doubleheader handling for MLB                                   | The Professor | medium   | Drop 2 — after F-016                                                            |
| F-018 | Daily roto number caching                                       | The Professor | low      | Drop 2 — performance optimization                                               |

---

## Version Schedule

_Versions will be planned here as features are batched into milestones._

| Version | Theme                    | Status  |
| ------- | ------------------------ | ------- |
| v0.5.0  | Stabilization            | planned |
| v0.6.0  | TBD (post-feedback dump) | —       |

---

_Last updated: 2026-02-18 (table column cleanup session — F-008 obsoleted, F-010 partial)_
