# Server Setup Checklist — Multi-Developer Deploy

StreamRift executes this on the g1.newbx.com server. This sets up the infrastructure for streamrift.dev.g1.newbx.com, domino.dev.g1.newbx.com, and the branch-routed deploy pipeline.

---

## Prerequisites

- [x] SSH root access to newbx.com box
- [x] cPanel access
- [x] Let's Encrypt / AutoSSL working
- [ ] Domino's SSH public key (ed25519)

---

## Step 1: Create cPanel Subdomains

In cPanel → Domains (or Subdomains):

1. **Create:** `streamrift.dev.g1.newbx.com`
   - Document root: `~/public_html/streamrift.dev.g1.newbx.com/`

2. **Create:** `domino.dev.g1.newbx.com`
   - Document root: `~/public_html/domino.dev.g1.newbx.com/`

3. **Run AutoSSL** (or wait for it to auto-provision)
   - Verify: `curl -I https://streamrift.dev.g1.newbx.com/`
   - Verify: `curl -I https://domino.dev.g1.newbx.com/`

---

## Step 2: Create Server Directories

```bash
# Build directories
mkdir -p ~/g1-build-streamrift
mkdir -p ~/g1-build-domino

# Deploy hooks directory
mkdir -p ~/deploy-hooks
```

---

## Step 3: Deploy Environment Files

### ~/g1-deploy-streamrift.env

```bash
cat > ~/g1-deploy-streamrift.env << 'EOF'
GIT_REPO="$HOME/git/g1.1.git"
BUILD_DIR="$HOME/g1-build-streamrift"
DASHBOARD_DIR="$HOME/public_html/streamrift.dev.g1.newbx.com"
RELAY_DIR="$HOME/galactus-relay-dev"
STAGING_RELAY_PORT=8789
STAGING_DOMAIN="streamrift.dev.g1.newbx.com"
STAGING_DASHBOARD_PASSWORD_HASH="0c6332552c2e300ec59ea4fb973ee113fba07f6a8dcb6f9c1b7cc41ef6885ce2"
STAGING_ODDS_API_KEY="2bd33590966cef85391e8dc8d7955e3a"
EOF
```

### ~/g1-deploy-domino.env

```bash
cat > ~/g1-deploy-domino.env << 'EOF'
GIT_REPO="$HOME/git/g1.1.git"
BUILD_DIR="$HOME/g1-build-domino"
DASHBOARD_DIR="$HOME/public_html/domino.dev.g1.newbx.com"
RELAY_DIR="$HOME/galactus-relay-dev"
STAGING_RELAY_PORT=8789
STAGING_DOMAIN="domino.dev.g1.newbx.com"
STAGING_DASHBOARD_PASSWORD_HASH="0c6332552c2e300ec59ea4fb973ee113fba07f6a8dcb6f9c1b7cc41ef6885ce2"
STAGING_ODDS_API_KEY="2bd33590966cef85391e8dc8d7955e3a"
EOF
```

**Note:** Both share the same relay (port 8789) and gate password. Update STAGING_ODDS_API_KEY if Domino needs his own.

---

## Step 4: Install Git Hooks

### Pre-receive (branch protection)

```bash
cp ~/g1-build-streamrift/scripts/server-pre-receive.sh ~/git/g1.1.git/hooks/pre-receive
chmod +x ~/git/g1.1.git/hooks/pre-receive
```

### Post-receive (router)

```bash
# Back up existing hook
cp ~/git/g1.1.git/hooks/post-receive ~/git/g1.1.git/hooks/post-receive.backup.$(date +%Y%m%d)

# Install router
cp ~/g1-build-streamrift/scripts/server-post-receive-router.sh ~/git/g1.1.git/hooks/post-receive
chmod +x ~/git/g1.1.git/hooks/post-receive
```

### Branch-specific deploy scripts

```bash
cp ~/g1-build-streamrift/scripts/server-post-receive-streamrift.sh ~/deploy-hooks/post-receive-streamrift.sh
cp ~/g1-build-streamrift/scripts/server-post-receive-domino.sh ~/deploy-hooks/post-receive-domino.sh
cp ~/g1-build-streamrift/scripts/server-post-receive-dev.sh ~/deploy-hooks/post-receive-dev.sh
chmod +x ~/deploy-hooks/*.sh
```

---

## Step 5: SSH Access for Domino

### On Domino's machine:

```bash
ssh-keygen -t ed25519 -C "domino@g1" -f ~/.ssh/g1-domino
# Send ~/.ssh/g1-domino.pub to StreamRift
```

### On the server:

Add to `~/.ssh/authorized_keys`:

```
# StreamRift (full access to all branches)
command="env GALACTUS_USER=streamrift git-shell -c \"$SSH_ORIGINAL_COMMAND\"",no-port-forwarding,no-X11-forwarding,no-agent-forwarding ssh-ed25519 AAAA...existing-streamrift-key... streamrift

# Domino (domino-0 branch only, git operations only)
command="env GALACTUS_USER=domino git-shell -c \"$SSH_ORIGINAL_COMMAND\"",no-port-forwarding,no-X11-forwarding,no-agent-forwarding ssh-ed25519 AAAA...dominos-public-key... domino
```

**Important:** The `command=` prefix restricts Domino to git-shell (no interactive SSH) and sets the `GALACTUS_USER` environment variable that the pre-receive hook checks.

### Domino's SSH config (~/.ssh/config):

```
Host g1
  HostName g1.newbx.com
  User <cpanel-username>
  IdentityFile ~/.ssh/g1-domino
```

### Test:

```bash
# From Domino's machine:
git clone g1:git/g1.1.git galactus
cd galactus
git checkout domino-0
echo "test" >> test.txt
git add test.txt && git commit -m "test: verify domino push"
git push origin domino-0   # Should succeed

git checkout streamrift-0
git push origin streamrift-0  # Should be REJECTED by pre-receive
```

---

## Step 6: Update StreamRift's authorized_keys

StreamRift's existing key needs the `GALACTUS_USER=streamrift` env wrapper too, so the pre-receive hook recognizes it:

```
command="env GALACTUS_USER=streamrift git-shell -c \"$SSH_ORIGINAL_COMMAND\"",no-port-forwarding,no-X11-forwarding,no-agent-forwarding ssh-... streamrift
```

**Or** if StreamRift needs full shell access (not just git), keep the existing key as-is and add a second entry with git-shell for git operations. The pre-receive hook defaults to `streamrift` when `GALACTUS_USER` is unset, so existing access won't break.

---

## Step 7: Verify Everything

```bash
# Test StreamRift deploy
cd /tmp && git clone ~/git/g1.1.git test-sr && cd test-sr
git checkout streamrift-0
git push origin streamrift-0
# Check ~/g1-deploy-streamrift.log
# Check https://streamrift.dev.g1.newbx.com/

# Test Domino deploy (after Domino's key is added)
# From Domino's machine:
git push origin domino-0
# Check ~/g1-deploy-domino.log
# Check https://domino.dev.g1.newbx.com/status.html

# Test dev deploy
git checkout -b dev
git push origin dev
# Check ~/g1-deploy.log
# Check https://dev.g1.newbx.com/
```

---

## Step 8: Create dev Branch

The `dev` branch is the "promoted" shared staging environment:

```bash
cd ~/g1-build-streamrift  # or any working copy
git checkout streamrift-0
git checkout -b dev
git push origin dev
```

This will trigger the dev post-receive hook and deploy to dev.g1.newbx.com.

---

## Quick Reference

| Branch | Deploys to | Config file | Log file | Relay restart? |
|--------|-----------|-------------|----------|---------------|
| `streamrift-0` | streamrift.dev.g1.newbx.com | ~/g1-deploy-streamrift.env | ~/g1-deploy-streamrift.log | Yes |
| `domino-0` | domino.dev.g1.newbx.com | ~/g1-deploy-domino.env | ~/g1-deploy-domino.log | No |
| `dev` | dev.g1.newbx.com | ~/g1-deploy.env | ~/g1-deploy.log | Yes |
