/**
 * Single root ESLint config for monorepo.
 * Used when running eslint from repo root (e.g. lint-staged pre-commit) or from workspaces (via --config).
 */

import js from '@eslint/js';
import tseslint from 'typescript-eslint';
import globals from 'globals';

const sharedRules = {
  '@typescript-eslint/no-unused-vars': [
    'error',
    {
      argsIgnorePattern: '^_',
      varsIgnorePattern: '^_',
      caughtErrorsIgnorePattern: '^_',
    },
  ],
  '@typescript-eslint/no-explicit-any': 'error',
  'no-console': 'off',
  '@typescript-eslint/consistent-type-definitions': 'off',
  '@typescript-eslint/array-type': 'off',
  '@typescript-eslint/prefer-nullish-coalescing': 'off',
  '@typescript-eslint/prefer-optional-chain': 'off',
  '@typescript-eslint/no-inferrable-types': 'off',
};

export default [
  {
    ignores: [
      '**/node_modules/**',
      '**/dist/**',
      '**/build/**',
      '**/coverage/**',
      '**/.vite/**',
      '**/*.config.js',
      '**/*.config.mjs',
      '**/jest.config.cjs',
    ],
  },
  js.configs.recommended,
  ...tseslint.configs.recommended,
  {
    files: ['apps/dashboard/**/*.ts', 'apps/dashboard/**/*.tsx'],
    languageOptions: {
      globals: { ...globals.browser, ...globals.es2020 },
    },
    rules: sharedRules,
  },
  {
    files: ['apps/relay/**/*.ts', 'packages/shared/**/*.ts'],
    languageOptions: {
      globals: { ...globals.node, ...globals.es2020 },
    },
    rules: sharedRules,
  },
];
