/**
 * Path Normalization Tests
 *
 * Unit tests for path normalization utility.
 */

import { normalizePathForSigning } from '../src/utils/pathNormalization';

describe('normalizePathForSigning', () => {
  it('should strip query parameters', () => {
    expect(normalizePathForSigning('/trade-api/v2/markets?limit=10')).toBe('/trade-api/v2/markets');
  });

  it('should ensure leading slash', () => {
    expect(normalizePathForSigning('trade-api/v2/markets')).toBe('/trade-api/v2/markets');
  });

  it('should remove trailing slash', () => {
    expect(normalizePathForSigning('/trade-api/v2/markets/')).toBe('/trade-api/v2/markets');
  });

  it('should preserve root path', () => {
    expect(normalizePathForSigning('/')).toBe('/');
  });

  it('should handle all normalization rules together', () => {
    expect(normalizePathForSigning('trade-api/v2/markets/?limit=10')).toBe('/trade-api/v2/markets');
  });
});
