/**
 * Request ID Tests
 *
 * Unit tests for request ID generation and validation.
 */

import { generateRequestId, isValidRequestId } from '../src/utils/requestId';

describe('generateRequestId', () => {
  it('should generate a unique request ID', () => {
    const id = generateRequestId();
    expect(id).toBeTruthy();
    expect(typeof id).toBe('string');
    expect(id.includes('-')).toBe(true);
  });

  it('should generate different IDs on subsequent calls', () => {
    const id1 = generateRequestId();
    const id2 = generateRequestId();
    expect(id1).not.toBe(id2);
  });
});

describe('isValidRequestId', () => {
  it('should validate correctly formatted request IDs', () => {
    const id = generateRequestId();
    expect(isValidRequestId(id)).toBe(true);
  });

  it('should reject invalid formats', () => {
    expect(isValidRequestId('')).toBe(false);
    expect(isValidRequestId('invalid')).toBe(false);
    expect(isValidRequestId('123')).toBe(false);
    expect(isValidRequestId('123-')).toBe(false);
    expect(isValidRequestId('-abc')).toBe(false);
  });
});
