#!/usr/bin/env bash
#
# post-receive (router) — Routes pushes to branch-specific deploy scripts.
#
# Install to: ~/git/g1.1.git/hooks/post-receive
# Individual deploy scripts live in: ~/deploy-hooks/
#
# Each branch triggers its own deploy script:
#   streamrift-0  →  ~/deploy-hooks/post-receive-streamrift.sh
#   domino-0      →  ~/deploy-hooks/post-receive-domino.sh
#   dev           →  ~/deploy-hooks/post-receive-dev.sh

set -euo pipefail

HOOKS_DIR="$HOME/deploy-hooks"

while read -r oldrev newrev refname; do
  branch="${refname#refs/heads/}"

  case "$branch" in
    streamrift-0)
      echo "post-receive: Routing $branch to StreamRift deploy..."
      bash "$HOOKS_DIR/post-receive-streamrift.sh" "$oldrev" "$newrev" "$branch"
      ;;
    domino-0)
      echo "post-receive: Routing $branch to Domino deploy..."
      bash "$HOOKS_DIR/post-receive-domino.sh" "$oldrev" "$newrev" "$branch"
      ;;
    dev)
      echo "post-receive: Routing $branch to dev.g1 deploy..."
      bash "$HOOKS_DIR/post-receive-dev.sh" "$oldrev" "$newrev" "$branch"
      ;;
    *)
      echo "post-receive: No auto-deploy for branch '$branch' — skipping."
      ;;
  esac
done
